// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mwaa.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an Amazon Managed Workflows for Apache Airflow (MWAA) environment.
 */
public class Environment private constructor(builder: Builder) {
    /**
     * A list of key-value pairs containing the Apache Airflow configuration options attached to your environment. To learn more, see [Apache Airflow configuration options](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html).
     */
    public val airflowConfigurationOptions: Map<String, String>? = builder.airflowConfigurationOptions
    /**
     * The Apache Airflow version on your environment. Valid values: `1.10.12`, `2.0.2`, and `2.2.2`.
     */
    public val airflowVersion: kotlin.String? = builder.airflowVersion
    /**
     * The Amazon Resource Name (ARN) of the Amazon MWAA environment.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The day and time the environment was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The relative path to the DAGs folder on your Amazon S3 bucket. For example, `dags`. To learn more, see [Adding or updating DAGs](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html).
     */
    public val dagS3Path: kotlin.String? = builder.dagS3Path
    /**
     * The environment class type. Valid values: `mw1.small`, `mw1.medium`, `mw1.large`. To learn more, see [Amazon MWAA environment class](https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html).
     */
    public val environmentClass: kotlin.String? = builder.environmentClass
    /**
     * The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access Amazon Web Services resources in your environment. For example, `arn:aws:iam::123456789:role/my-execution-role`. To learn more, see [Amazon MWAA Execution role](https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html).
     */
    public val executionRoleArn: kotlin.String? = builder.executionRoleArn
    /**
     * The Amazon Web Services Key Management Service (KMS) encryption key used to encrypt the data in your environment.
     */
    public val kmsKey: kotlin.String? = builder.kmsKey
    /**
     * The status of the last update on the environment.
     */
    public val lastUpdate: aws.sdk.kotlin.services.mwaa.model.LastUpdate? = builder.lastUpdate
    /**
     * The Apache Airflow logs published to CloudWatch Logs.
     */
    public val loggingConfiguration: aws.sdk.kotlin.services.mwaa.model.LoggingConfiguration? = builder.loggingConfiguration
    /**
     * The maximum number of workers that run in your environment. For example, `20`.
     */
    public val maxWorkers: kotlin.Int? = builder.maxWorkers
    /**
     * The minimum number of workers that run in your environment. For example, `2`.
     */
    public val minWorkers: kotlin.Int? = builder.minWorkers
    /**
     * The name of the Amazon MWAA environment. For example, `MyMWAAEnvironment`.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Describes the VPC networking components used to secure and enable network traffic between the Amazon Web Services resources for your environment. To learn more, see [About networking on Amazon MWAA](https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html).
     */
    public val networkConfiguration: aws.sdk.kotlin.services.mwaa.model.NetworkConfiguration? = builder.networkConfiguration
    /**
     * The version of the plugins.zip file on your Amazon S3 bucket. To learn more, see [Installing custom plugins](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html).
     */
    public val pluginsS3ObjectVersion: kotlin.String? = builder.pluginsS3ObjectVersion
    /**
     * The relative path to the `plugins.zip` file on your Amazon S3 bucket. For example, `plugins.zip`. To learn more, see [Installing custom plugins](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html).
     */
    public val pluginsS3Path: kotlin.String? = builder.pluginsS3Path
    /**
     * The version of the requirements.txt file on your Amazon S3 bucket. To learn more, see [Installing Python dependencies](https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html).
     */
    public val requirementsS3ObjectVersion: kotlin.String? = builder.requirementsS3ObjectVersion
    /**
     * The relative path to the `requirements.txt` file on your Amazon S3 bucket. For example, `requirements.txt`. To learn more, see [Installing Python dependencies](https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html).
     */
    public val requirementsS3Path: kotlin.String? = builder.requirementsS3Path
    /**
     * The number of Apache Airflow schedulers that run in your Amazon MWAA environment.
     */
    public val schedulers: kotlin.Int? = builder.schedulers
    /**
     * The Amazon Resource Name (ARN) for the service-linked role of the environment. To learn more, see [Amazon MWAA Service-linked role](https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-slr.html).
     */
    public val serviceRoleArn: kotlin.String? = builder.serviceRoleArn
    /**
     * The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. For example, `arn:aws:s3:::my-airflow-bucket-unique-name`. To learn more, see [Create an Amazon S3 bucket for Amazon MWAA](https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html).
     */
    public val sourceBucketArn: kotlin.String? = builder.sourceBucketArn
    /**
     * The status of the Amazon MWAA environment. Valid values:
     * + `CREATING` - Indicates the request to create the environment is in progress.
     * + `CREATE_FAILED` - Indicates the request to create the environment failed, and the environment could not be created.
     * + `AVAILABLE` - Indicates the request was successful and the environment is ready to use.
     * + `UPDATING` - Indicates the request to update the environment is in progress.
     * + `DELETING` - Indicates the request to delete the environment is in progress.
     * + `DELETED` - Indicates the request to delete the environment is complete, and the environment has been deleted.
     * + `UNAVAILABLE` - Indicates the request failed, but the environment was unable to rollback and is not in a stable state.
     * + `UPDATE_FAILED` - Indicates the request to update the environment failed, and the environment has rolled back successfully and is ready to use.
     *
     * We recommend reviewing our troubleshooting guide for a list of common errors and their solutions. To learn more, see [Amazon MWAA troubleshooting](https://docs.aws.amazon.com/mwaa/latest/userguide/troubleshooting.html).
     */
    public val status: aws.sdk.kotlin.services.mwaa.model.EnvironmentStatus? = builder.status
    /**
     * The key-value tag pairs associated to your environment. For example, `"Environment": "Staging"`. To learn more, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The Apache Airflow *Web server* access mode. To learn more, see [Apache Airflow access modes](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html).
     */
    public val webserverAccessMode: aws.sdk.kotlin.services.mwaa.model.WebserverAccessMode? = builder.webserverAccessMode
    /**
     * The Apache Airflow *Web server* host name for the Amazon MWAA environment. To learn more, see [Accessing the Apache Airflow UI](https://docs.aws.amazon.com/mwaa/latest/userguide/access-airflow-ui.html).
     */
    public val webserverUrl: kotlin.String? = builder.webserverUrl
    /**
     * The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time that weekly maintenance updates are scheduled. For example: `TUE:03:30`.
     */
    public val weeklyMaintenanceWindowStart: kotlin.String? = builder.weeklyMaintenanceWindowStart

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mwaa.model.Environment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Environment(")
        append("airflowConfigurationOptions=*** Sensitive Data Redacted ***,")
        append("airflowVersion=$airflowVersion,")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("dagS3Path=$dagS3Path,")
        append("environmentClass=$environmentClass,")
        append("executionRoleArn=$executionRoleArn,")
        append("kmsKey=$kmsKey,")
        append("lastUpdate=$lastUpdate,")
        append("loggingConfiguration=$loggingConfiguration,")
        append("maxWorkers=$maxWorkers,")
        append("minWorkers=$minWorkers,")
        append("name=$name,")
        append("networkConfiguration=$networkConfiguration,")
        append("pluginsS3ObjectVersion=$pluginsS3ObjectVersion,")
        append("pluginsS3Path=$pluginsS3Path,")
        append("requirementsS3ObjectVersion=$requirementsS3ObjectVersion,")
        append("requirementsS3Path=$requirementsS3Path,")
        append("schedulers=$schedulers,")
        append("serviceRoleArn=$serviceRoleArn,")
        append("sourceBucketArn=$sourceBucketArn,")
        append("status=$status,")
        append("tags=$tags,")
        append("webserverAccessMode=$webserverAccessMode,")
        append("webserverUrl=$webserverUrl,")
        append("weeklyMaintenanceWindowStart=$weeklyMaintenanceWindowStart)")
    }

    override fun hashCode(): kotlin.Int {
        var result = airflowConfigurationOptions?.hashCode() ?: 0
        result = 31 * result + (airflowVersion?.hashCode() ?: 0)
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (dagS3Path?.hashCode() ?: 0)
        result = 31 * result + (environmentClass?.hashCode() ?: 0)
        result = 31 * result + (executionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (kmsKey?.hashCode() ?: 0)
        result = 31 * result + (lastUpdate?.hashCode() ?: 0)
        result = 31 * result + (loggingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (maxWorkers ?: 0)
        result = 31 * result + (minWorkers ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (networkConfiguration?.hashCode() ?: 0)
        result = 31 * result + (pluginsS3ObjectVersion?.hashCode() ?: 0)
        result = 31 * result + (pluginsS3Path?.hashCode() ?: 0)
        result = 31 * result + (requirementsS3ObjectVersion?.hashCode() ?: 0)
        result = 31 * result + (requirementsS3Path?.hashCode() ?: 0)
        result = 31 * result + (schedulers ?: 0)
        result = 31 * result + (serviceRoleArn?.hashCode() ?: 0)
        result = 31 * result + (sourceBucketArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (webserverAccessMode?.hashCode() ?: 0)
        result = 31 * result + (webserverUrl?.hashCode() ?: 0)
        result = 31 * result + (weeklyMaintenanceWindowStart?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Environment

        if (airflowConfigurationOptions != other.airflowConfigurationOptions) return false
        if (airflowVersion != other.airflowVersion) return false
        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (dagS3Path != other.dagS3Path) return false
        if (environmentClass != other.environmentClass) return false
        if (executionRoleArn != other.executionRoleArn) return false
        if (kmsKey != other.kmsKey) return false
        if (lastUpdate != other.lastUpdate) return false
        if (loggingConfiguration != other.loggingConfiguration) return false
        if (maxWorkers != other.maxWorkers) return false
        if (minWorkers != other.minWorkers) return false
        if (name != other.name) return false
        if (networkConfiguration != other.networkConfiguration) return false
        if (pluginsS3ObjectVersion != other.pluginsS3ObjectVersion) return false
        if (pluginsS3Path != other.pluginsS3Path) return false
        if (requirementsS3ObjectVersion != other.requirementsS3ObjectVersion) return false
        if (requirementsS3Path != other.requirementsS3Path) return false
        if (schedulers != other.schedulers) return false
        if (serviceRoleArn != other.serviceRoleArn) return false
        if (sourceBucketArn != other.sourceBucketArn) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (webserverAccessMode != other.webserverAccessMode) return false
        if (webserverUrl != other.webserverUrl) return false
        if (weeklyMaintenanceWindowStart != other.weeklyMaintenanceWindowStart) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mwaa.model.Environment = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of key-value pairs containing the Apache Airflow configuration options attached to your environment. To learn more, see [Apache Airflow configuration options](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html).
         */
        public var airflowConfigurationOptions: Map<String, String>? = null
        /**
         * The Apache Airflow version on your environment. Valid values: `1.10.12`, `2.0.2`, and `2.2.2`.
         */
        public var airflowVersion: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon MWAA environment.
         */
        public var arn: kotlin.String? = null
        /**
         * The day and time the environment was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The relative path to the DAGs folder on your Amazon S3 bucket. For example, `dags`. To learn more, see [Adding or updating DAGs](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html).
         */
        public var dagS3Path: kotlin.String? = null
        /**
         * The environment class type. Valid values: `mw1.small`, `mw1.medium`, `mw1.large`. To learn more, see [Amazon MWAA environment class](https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html).
         */
        public var environmentClass: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access Amazon Web Services resources in your environment. For example, `arn:aws:iam::123456789:role/my-execution-role`. To learn more, see [Amazon MWAA Execution role](https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html).
         */
        public var executionRoleArn: kotlin.String? = null
        /**
         * The Amazon Web Services Key Management Service (KMS) encryption key used to encrypt the data in your environment.
         */
        public var kmsKey: kotlin.String? = null
        /**
         * The status of the last update on the environment.
         */
        public var lastUpdate: aws.sdk.kotlin.services.mwaa.model.LastUpdate? = null
        /**
         * The Apache Airflow logs published to CloudWatch Logs.
         */
        public var loggingConfiguration: aws.sdk.kotlin.services.mwaa.model.LoggingConfiguration? = null
        /**
         * The maximum number of workers that run in your environment. For example, `20`.
         */
        public var maxWorkers: kotlin.Int? = null
        /**
         * The minimum number of workers that run in your environment. For example, `2`.
         */
        public var minWorkers: kotlin.Int? = null
        /**
         * The name of the Amazon MWAA environment. For example, `MyMWAAEnvironment`.
         */
        public var name: kotlin.String? = null
        /**
         * Describes the VPC networking components used to secure and enable network traffic between the Amazon Web Services resources for your environment. To learn more, see [About networking on Amazon MWAA](https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html).
         */
        public var networkConfiguration: aws.sdk.kotlin.services.mwaa.model.NetworkConfiguration? = null
        /**
         * The version of the plugins.zip file on your Amazon S3 bucket. To learn more, see [Installing custom plugins](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html).
         */
        public var pluginsS3ObjectVersion: kotlin.String? = null
        /**
         * The relative path to the `plugins.zip` file on your Amazon S3 bucket. For example, `plugins.zip`. To learn more, see [Installing custom plugins](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html).
         */
        public var pluginsS3Path: kotlin.String? = null
        /**
         * The version of the requirements.txt file on your Amazon S3 bucket. To learn more, see [Installing Python dependencies](https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html).
         */
        public var requirementsS3ObjectVersion: kotlin.String? = null
        /**
         * The relative path to the `requirements.txt` file on your Amazon S3 bucket. For example, `requirements.txt`. To learn more, see [Installing Python dependencies](https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html).
         */
        public var requirementsS3Path: kotlin.String? = null
        /**
         * The number of Apache Airflow schedulers that run in your Amazon MWAA environment.
         */
        public var schedulers: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) for the service-linked role of the environment. To learn more, see [Amazon MWAA Service-linked role](https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-slr.html).
         */
        public var serviceRoleArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. For example, `arn:aws:s3:::my-airflow-bucket-unique-name`. To learn more, see [Create an Amazon S3 bucket for Amazon MWAA](https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html).
         */
        public var sourceBucketArn: kotlin.String? = null
        /**
         * The status of the Amazon MWAA environment. Valid values:
         * + `CREATING` - Indicates the request to create the environment is in progress.
         * + `CREATE_FAILED` - Indicates the request to create the environment failed, and the environment could not be created.
         * + `AVAILABLE` - Indicates the request was successful and the environment is ready to use.
         * + `UPDATING` - Indicates the request to update the environment is in progress.
         * + `DELETING` - Indicates the request to delete the environment is in progress.
         * + `DELETED` - Indicates the request to delete the environment is complete, and the environment has been deleted.
         * + `UNAVAILABLE` - Indicates the request failed, but the environment was unable to rollback and is not in a stable state.
         * + `UPDATE_FAILED` - Indicates the request to update the environment failed, and the environment has rolled back successfully and is ready to use.
         *
         * We recommend reviewing our troubleshooting guide for a list of common errors and their solutions. To learn more, see [Amazon MWAA troubleshooting](https://docs.aws.amazon.com/mwaa/latest/userguide/troubleshooting.html).
         */
        public var status: aws.sdk.kotlin.services.mwaa.model.EnvironmentStatus? = null
        /**
         * The key-value tag pairs associated to your environment. For example, `"Environment": "Staging"`. To learn more, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
         */
        public var tags: Map<String, String>? = null
        /**
         * The Apache Airflow *Web server* access mode. To learn more, see [Apache Airflow access modes](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html).
         */
        public var webserverAccessMode: aws.sdk.kotlin.services.mwaa.model.WebserverAccessMode? = null
        /**
         * The Apache Airflow *Web server* host name for the Amazon MWAA environment. To learn more, see [Accessing the Apache Airflow UI](https://docs.aws.amazon.com/mwaa/latest/userguide/access-airflow-ui.html).
         */
        public var webserverUrl: kotlin.String? = null
        /**
         * The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time that weekly maintenance updates are scheduled. For example: `TUE:03:30`.
         */
        public var weeklyMaintenanceWindowStart: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mwaa.model.Environment) : this() {
            this.airflowConfigurationOptions = x.airflowConfigurationOptions
            this.airflowVersion = x.airflowVersion
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.dagS3Path = x.dagS3Path
            this.environmentClass = x.environmentClass
            this.executionRoleArn = x.executionRoleArn
            this.kmsKey = x.kmsKey
            this.lastUpdate = x.lastUpdate
            this.loggingConfiguration = x.loggingConfiguration
            this.maxWorkers = x.maxWorkers
            this.minWorkers = x.minWorkers
            this.name = x.name
            this.networkConfiguration = x.networkConfiguration
            this.pluginsS3ObjectVersion = x.pluginsS3ObjectVersion
            this.pluginsS3Path = x.pluginsS3Path
            this.requirementsS3ObjectVersion = x.requirementsS3ObjectVersion
            this.requirementsS3Path = x.requirementsS3Path
            this.schedulers = x.schedulers
            this.serviceRoleArn = x.serviceRoleArn
            this.sourceBucketArn = x.sourceBucketArn
            this.status = x.status
            this.tags = x.tags
            this.webserverAccessMode = x.webserverAccessMode
            this.webserverUrl = x.webserverUrl
            this.weeklyMaintenanceWindowStart = x.weeklyMaintenanceWindowStart
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mwaa.model.Environment = Environment(this)

        /**
         * construct an [aws.sdk.kotlin.services.mwaa.model.LastUpdate] inside the given [block]
         */
        public fun lastUpdate(block: aws.sdk.kotlin.services.mwaa.model.LastUpdate.Builder.() -> kotlin.Unit) {
            this.lastUpdate = aws.sdk.kotlin.services.mwaa.model.LastUpdate.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mwaa.model.LoggingConfiguration] inside the given [block]
         */
        public fun loggingConfiguration(block: aws.sdk.kotlin.services.mwaa.model.LoggingConfiguration.Builder.() -> kotlin.Unit) {
            this.loggingConfiguration = aws.sdk.kotlin.services.mwaa.model.LoggingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mwaa.model.NetworkConfiguration] inside the given [block]
         */
        public fun networkConfiguration(block: aws.sdk.kotlin.services.mwaa.model.NetworkConfiguration.Builder.() -> kotlin.Unit) {
            this.networkConfiguration = aws.sdk.kotlin.services.mwaa.model.NetworkConfiguration.invoke(block)
        }
    }
}
