// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mwaa.model



/**
 * This section contains the Amazon Managed Workflows for Apache Airflow (MWAA) API reference documentation to create an environment. For more information, see [Get started with Amazon Managed Workflows for Apache Airflow](https://docs.aws.amazon.com/mwaa/latest/userguide/get-started.html).
 */
public class CreateEnvironmentRequest private constructor(builder: Builder) {
    /**
     * A list of key-value pairs containing the Apache Airflow configuration options you want to attach to your environment. To learn more, see [Apache Airflow configuration options](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html).
     */
    public val airflowConfigurationOptions: Map<String, String>? = builder.airflowConfigurationOptions
    /**
     * The Apache Airflow version for your environment. If no value is specified, it defaults to the latest version. Valid values: `1.10.12`, `2.0.2`, and `2.2.2`. To learn more, see [Apache Airflow versions on Amazon Managed Workflows for Apache Airflow (MWAA)](https://docs.aws.amazon.com/mwaa/latest/userguide/airflow-versions.html).
     */
    public val airflowVersion: kotlin.String? = builder.airflowVersion
    /**
     * The relative path to the DAGs folder on your Amazon S3 bucket. For example, `dags`. To learn more, see [Adding or updating DAGs](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html).
     */
    public val dagS3Path: kotlin.String? = builder.dagS3Path
    /**
     * The environment class type. Valid values: `mw1.small`, `mw1.medium`, `mw1.large`. To learn more, see [Amazon MWAA environment class](https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html).
     */
    public val environmentClass: kotlin.String? = builder.environmentClass
    /**
     * The Amazon Resource Name (ARN) of the execution role for your environment. An execution role is an Amazon Web Services Identity and Access Management (IAM) role that grants MWAA permission to access Amazon Web Services services and resources used by your environment. For example, `arn:aws:iam::123456789:role/my-execution-role`. To learn more, see [Amazon MWAA Execution role](https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html).
     */
    public val executionRoleArn: kotlin.String? = builder.executionRoleArn
    /**
     * The Amazon Web Services Key Management Service (KMS) key to encrypt the data in your environment. You can use an Amazon Web Services owned CMK, or a Customer managed CMK (advanced). To learn more, see [Create an Amazon MWAA environment](https://docs.aws.amazon.com/mwaa/latest/userguide/create-environment.html).
     */
    public val kmsKey: kotlin.String? = builder.kmsKey
    /**
     * Defines the Apache Airflow logs to send to CloudWatch Logs.
     */
    public val loggingConfiguration: aws.sdk.kotlin.services.mwaa.model.LoggingConfigurationInput? = builder.loggingConfiguration
    /**
     * The maximum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the `MaxWorkers` field. For example, `20`. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the one worker that is included with your environment, or the number you specify in `MinWorkers`.
     */
    public val maxWorkers: kotlin.Int? = builder.maxWorkers
    /**
     * The minimum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the `MaxWorkers` field. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the worker count you specify in the `MinWorkers` field. For example, `2`.
     */
    public val minWorkers: kotlin.Int? = builder.minWorkers
    /**
     * The name of the Amazon MWAA environment. For example, `MyMWAAEnvironment`.
     */
    public val name: kotlin.String? = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The VPC networking components used to secure and enable network traffic between the Amazon Web Services resources for your environment. To learn more, see [About networking on Amazon MWAA](https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html).
     */
    public val networkConfiguration: aws.sdk.kotlin.services.mwaa.model.NetworkConfiguration? = builder.networkConfiguration
    /**
     * The version of the plugins.zip file on your Amazon S3 bucket. A version must be specified each time a plugins.zip file is updated. To learn more, see [How S3 Versioning works](https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html).
     */
    public val pluginsS3ObjectVersion: kotlin.String? = builder.pluginsS3ObjectVersion
    /**
     * The relative path to the `plugins.zip` file on your Amazon S3 bucket. For example, `plugins.zip`. If specified, then the plugins.zip version is required. To learn more, see [Installing custom plugins](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html).
     */
    public val pluginsS3Path: kotlin.String? = builder.pluginsS3Path
    /**
     * The version of the requirements.txt file on your Amazon S3 bucket. A version must be specified each time a requirements.txt file is updated. To learn more, see [How S3 Versioning works](https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html).
     */
    public val requirementsS3ObjectVersion: kotlin.String? = builder.requirementsS3ObjectVersion
    /**
     * The relative path to the `requirements.txt` file on your Amazon S3 bucket. For example, `requirements.txt`. If specified, then a file version is required. To learn more, see [Installing Python dependencies](https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html).
     */
    public val requirementsS3Path: kotlin.String? = builder.requirementsS3Path
    /**
     * The number of Apache Airflow schedulers to run in your environment. Valid values:
     * + v2 - Accepts between 2 to 5. Defaults to 2.
     * + v1 - Accepts 1.
     */
    public val schedulers: kotlin.Int? = builder.schedulers
    /**
     * The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. For example, `arn:aws:s3:::my-airflow-bucket-unique-name`. To learn more, see [Create an Amazon S3 bucket for Amazon MWAA](https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html).
     */
    public val sourceBucketArn: kotlin.String? = builder.sourceBucketArn
    /**
     * The key-value tag pairs you want to associate to your environment. For example, `"Environment": "Staging"`. To learn more, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The Apache Airflow *Web server* access mode. To learn more, see [Apache Airflow access modes](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html).
     */
    public val webserverAccessMode: aws.sdk.kotlin.services.mwaa.model.WebserverAccessMode? = builder.webserverAccessMode
    /**
     * The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time to start weekly maintenance updates of your environment in the following format: `DAY:HH:MM`. For example: `TUE:03:30`. You can specify a start time in 30 minute increments only.
     */
    public val weeklyMaintenanceWindowStart: kotlin.String? = builder.weeklyMaintenanceWindowStart

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mwaa.model.CreateEnvironmentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateEnvironmentRequest(")
        append("airflowConfigurationOptions=*** Sensitive Data Redacted ***,")
        append("airflowVersion=$airflowVersion,")
        append("dagS3Path=$dagS3Path,")
        append("environmentClass=$environmentClass,")
        append("executionRoleArn=$executionRoleArn,")
        append("kmsKey=$kmsKey,")
        append("loggingConfiguration=$loggingConfiguration,")
        append("maxWorkers=$maxWorkers,")
        append("minWorkers=$minWorkers,")
        append("name=$name,")
        append("networkConfiguration=$networkConfiguration,")
        append("pluginsS3ObjectVersion=$pluginsS3ObjectVersion,")
        append("pluginsS3Path=$pluginsS3Path,")
        append("requirementsS3ObjectVersion=$requirementsS3ObjectVersion,")
        append("requirementsS3Path=$requirementsS3Path,")
        append("schedulers=$schedulers,")
        append("sourceBucketArn=$sourceBucketArn,")
        append("tags=$tags,")
        append("webserverAccessMode=$webserverAccessMode,")
        append("weeklyMaintenanceWindowStart=$weeklyMaintenanceWindowStart)")
    }

    override fun hashCode(): kotlin.Int {
        var result = airflowConfigurationOptions?.hashCode() ?: 0
        result = 31 * result + (airflowVersion?.hashCode() ?: 0)
        result = 31 * result + (dagS3Path?.hashCode() ?: 0)
        result = 31 * result + (environmentClass?.hashCode() ?: 0)
        result = 31 * result + (executionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (kmsKey?.hashCode() ?: 0)
        result = 31 * result + (loggingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (maxWorkers ?: 0)
        result = 31 * result + (minWorkers ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (networkConfiguration?.hashCode() ?: 0)
        result = 31 * result + (pluginsS3ObjectVersion?.hashCode() ?: 0)
        result = 31 * result + (pluginsS3Path?.hashCode() ?: 0)
        result = 31 * result + (requirementsS3ObjectVersion?.hashCode() ?: 0)
        result = 31 * result + (requirementsS3Path?.hashCode() ?: 0)
        result = 31 * result + (schedulers ?: 0)
        result = 31 * result + (sourceBucketArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (webserverAccessMode?.hashCode() ?: 0)
        result = 31 * result + (weeklyMaintenanceWindowStart?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateEnvironmentRequest

        if (airflowConfigurationOptions != other.airflowConfigurationOptions) return false
        if (airflowVersion != other.airflowVersion) return false
        if (dagS3Path != other.dagS3Path) return false
        if (environmentClass != other.environmentClass) return false
        if (executionRoleArn != other.executionRoleArn) return false
        if (kmsKey != other.kmsKey) return false
        if (loggingConfiguration != other.loggingConfiguration) return false
        if (maxWorkers != other.maxWorkers) return false
        if (minWorkers != other.minWorkers) return false
        if (name != other.name) return false
        if (networkConfiguration != other.networkConfiguration) return false
        if (pluginsS3ObjectVersion != other.pluginsS3ObjectVersion) return false
        if (pluginsS3Path != other.pluginsS3Path) return false
        if (requirementsS3ObjectVersion != other.requirementsS3ObjectVersion) return false
        if (requirementsS3Path != other.requirementsS3Path) return false
        if (schedulers != other.schedulers) return false
        if (sourceBucketArn != other.sourceBucketArn) return false
        if (tags != other.tags) return false
        if (webserverAccessMode != other.webserverAccessMode) return false
        if (weeklyMaintenanceWindowStart != other.weeklyMaintenanceWindowStart) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mwaa.model.CreateEnvironmentRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of key-value pairs containing the Apache Airflow configuration options you want to attach to your environment. To learn more, see [Apache Airflow configuration options](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html).
         */
        public var airflowConfigurationOptions: Map<String, String>? = null
        /**
         * The Apache Airflow version for your environment. If no value is specified, it defaults to the latest version. Valid values: `1.10.12`, `2.0.2`, and `2.2.2`. To learn more, see [Apache Airflow versions on Amazon Managed Workflows for Apache Airflow (MWAA)](https://docs.aws.amazon.com/mwaa/latest/userguide/airflow-versions.html).
         */
        public var airflowVersion: kotlin.String? = null
        /**
         * The relative path to the DAGs folder on your Amazon S3 bucket. For example, `dags`. To learn more, see [Adding or updating DAGs](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html).
         */
        public var dagS3Path: kotlin.String? = null
        /**
         * The environment class type. Valid values: `mw1.small`, `mw1.medium`, `mw1.large`. To learn more, see [Amazon MWAA environment class](https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html).
         */
        public var environmentClass: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the execution role for your environment. An execution role is an Amazon Web Services Identity and Access Management (IAM) role that grants MWAA permission to access Amazon Web Services services and resources used by your environment. For example, `arn:aws:iam::123456789:role/my-execution-role`. To learn more, see [Amazon MWAA Execution role](https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html).
         */
        public var executionRoleArn: kotlin.String? = null
        /**
         * The Amazon Web Services Key Management Service (KMS) key to encrypt the data in your environment. You can use an Amazon Web Services owned CMK, or a Customer managed CMK (advanced). To learn more, see [Create an Amazon MWAA environment](https://docs.aws.amazon.com/mwaa/latest/userguide/create-environment.html).
         */
        public var kmsKey: kotlin.String? = null
        /**
         * Defines the Apache Airflow logs to send to CloudWatch Logs.
         */
        public var loggingConfiguration: aws.sdk.kotlin.services.mwaa.model.LoggingConfigurationInput? = null
        /**
         * The maximum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the `MaxWorkers` field. For example, `20`. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the one worker that is included with your environment, or the number you specify in `MinWorkers`.
         */
        public var maxWorkers: kotlin.Int? = null
        /**
         * The minimum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the `MaxWorkers` field. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the worker count you specify in the `MinWorkers` field. For example, `2`.
         */
        public var minWorkers: kotlin.Int? = null
        /**
         * The name of the Amazon MWAA environment. For example, `MyMWAAEnvironment`.
         */
        public var name: kotlin.String? = null
        /**
         * The VPC networking components used to secure and enable network traffic between the Amazon Web Services resources for your environment. To learn more, see [About networking on Amazon MWAA](https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html).
         */
        public var networkConfiguration: aws.sdk.kotlin.services.mwaa.model.NetworkConfiguration? = null
        /**
         * The version of the plugins.zip file on your Amazon S3 bucket. A version must be specified each time a plugins.zip file is updated. To learn more, see [How S3 Versioning works](https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html).
         */
        public var pluginsS3ObjectVersion: kotlin.String? = null
        /**
         * The relative path to the `plugins.zip` file on your Amazon S3 bucket. For example, `plugins.zip`. If specified, then the plugins.zip version is required. To learn more, see [Installing custom plugins](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html).
         */
        public var pluginsS3Path: kotlin.String? = null
        /**
         * The version of the requirements.txt file on your Amazon S3 bucket. A version must be specified each time a requirements.txt file is updated. To learn more, see [How S3 Versioning works](https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html).
         */
        public var requirementsS3ObjectVersion: kotlin.String? = null
        /**
         * The relative path to the `requirements.txt` file on your Amazon S3 bucket. For example, `requirements.txt`. If specified, then a file version is required. To learn more, see [Installing Python dependencies](https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html).
         */
        public var requirementsS3Path: kotlin.String? = null
        /**
         * The number of Apache Airflow schedulers to run in your environment. Valid values:
         * + v2 - Accepts between 2 to 5. Defaults to 2.
         * + v1 - Accepts 1.
         */
        public var schedulers: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. For example, `arn:aws:s3:::my-airflow-bucket-unique-name`. To learn more, see [Create an Amazon S3 bucket for Amazon MWAA](https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html).
         */
        public var sourceBucketArn: kotlin.String? = null
        /**
         * The key-value tag pairs you want to associate to your environment. For example, `"Environment": "Staging"`. To learn more, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
         */
        public var tags: Map<String, String>? = null
        /**
         * The Apache Airflow *Web server* access mode. To learn more, see [Apache Airflow access modes](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html).
         */
        public var webserverAccessMode: aws.sdk.kotlin.services.mwaa.model.WebserverAccessMode? = null
        /**
         * The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time to start weekly maintenance updates of your environment in the following format: `DAY:HH:MM`. For example: `TUE:03:30`. You can specify a start time in 30 minute increments only.
         */
        public var weeklyMaintenanceWindowStart: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mwaa.model.CreateEnvironmentRequest) : this() {
            this.airflowConfigurationOptions = x.airflowConfigurationOptions
            this.airflowVersion = x.airflowVersion
            this.dagS3Path = x.dagS3Path
            this.environmentClass = x.environmentClass
            this.executionRoleArn = x.executionRoleArn
            this.kmsKey = x.kmsKey
            this.loggingConfiguration = x.loggingConfiguration
            this.maxWorkers = x.maxWorkers
            this.minWorkers = x.minWorkers
            this.name = x.name
            this.networkConfiguration = x.networkConfiguration
            this.pluginsS3ObjectVersion = x.pluginsS3ObjectVersion
            this.pluginsS3Path = x.pluginsS3Path
            this.requirementsS3ObjectVersion = x.requirementsS3ObjectVersion
            this.requirementsS3Path = x.requirementsS3Path
            this.schedulers = x.schedulers
            this.sourceBucketArn = x.sourceBucketArn
            this.tags = x.tags
            this.webserverAccessMode = x.webserverAccessMode
            this.weeklyMaintenanceWindowStart = x.weeklyMaintenanceWindowStart
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mwaa.model.CreateEnvironmentRequest = CreateEnvironmentRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.mwaa.model.LoggingConfigurationInput] inside the given [block]
         */
        public fun loggingConfiguration(block: aws.sdk.kotlin.services.mwaa.model.LoggingConfigurationInput.Builder.() -> kotlin.Unit) {
            this.loggingConfiguration = aws.sdk.kotlin.services.mwaa.model.LoggingConfigurationInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mwaa.model.NetworkConfiguration] inside the given [block]
         */
        public fun networkConfiguration(block: aws.sdk.kotlin.services.mwaa.model.NetworkConfiguration.Builder.() -> kotlin.Unit) {
            this.networkConfiguration = aws.sdk.kotlin.services.mwaa.model.NetworkConfiguration.invoke(block)
        }
    }
}
