// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mwaa

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.mwaa.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.mwaa.model.*
import aws.sdk.kotlin.services.mwaa.model.CreateCliTokenRequest
import aws.sdk.kotlin.services.mwaa.model.CreateCliTokenResponse
import aws.sdk.kotlin.services.mwaa.model.CreateEnvironmentRequest
import aws.sdk.kotlin.services.mwaa.model.CreateEnvironmentResponse
import aws.sdk.kotlin.services.mwaa.model.CreateWebLoginTokenRequest
import aws.sdk.kotlin.services.mwaa.model.CreateWebLoginTokenResponse
import aws.sdk.kotlin.services.mwaa.model.DeleteEnvironmentRequest
import aws.sdk.kotlin.services.mwaa.model.DeleteEnvironmentResponse
import aws.sdk.kotlin.services.mwaa.model.GetEnvironmentRequest
import aws.sdk.kotlin.services.mwaa.model.GetEnvironmentResponse
import aws.sdk.kotlin.services.mwaa.model.ListEnvironmentsRequest
import aws.sdk.kotlin.services.mwaa.model.ListEnvironmentsResponse
import aws.sdk.kotlin.services.mwaa.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.mwaa.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.mwaa.model.PublishMetricsRequest
import aws.sdk.kotlin.services.mwaa.model.PublishMetricsResponse
import aws.sdk.kotlin.services.mwaa.model.TagResourceRequest
import aws.sdk.kotlin.services.mwaa.model.TagResourceResponse
import aws.sdk.kotlin.services.mwaa.model.UntagResourceRequest
import aws.sdk.kotlin.services.mwaa.model.UntagResourceResponse
import aws.sdk.kotlin.services.mwaa.model.UpdateEnvironmentRequest
import aws.sdk.kotlin.services.mwaa.model.UpdateEnvironmentResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # Amazon Managed Workflows for Apache Airflow
 * This section contains the Amazon Managed Workflows for Apache Airflow (MWAA) API reference documentation. For more information, see [What Is Amazon MWAA?](https://docs.aws.amazon.com/mwaa/latest/userguide/what-is-mwaa.html).
 *
 * **Endpoints**
 * + `api.airflow.{region}.amazonaws.com` - This endpoint is used for environment management.
 *    + [CreateEnvironment](https://docs.aws.amazon.com/mwaa/latest/API/API_CreateEnvironment.html)
 *    + [DeleteEnvironment](https://docs.aws.amazon.com/mwaa/latest/API/API_DeleteEnvironment.html)
 *    + [GetEnvironment](https://docs.aws.amazon.com/mwaa/latest/API/API_GetEnvironment.html)
 *    + [ListEnvironments](https://docs.aws.amazon.com/mwaa/latest/API/API_ListEnvironments.html)
 *    + [ListTagsForResource](https://docs.aws.amazon.com/mwaa/latest/API/API_ListTagsForResource.html)
 *    + [TagResource](https://docs.aws.amazon.com/mwaa/latest/API/API_TagResource.html)
 *    + [UntagResource](https://docs.aws.amazon.com/mwaa/latest/API/API_UntagResource.html)
 *    + [UpdateEnvironment](https://docs.aws.amazon.com/mwaa/latest/API/API_UpdateEnvironment.html)
 * + `env.airflow.{region}.amazonaws.com` - This endpoint is used to operate the Airflow environment.
 *    + [CreateCliToken](https://docs.aws.amazon.com/mwaa/latest/API/API_CreateCliToken.html )
 *    + [CreateWebLoginToken](https://docs.aws.amazon.com/mwaa/latest/API/API_CreateWebLoginToken.html)
 * + `ops.airflow.{region}.amazonaws.com` - This endpoint is used to push environment metrics that track environment health.
 *    + [PublishMetrics](https://docs.aws.amazon.com/mwaa/latest/API/API_PublishMetrics.html )
 *
 * **Regions**
 *
 * For a list of regions that Amazon MWAA supports, see [Region availability](https://docs.aws.amazon.com/mwaa/latest/userguide/what-is-mwaa.html#regions-mwaa) in the *Amazon MWAA User Guide*.
 */
public interface MwaaClient : SdkClient {

    override val serviceName: String
        get() = "MWAA"
    /**
     * MwaaClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): MwaaClient {
            val config = Config.Builder().apply(block).build()
            return DefaultMwaaClient(config)
        }

        public operator fun invoke(config: Config): MwaaClient = DefaultMwaaClient(config)

        /**
         * Construct a [MwaaClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): MwaaClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultMwaaClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a CLI token for the Airflow CLI. To learn more, see [Creating an Apache Airflow CLI token](https://docs.aws.amazon.com/mwaa/latest/userguide/call-mwaa-apis-cli.html).
     */
    public suspend fun createCliToken(input: CreateCliTokenRequest): CreateCliTokenResponse

    /**
     * Creates an Amazon Managed Workflows for Apache Airflow (MWAA) environment.
     */
    public suspend fun createEnvironment(input: CreateEnvironmentRequest): CreateEnvironmentResponse

    /**
     * Creates a web login token for the Airflow Web UI. To learn more, see [Creating an Apache Airflow web login token](https://docs.aws.amazon.com/mwaa/latest/userguide/call-mwaa-apis-web.html).
     */
    public suspend fun createWebLoginToken(input: CreateWebLoginTokenRequest): CreateWebLoginTokenResponse

    /**
     * Deletes an Amazon Managed Workflows for Apache Airflow (MWAA) environment.
     */
    public suspend fun deleteEnvironment(input: DeleteEnvironmentRequest): DeleteEnvironmentResponse

    /**
     * Describes an Amazon Managed Workflows for Apache Airflow (MWAA) environment.
     */
    public suspend fun getEnvironment(input: GetEnvironmentRequest): GetEnvironmentResponse

    /**
     * Lists the Amazon Managed Workflows for Apache Airflow (MWAA) environments.
     */
    public suspend fun listEnvironments(input: ListEnvironmentsRequest = ListEnvironmentsRequest {}): ListEnvironmentsResponse

    /**
     * Lists the key-value tag pairs associated to the Amazon Managed Workflows for Apache Airflow (MWAA) environment. For example, `"Environment": "Staging"`.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * **Internal only**. Publishes environment health metrics to Amazon CloudWatch.
     */
    public suspend fun publishMetrics(input: PublishMetricsRequest): PublishMetricsResponse

    /**
     * Associates key-value tag pairs to your Amazon Managed Workflows for Apache Airflow (MWAA) environment.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes key-value tag pairs associated to your Amazon Managed Workflows for Apache Airflow (MWAA) environment. For example, `"Environment": "Staging"`.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an Amazon Managed Workflows for Apache Airflow (MWAA) environment.
     */
    public suspend fun updateEnvironment(input: UpdateEnvironmentRequest): UpdateEnvironmentResponse
}

/**
 * Creates a CLI token for the Airflow CLI. To learn more, see [Creating an Apache Airflow CLI token](https://docs.aws.amazon.com/mwaa/latest/userguide/call-mwaa-apis-cli.html).
 */
public suspend inline fun MwaaClient.createCliToken(crossinline block: CreateCliTokenRequest.Builder.() -> Unit): CreateCliTokenResponse = createCliToken(CreateCliTokenRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Managed Workflows for Apache Airflow (MWAA) environment.
 */
public suspend inline fun MwaaClient.createEnvironment(crossinline block: CreateEnvironmentRequest.Builder.() -> Unit): CreateEnvironmentResponse = createEnvironment(CreateEnvironmentRequest.Builder().apply(block).build())

/**
 * Creates a web login token for the Airflow Web UI. To learn more, see [Creating an Apache Airflow web login token](https://docs.aws.amazon.com/mwaa/latest/userguide/call-mwaa-apis-web.html).
 */
public suspend inline fun MwaaClient.createWebLoginToken(crossinline block: CreateWebLoginTokenRequest.Builder.() -> Unit): CreateWebLoginTokenResponse = createWebLoginToken(CreateWebLoginTokenRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Managed Workflows for Apache Airflow (MWAA) environment.
 */
public suspend inline fun MwaaClient.deleteEnvironment(crossinline block: DeleteEnvironmentRequest.Builder.() -> Unit): DeleteEnvironmentResponse = deleteEnvironment(DeleteEnvironmentRequest.Builder().apply(block).build())

/**
 * Describes an Amazon Managed Workflows for Apache Airflow (MWAA) environment.
 */
public suspend inline fun MwaaClient.getEnvironment(crossinline block: GetEnvironmentRequest.Builder.() -> Unit): GetEnvironmentResponse = getEnvironment(GetEnvironmentRequest.Builder().apply(block).build())

/**
 * Lists the Amazon Managed Workflows for Apache Airflow (MWAA) environments.
 */
public suspend inline fun MwaaClient.listEnvironments(crossinline block: ListEnvironmentsRequest.Builder.() -> Unit): ListEnvironmentsResponse = listEnvironments(ListEnvironmentsRequest.Builder().apply(block).build())

/**
 * Lists the key-value tag pairs associated to the Amazon Managed Workflows for Apache Airflow (MWAA) environment. For example, `"Environment": "Staging"`.
 */
public suspend inline fun MwaaClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * **Internal only**. Publishes environment health metrics to Amazon CloudWatch.
 */
public suspend inline fun MwaaClient.publishMetrics(crossinline block: PublishMetricsRequest.Builder.() -> Unit): PublishMetricsResponse = publishMetrics(PublishMetricsRequest.Builder().apply(block).build())

/**
 * Associates key-value tag pairs to your Amazon Managed Workflows for Apache Airflow (MWAA) environment.
 */
public suspend inline fun MwaaClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes key-value tag pairs associated to your Amazon Managed Workflows for Apache Airflow (MWAA) environment. For example, `"Environment": "Staging"`.
 */
public suspend inline fun MwaaClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an Amazon Managed Workflows for Apache Airflow (MWAA) environment.
 */
public suspend inline fun MwaaClient.updateEnvironment(crossinline block: UpdateEnvironmentRequest.Builder.() -> Unit): UpdateEnvironmentResponse = updateEnvironment(UpdateEnvironmentRequest.Builder().apply(block).build())
