// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mturk.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.mturk.model.MTurkException
import aws.sdk.kotlin.services.mturk.model.UpdateNotificationSettingsResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class UpdateNotificationSettingsOperationDeserializer: HttpDeserialize<UpdateNotificationSettingsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateNotificationSettingsResponse {
        if (!response.status.isSuccess()) {
            throwUpdateNotificationSettingsError(context, response)
        }
        val builder = UpdateNotificationSettingsResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwUpdateNotificationSettingsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MTurkException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "RequestError" -> RequestErrorDeserializer().deserialize(context, wrappedResponse)
        "ServiceFault" -> ServiceFaultDeserializer().deserialize(context, wrappedResponse)
        else -> MTurkException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
