// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mturk.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.mturk.model.ListWorkersWithQualificationTypeResponse
import aws.sdk.kotlin.services.mturk.model.MTurkException
import aws.sdk.kotlin.services.mturk.model.Qualification
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListWorkersWithQualificationTypeOperationDeserializer: HttpDeserialize<ListWorkersWithQualificationTypeResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListWorkersWithQualificationTypeResponse {
        if (!response.status.isSuccess()) {
            throwListWorkersWithQualificationTypeError(context, response)
        }
        val builder = ListWorkersWithQualificationTypeResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListWorkersWithQualificationTypeOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListWorkersWithQualificationTypeError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MTurkException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "RequestError" -> RequestErrorDeserializer().deserialize(context, wrappedResponse)
        "ServiceFault" -> ServiceFaultDeserializer().deserialize(context, wrappedResponse)
        else -> MTurkException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListWorkersWithQualificationTypeOperationBody(builder: ListWorkersWithQualificationTypeResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val NUMRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("NumResults"))
    val QUALIFICATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Qualifications"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(NUMRESULTS_DESCRIPTOR)
        field(QUALIFICATIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                NUMRESULTS_DESCRIPTOR.index -> builder.numResults = deserializeInt()
                QUALIFICATIONS_DESCRIPTOR.index -> builder.qualifications =
                    deserializer.deserializeList(QUALIFICATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<Qualification>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeQualificationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
