// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mturk.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.mturk.model.BonusPayment
import aws.sdk.kotlin.services.mturk.model.ListBonusPaymentsResponse
import aws.sdk.kotlin.services.mturk.model.MTurkException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListBonusPaymentsOperationDeserializer: HttpDeserialize<ListBonusPaymentsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListBonusPaymentsResponse {
        if (!response.status.isSuccess()) {
            throwListBonusPaymentsError(context, response)
        }
        val builder = ListBonusPaymentsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListBonusPaymentsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListBonusPaymentsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MTurkException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "RequestError" -> RequestErrorDeserializer().deserialize(context, wrappedResponse)
        "ServiceFault" -> ServiceFaultDeserializer().deserialize(context, wrappedResponse)
        else -> MTurkException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListBonusPaymentsOperationBody(builder: ListBonusPaymentsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BONUSPAYMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("BonusPayments"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val NUMRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("NumResults"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BONUSPAYMENTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(NUMRESULTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BONUSPAYMENTS_DESCRIPTOR.index -> builder.bonusPayments =
                    deserializer.deserializeList(BONUSPAYMENTS_DESCRIPTOR) {
                        val col0 = mutableListOf<BonusPayment>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBonusPaymentDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                NUMRESULTS_DESCRIPTOR.index -> builder.numResults = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
