// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mturk.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.mturk.model.GetAccountBalanceResponse
import aws.sdk.kotlin.services.mturk.model.MTurkException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetAccountBalanceOperationDeserializer: HttpDeserialize<GetAccountBalanceResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetAccountBalanceResponse {
        if (!response.status.isSuccess()) {
            throwGetAccountBalanceError(context, response)
        }
        val builder = GetAccountBalanceResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetAccountBalanceOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetAccountBalanceError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MTurkException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "RequestError" -> RequestErrorDeserializer().deserialize(context, wrappedResponse)
        "ServiceFault" -> ServiceFaultDeserializer().deserialize(context, wrappedResponse)
        else -> MTurkException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetAccountBalanceOperationBody(builder: GetAccountBalanceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AVAILABLEBALANCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AvailableBalance"))
    val ONHOLDBALANCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OnHoldBalance"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AVAILABLEBALANCE_DESCRIPTOR)
        field(ONHOLDBALANCE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AVAILABLEBALANCE_DESCRIPTOR.index -> builder.availableBalance = deserializeString()
                ONHOLDBALANCE_DESCRIPTOR.index -> builder.onHoldBalance = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
