// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mturk.paginators

import aws.sdk.kotlin.services.mturk.MTurkClient
import aws.sdk.kotlin.services.mturk.model.ListAssignmentsForHitRequest
import aws.sdk.kotlin.services.mturk.model.ListAssignmentsForHitResponse
import aws.sdk.kotlin.services.mturk.model.ListBonusPaymentsRequest
import aws.sdk.kotlin.services.mturk.model.ListBonusPaymentsResponse
import aws.sdk.kotlin.services.mturk.model.ListHiTsForQualificationTypeRequest
import aws.sdk.kotlin.services.mturk.model.ListHiTsForQualificationTypeResponse
import aws.sdk.kotlin.services.mturk.model.ListHiTsRequest
import aws.sdk.kotlin.services.mturk.model.ListHiTsResponse
import aws.sdk.kotlin.services.mturk.model.ListQualificationRequestsRequest
import aws.sdk.kotlin.services.mturk.model.ListQualificationRequestsResponse
import aws.sdk.kotlin.services.mturk.model.ListQualificationTypesRequest
import aws.sdk.kotlin.services.mturk.model.ListQualificationTypesResponse
import aws.sdk.kotlin.services.mturk.model.ListReviewPolicyResultsForHitRequest
import aws.sdk.kotlin.services.mturk.model.ListReviewPolicyResultsForHitResponse
import aws.sdk.kotlin.services.mturk.model.ListReviewableHiTsRequest
import aws.sdk.kotlin.services.mturk.model.ListReviewableHiTsResponse
import aws.sdk.kotlin.services.mturk.model.ListWorkerBlocksRequest
import aws.sdk.kotlin.services.mturk.model.ListWorkerBlocksResponse
import aws.sdk.kotlin.services.mturk.model.ListWorkersWithQualificationTypeRequest
import aws.sdk.kotlin.services.mturk.model.ListWorkersWithQualificationTypeResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListAssignmentsForHitResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAssignmentsForHitRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssignmentsForHitResponse]
 */
public fun MTurkClient.listAssignmentsForHitPaginated(initialRequest: ListAssignmentsForHitRequest): Flow<ListAssignmentsForHitResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAssignmentsForHitPaginated.listAssignmentsForHit(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAssignmentsForHitResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssignmentsForHitResponse]
 */
public fun MTurkClient.listAssignmentsForHitPaginated(block: ListAssignmentsForHitRequest.Builder.() -> Unit): Flow<ListAssignmentsForHitResponse> =
    listAssignmentsForHitPaginated(ListAssignmentsForHitRequest.Builder().apply(block).build())

/**
 * Paginate over [ListBonusPaymentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListBonusPaymentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBonusPaymentsResponse]
 */
public fun MTurkClient.listBonusPaymentsPaginated(initialRequest: ListBonusPaymentsRequest): Flow<ListBonusPaymentsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listBonusPaymentsPaginated.listBonusPayments(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListBonusPaymentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBonusPaymentsResponse]
 */
public fun MTurkClient.listBonusPaymentsPaginated(block: ListBonusPaymentsRequest.Builder.() -> Unit): Flow<ListBonusPaymentsResponse> =
    listBonusPaymentsPaginated(ListBonusPaymentsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListHiTsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListHiTsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListHiTsResponse]
 */
public fun MTurkClient.listHiTsPaginated(initialRequest: ListHiTsRequest): Flow<ListHiTsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listHiTsPaginated.listHiTs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListHiTsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListHiTsResponse]
 */
public fun MTurkClient.listHiTsPaginated(block: ListHiTsRequest.Builder.() -> Unit): Flow<ListHiTsResponse> =
    listHiTsPaginated(ListHiTsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListHiTsForQualificationTypeResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListHiTsForQualificationTypeRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListHiTsForQualificationTypeResponse]
 */
public fun MTurkClient.listHiTsForQualificationTypePaginated(initialRequest: ListHiTsForQualificationTypeRequest): Flow<ListHiTsForQualificationTypeResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listHiTsForQualificationTypePaginated.listHiTsForQualificationType(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListHiTsForQualificationTypeResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListHiTsForQualificationTypeResponse]
 */
public fun MTurkClient.listHiTsForQualificationTypePaginated(block: ListHiTsForQualificationTypeRequest.Builder.() -> Unit): Flow<ListHiTsForQualificationTypeResponse> =
    listHiTsForQualificationTypePaginated(ListHiTsForQualificationTypeRequest.Builder().apply(block).build())

/**
 * Paginate over [ListQualificationRequestsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListQualificationRequestsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListQualificationRequestsResponse]
 */
public fun MTurkClient.listQualificationRequestsPaginated(initialRequest: ListQualificationRequestsRequest): Flow<ListQualificationRequestsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listQualificationRequestsPaginated.listQualificationRequests(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListQualificationRequestsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListQualificationRequestsResponse]
 */
public fun MTurkClient.listQualificationRequestsPaginated(block: ListQualificationRequestsRequest.Builder.() -> Unit): Flow<ListQualificationRequestsResponse> =
    listQualificationRequestsPaginated(ListQualificationRequestsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListQualificationTypesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListQualificationTypesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListQualificationTypesResponse]
 */
public fun MTurkClient.listQualificationTypesPaginated(initialRequest: ListQualificationTypesRequest): Flow<ListQualificationTypesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listQualificationTypesPaginated.listQualificationTypes(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListQualificationTypesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListQualificationTypesResponse]
 */
public fun MTurkClient.listQualificationTypesPaginated(block: ListQualificationTypesRequest.Builder.() -> Unit): Flow<ListQualificationTypesResponse> =
    listQualificationTypesPaginated(ListQualificationTypesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListReviewableHiTsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListReviewableHiTsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListReviewableHiTsResponse]
 */
public fun MTurkClient.listReviewableHiTsPaginated(initialRequest: ListReviewableHiTsRequest): Flow<ListReviewableHiTsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listReviewableHiTsPaginated.listReviewableHiTs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListReviewableHiTsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListReviewableHiTsResponse]
 */
public fun MTurkClient.listReviewableHiTsPaginated(block: ListReviewableHiTsRequest.Builder.() -> Unit): Flow<ListReviewableHiTsResponse> =
    listReviewableHiTsPaginated(ListReviewableHiTsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListReviewPolicyResultsForHitResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListReviewPolicyResultsForHitRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListReviewPolicyResultsForHitResponse]
 */
public fun MTurkClient.listReviewPolicyResultsForHitPaginated(initialRequest: ListReviewPolicyResultsForHitRequest): Flow<ListReviewPolicyResultsForHitResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listReviewPolicyResultsForHitPaginated.listReviewPolicyResultsForHit(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListReviewPolicyResultsForHitResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListReviewPolicyResultsForHitResponse]
 */
public fun MTurkClient.listReviewPolicyResultsForHitPaginated(block: ListReviewPolicyResultsForHitRequest.Builder.() -> Unit): Flow<ListReviewPolicyResultsForHitResponse> =
    listReviewPolicyResultsForHitPaginated(ListReviewPolicyResultsForHitRequest.Builder().apply(block).build())

/**
 * Paginate over [ListWorkerBlocksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWorkerBlocksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkerBlocksResponse]
 */
public fun MTurkClient.listWorkerBlocksPaginated(initialRequest: ListWorkerBlocksRequest): Flow<ListWorkerBlocksResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWorkerBlocksPaginated.listWorkerBlocks(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListWorkerBlocksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkerBlocksResponse]
 */
public fun MTurkClient.listWorkerBlocksPaginated(block: ListWorkerBlocksRequest.Builder.() -> Unit): Flow<ListWorkerBlocksResponse> =
    listWorkerBlocksPaginated(ListWorkerBlocksRequest.Builder().apply(block).build())

/**
 * Paginate over [ListWorkersWithQualificationTypeResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWorkersWithQualificationTypeRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkersWithQualificationTypeResponse]
 */
public fun MTurkClient.listWorkersWithQualificationTypePaginated(initialRequest: ListWorkersWithQualificationTypeRequest): Flow<ListWorkersWithQualificationTypeResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWorkersWithQualificationTypePaginated.listWorkersWithQualificationType(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListWorkersWithQualificationTypeResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkersWithQualificationTypeResponse]
 */
public fun MTurkClient.listWorkersWithQualificationTypePaginated(block: ListWorkersWithQualificationTypeRequest.Builder.() -> Unit): Flow<ListWorkersWithQualificationTypeResponse> =
    listWorkersWithQualificationTypePaginated(ListWorkersWithQualificationTypeRequest.Builder().apply(block).build())
