// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mturk.model



public class UpdateQualificationTypeRequest private constructor(builder: Builder) {
    /**
     * The answers to the Qualification test specified in the Test parameter, in the form of an AnswerKey data structure.
     */
    public val answerKey: kotlin.String? = builder.answerKey
    /**
     * Specifies whether requests for the Qualification type are granted immediately, without prompting the Worker with a Qualification test.
     *
     * Constraints: If the Test parameter is specified, this parameter cannot be true.
     */
    public val autoGranted: kotlin.Boolean? = builder.autoGranted
    /**
     * The Qualification value to use for automatically granted Qualifications. This parameter is used only if the AutoGranted parameter is true.
     */
    public val autoGrantedValue: kotlin.Int? = builder.autoGrantedValue
    /**
     * The new description of the Qualification type.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The ID of the Qualification type to update.
     */
    public val qualificationTypeId: kotlin.String? = builder.qualificationTypeId
    /**
     * The new status of the Qualification type - Active | Inactive
     */
    public val qualificationTypeStatus: aws.sdk.kotlin.services.mturk.model.QualificationTypeStatus? = builder.qualificationTypeStatus
    /**
     * The amount of time, in seconds, that Workers must wait after requesting a Qualification of the specified Qualification type before they can retry the Qualification request. It is not possible to disable retries for a Qualification type after it has been created with retries enabled. If you want to disable retries, you must dispose of the existing retry-enabled Qualification type using DisposeQualificationType and then create a new Qualification type with retries disabled using CreateQualificationType.
     */
    public val retryDelayInSeconds: kotlin.Long? = builder.retryDelayInSeconds
    /**
     * The questions for the Qualification test a Worker must answer correctly to obtain a Qualification of this type. If this parameter is specified, `TestDurationInSeconds` must also be specified.
     *
     * Constraints: Must not be longer than 65535 bytes. Must be a QuestionForm data structure. This parameter cannot be specified if AutoGranted is true.
     *
     * Constraints: None. If not specified, the Worker may request the Qualification without answering any questions.
     */
    public val test: kotlin.String? = builder.test
    /**
     * The number of seconds the Worker has to complete the Qualification test, starting from the time the Worker requests the Qualification.
     */
    public val testDurationInSeconds: kotlin.Long? = builder.testDurationInSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mturk.model.UpdateQualificationTypeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateQualificationTypeRequest(")
        append("answerKey=$answerKey,")
        append("autoGranted=$autoGranted,")
        append("autoGrantedValue=$autoGrantedValue,")
        append("description=$description,")
        append("qualificationTypeId=$qualificationTypeId,")
        append("qualificationTypeStatus=$qualificationTypeStatus,")
        append("retryDelayInSeconds=$retryDelayInSeconds,")
        append("test=$test,")
        append("testDurationInSeconds=$testDurationInSeconds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = answerKey?.hashCode() ?: 0
        result = 31 * result + (autoGranted?.hashCode() ?: 0)
        result = 31 * result + (autoGrantedValue ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (qualificationTypeId?.hashCode() ?: 0)
        result = 31 * result + (qualificationTypeStatus?.hashCode() ?: 0)
        result = 31 * result + (retryDelayInSeconds?.hashCode() ?: 0)
        result = 31 * result + (test?.hashCode() ?: 0)
        result = 31 * result + (testDurationInSeconds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateQualificationTypeRequest

        if (answerKey != other.answerKey) return false
        if (autoGranted != other.autoGranted) return false
        if (autoGrantedValue != other.autoGrantedValue) return false
        if (description != other.description) return false
        if (qualificationTypeId != other.qualificationTypeId) return false
        if (qualificationTypeStatus != other.qualificationTypeStatus) return false
        if (retryDelayInSeconds != other.retryDelayInSeconds) return false
        if (test != other.test) return false
        if (testDurationInSeconds != other.testDurationInSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mturk.model.UpdateQualificationTypeRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The answers to the Qualification test specified in the Test parameter, in the form of an AnswerKey data structure.
         */
        public var answerKey: kotlin.String? = null
        /**
         * Specifies whether requests for the Qualification type are granted immediately, without prompting the Worker with a Qualification test.
         *
         * Constraints: If the Test parameter is specified, this parameter cannot be true.
         */
        public var autoGranted: kotlin.Boolean? = null
        /**
         * The Qualification value to use for automatically granted Qualifications. This parameter is used only if the AutoGranted parameter is true.
         */
        public var autoGrantedValue: kotlin.Int? = null
        /**
         * The new description of the Qualification type.
         */
        public var description: kotlin.String? = null
        /**
         * The ID of the Qualification type to update.
         */
        public var qualificationTypeId: kotlin.String? = null
        /**
         * The new status of the Qualification type - Active | Inactive
         */
        public var qualificationTypeStatus: aws.sdk.kotlin.services.mturk.model.QualificationTypeStatus? = null
        /**
         * The amount of time, in seconds, that Workers must wait after requesting a Qualification of the specified Qualification type before they can retry the Qualification request. It is not possible to disable retries for a Qualification type after it has been created with retries enabled. If you want to disable retries, you must dispose of the existing retry-enabled Qualification type using DisposeQualificationType and then create a new Qualification type with retries disabled using CreateQualificationType.
         */
        public var retryDelayInSeconds: kotlin.Long? = null
        /**
         * The questions for the Qualification test a Worker must answer correctly to obtain a Qualification of this type. If this parameter is specified, `TestDurationInSeconds` must also be specified.
         *
         * Constraints: Must not be longer than 65535 bytes. Must be a QuestionForm data structure. This parameter cannot be specified if AutoGranted is true.
         *
         * Constraints: None. If not specified, the Worker may request the Qualification without answering any questions.
         */
        public var test: kotlin.String? = null
        /**
         * The number of seconds the Worker has to complete the Qualification test, starting from the time the Worker requests the Qualification.
         */
        public var testDurationInSeconds: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mturk.model.UpdateQualificationTypeRequest) : this() {
            this.answerKey = x.answerKey
            this.autoGranted = x.autoGranted
            this.autoGrantedValue = x.autoGrantedValue
            this.description = x.description
            this.qualificationTypeId = x.qualificationTypeId
            this.qualificationTypeStatus = x.qualificationTypeStatus
            this.retryDelayInSeconds = x.retryDelayInSeconds
            this.test = x.test
            this.testDurationInSeconds = x.testDurationInSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mturk.model.UpdateQualificationTypeRequest = UpdateQualificationTypeRequest(this)
    }
}
