// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mturk.model



public class CreateHitWithHitTypeRequest private constructor(builder: Builder) {
    /**
     * The Assignment-level Review Policy applies to the assignments under the HIT. You can specify for Mechanical Turk to take various actions based on the policy.
     */
    public val assignmentReviewPolicy: aws.sdk.kotlin.services.mturk.model.ReviewPolicy? = builder.assignmentReviewPolicy
    /**
     * The HITLayoutId allows you to use a pre-existing HIT design with placeholder values and create an additional HIT by providing those values as HITLayoutParameters.
     *
     *  Constraints: Either a Question parameter or a HITLayoutId parameter must be provided.
     */
    public val hitLayoutId: kotlin.String? = builder.hitLayoutId
    /**
     * If the HITLayoutId is provided, any placeholder values must be filled in with values using the HITLayoutParameter structure. For more information, see HITLayout.
     */
    public val hitLayoutParameters: List<HitLayoutParameter>? = builder.hitLayoutParameters
    /**
     * The HIT-level Review Policy applies to the HIT. You can specify for Mechanical Turk to take various actions based on the policy.
     */
    public val hitReviewPolicy: aws.sdk.kotlin.services.mturk.model.ReviewPolicy? = builder.hitReviewPolicy
    /**
     * The HIT type ID you want to create this HIT with.
     */
    public val hitTypeId: kotlin.String? = builder.hitTypeId
    /**
     * An amount of time, in seconds, after which the HIT is no longer available for users to accept. After the lifetime of the HIT elapses, the HIT no longer appears in HIT searches, even if not all of the assignments for the HIT have been accepted.
     */
    public val lifetimeInSeconds: kotlin.Long? = builder.lifetimeInSeconds
    /**
     * The number of times the HIT can be accepted and completed before the HIT becomes unavailable.
     */
    public val maxAssignments: kotlin.Int? = builder.maxAssignments
    /**
     * The data the person completing the HIT uses to produce the results.
     *
     *  Constraints: Must be a QuestionForm data structure, an ExternalQuestion data structure, or an HTMLQuestion data structure. The XML question data must not be larger than 64 kilobytes (65,535 bytes) in size, including whitespace.
     *
     * Either a Question parameter or a HITLayoutId parameter must be provided.
     */
    public val question: kotlin.String? = builder.question
    /**
     * An arbitrary data field. The RequesterAnnotation parameter lets your application attach arbitrary data to the HIT for tracking purposes. For example, this parameter could be an identifier internal to the Requester's application that corresponds with the HIT.
     *
     *  The RequesterAnnotation parameter for a HIT is only visible to the Requester who created the HIT. It is not shown to the Worker, or any other Requester.
     *
     *  The RequesterAnnotation parameter may be different for each HIT you submit. It does not affect how your HITs are grouped.
     */
    public val requesterAnnotation: kotlin.String? = builder.requesterAnnotation
    /**
     * A unique identifier for this request which allows you to retry the call on error without creating duplicate HITs. This is useful in cases such as network timeouts where it is unclear whether or not the call succeeded on the server. If the HIT already exists in the system from a previous call using the same UniqueRequestToken, subsequent calls will return a AWS.MechanicalTurk.HitAlreadyExists error with a message containing the HITId.
     *
     *  Note: It is your responsibility to ensure uniqueness of the token. The unique token expires after 24 hours. Subsequent calls using the same UniqueRequestToken made after the 24 hour limit could create duplicate HITs.
     */
    public val uniqueRequestToken: kotlin.String? = builder.uniqueRequestToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mturk.model.CreateHitWithHitTypeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateHitWithHitTypeRequest(")
        append("assignmentReviewPolicy=$assignmentReviewPolicy,")
        append("hitLayoutId=$hitLayoutId,")
        append("hitLayoutParameters=$hitLayoutParameters,")
        append("hitReviewPolicy=$hitReviewPolicy,")
        append("hitTypeId=$hitTypeId,")
        append("lifetimeInSeconds=$lifetimeInSeconds,")
        append("maxAssignments=$maxAssignments,")
        append("question=$question,")
        append("requesterAnnotation=$requesterAnnotation,")
        append("uniqueRequestToken=$uniqueRequestToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assignmentReviewPolicy?.hashCode() ?: 0
        result = 31 * result + (hitLayoutId?.hashCode() ?: 0)
        result = 31 * result + (hitLayoutParameters?.hashCode() ?: 0)
        result = 31 * result + (hitReviewPolicy?.hashCode() ?: 0)
        result = 31 * result + (hitTypeId?.hashCode() ?: 0)
        result = 31 * result + (lifetimeInSeconds?.hashCode() ?: 0)
        result = 31 * result + (maxAssignments ?: 0)
        result = 31 * result + (question?.hashCode() ?: 0)
        result = 31 * result + (requesterAnnotation?.hashCode() ?: 0)
        result = 31 * result + (uniqueRequestToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateHitWithHitTypeRequest

        if (assignmentReviewPolicy != other.assignmentReviewPolicy) return false
        if (hitLayoutId != other.hitLayoutId) return false
        if (hitLayoutParameters != other.hitLayoutParameters) return false
        if (hitReviewPolicy != other.hitReviewPolicy) return false
        if (hitTypeId != other.hitTypeId) return false
        if (lifetimeInSeconds != other.lifetimeInSeconds) return false
        if (maxAssignments != other.maxAssignments) return false
        if (question != other.question) return false
        if (requesterAnnotation != other.requesterAnnotation) return false
        if (uniqueRequestToken != other.uniqueRequestToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mturk.model.CreateHitWithHitTypeRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Assignment-level Review Policy applies to the assignments under the HIT. You can specify for Mechanical Turk to take various actions based on the policy.
         */
        public var assignmentReviewPolicy: aws.sdk.kotlin.services.mturk.model.ReviewPolicy? = null
        /**
         * The HITLayoutId allows you to use a pre-existing HIT design with placeholder values and create an additional HIT by providing those values as HITLayoutParameters.
         *
         *  Constraints: Either a Question parameter or a HITLayoutId parameter must be provided.
         */
        public var hitLayoutId: kotlin.String? = null
        /**
         * If the HITLayoutId is provided, any placeholder values must be filled in with values using the HITLayoutParameter structure. For more information, see HITLayout.
         */
        public var hitLayoutParameters: List<HitLayoutParameter>? = null
        /**
         * The HIT-level Review Policy applies to the HIT. You can specify for Mechanical Turk to take various actions based on the policy.
         */
        public var hitReviewPolicy: aws.sdk.kotlin.services.mturk.model.ReviewPolicy? = null
        /**
         * The HIT type ID you want to create this HIT with.
         */
        public var hitTypeId: kotlin.String? = null
        /**
         * An amount of time, in seconds, after which the HIT is no longer available for users to accept. After the lifetime of the HIT elapses, the HIT no longer appears in HIT searches, even if not all of the assignments for the HIT have been accepted.
         */
        public var lifetimeInSeconds: kotlin.Long? = null
        /**
         * The number of times the HIT can be accepted and completed before the HIT becomes unavailable.
         */
        public var maxAssignments: kotlin.Int? = null
        /**
         * The data the person completing the HIT uses to produce the results.
         *
         *  Constraints: Must be a QuestionForm data structure, an ExternalQuestion data structure, or an HTMLQuestion data structure. The XML question data must not be larger than 64 kilobytes (65,535 bytes) in size, including whitespace.
         *
         * Either a Question parameter or a HITLayoutId parameter must be provided.
         */
        public var question: kotlin.String? = null
        /**
         * An arbitrary data field. The RequesterAnnotation parameter lets your application attach arbitrary data to the HIT for tracking purposes. For example, this parameter could be an identifier internal to the Requester's application that corresponds with the HIT.
         *
         *  The RequesterAnnotation parameter for a HIT is only visible to the Requester who created the HIT. It is not shown to the Worker, or any other Requester.
         *
         *  The RequesterAnnotation parameter may be different for each HIT you submit. It does not affect how your HITs are grouped.
         */
        public var requesterAnnotation: kotlin.String? = null
        /**
         * A unique identifier for this request which allows you to retry the call on error without creating duplicate HITs. This is useful in cases such as network timeouts where it is unclear whether or not the call succeeded on the server. If the HIT already exists in the system from a previous call using the same UniqueRequestToken, subsequent calls will return a AWS.MechanicalTurk.HitAlreadyExists error with a message containing the HITId.
         *
         *  Note: It is your responsibility to ensure uniqueness of the token. The unique token expires after 24 hours. Subsequent calls using the same UniqueRequestToken made after the 24 hour limit could create duplicate HITs.
         */
        public var uniqueRequestToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mturk.model.CreateHitWithHitTypeRequest) : this() {
            this.assignmentReviewPolicy = x.assignmentReviewPolicy
            this.hitLayoutId = x.hitLayoutId
            this.hitLayoutParameters = x.hitLayoutParameters
            this.hitReviewPolicy = x.hitReviewPolicy
            this.hitTypeId = x.hitTypeId
            this.lifetimeInSeconds = x.lifetimeInSeconds
            this.maxAssignments = x.maxAssignments
            this.question = x.question
            this.requesterAnnotation = x.requesterAnnotation
            this.uniqueRequestToken = x.uniqueRequestToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mturk.model.CreateHitWithHitTypeRequest = CreateHitWithHitTypeRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.mturk.model.ReviewPolicy] inside the given [block]
         */
        public fun assignmentReviewPolicy(block: aws.sdk.kotlin.services.mturk.model.ReviewPolicy.Builder.() -> kotlin.Unit) {
            this.assignmentReviewPolicy = aws.sdk.kotlin.services.mturk.model.ReviewPolicy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mturk.model.ReviewPolicy] inside the given [block]
         */
        public fun hitReviewPolicy(block: aws.sdk.kotlin.services.mturk.model.ReviewPolicy.Builder.() -> kotlin.Unit) {
            this.hitReviewPolicy = aws.sdk.kotlin.services.mturk.model.ReviewPolicy.invoke(block)
        }
    }
}
