// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mturk.model



public class CreateHitTypeRequest private constructor(builder: Builder) {
    /**
     * The amount of time, in seconds, that a Worker has to complete the HIT after accepting it. If a Worker does not complete the assignment within the specified duration, the assignment is considered abandoned. If the HIT is still active (that is, its lifetime has not elapsed), the assignment becomes available for other users to find and accept.
     */
    public val assignmentDurationInSeconds: kotlin.Long? = builder.assignmentDurationInSeconds
    /**
     * The number of seconds after an assignment for the HIT has been submitted, after which the assignment is considered Approved automatically unless the Requester explicitly rejects it.
     */
    public val autoApprovalDelayInSeconds: kotlin.Long? = builder.autoApprovalDelayInSeconds
    /**
     * A general description of the HIT. A description includes detailed information about the kind of task the HIT contains. On the Amazon Mechanical Turk web site, the HIT description appears in the expanded view of search results, and in the HIT and assignment screens. A good description gives the user enough information to evaluate the HIT before accepting it.
     */
    public val description: kotlin.String? = builder.description
    /**
     * One or more words or phrases that describe the HIT, separated by commas. These words are used in searches to find HITs.
     */
    public val keywords: kotlin.String? = builder.keywords
    /**
     * Conditions that a Worker's Qualifications must meet in order to accept the HIT. A HIT can have between zero and ten Qualification requirements. All requirements must be met in order for a Worker to accept the HIT. Additionally, other actions can be restricted using the `ActionsGuarded` field on each `QualificationRequirement` structure.
     */
    public val qualificationRequirements: List<QualificationRequirement>? = builder.qualificationRequirements
    /**
     * The amount of money the Requester will pay a Worker for successfully completing the HIT.
     */
    public val reward: kotlin.String? = builder.reward
    /**
     * The title of the HIT. A title should be short and descriptive about the kind of task the HIT contains. On the Amazon Mechanical Turk web site, the HIT title appears in search results, and everywhere the HIT is mentioned.
     */
    public val title: kotlin.String? = builder.title

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mturk.model.CreateHitTypeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateHitTypeRequest(")
        append("assignmentDurationInSeconds=$assignmentDurationInSeconds,")
        append("autoApprovalDelayInSeconds=$autoApprovalDelayInSeconds,")
        append("description=$description,")
        append("keywords=$keywords,")
        append("qualificationRequirements=$qualificationRequirements,")
        append("reward=$reward,")
        append("title=$title)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assignmentDurationInSeconds?.hashCode() ?: 0
        result = 31 * result + (autoApprovalDelayInSeconds?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (keywords?.hashCode() ?: 0)
        result = 31 * result + (qualificationRequirements?.hashCode() ?: 0)
        result = 31 * result + (reward?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateHitTypeRequest

        if (assignmentDurationInSeconds != other.assignmentDurationInSeconds) return false
        if (autoApprovalDelayInSeconds != other.autoApprovalDelayInSeconds) return false
        if (description != other.description) return false
        if (keywords != other.keywords) return false
        if (qualificationRequirements != other.qualificationRequirements) return false
        if (reward != other.reward) return false
        if (title != other.title) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mturk.model.CreateHitTypeRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The amount of time, in seconds, that a Worker has to complete the HIT after accepting it. If a Worker does not complete the assignment within the specified duration, the assignment is considered abandoned. If the HIT is still active (that is, its lifetime has not elapsed), the assignment becomes available for other users to find and accept.
         */
        public var assignmentDurationInSeconds: kotlin.Long? = null
        /**
         * The number of seconds after an assignment for the HIT has been submitted, after which the assignment is considered Approved automatically unless the Requester explicitly rejects it.
         */
        public var autoApprovalDelayInSeconds: kotlin.Long? = null
        /**
         * A general description of the HIT. A description includes detailed information about the kind of task the HIT contains. On the Amazon Mechanical Turk web site, the HIT description appears in the expanded view of search results, and in the HIT and assignment screens. A good description gives the user enough information to evaluate the HIT before accepting it.
         */
        public var description: kotlin.String? = null
        /**
         * One or more words or phrases that describe the HIT, separated by commas. These words are used in searches to find HITs.
         */
        public var keywords: kotlin.String? = null
        /**
         * Conditions that a Worker's Qualifications must meet in order to accept the HIT. A HIT can have between zero and ten Qualification requirements. All requirements must be met in order for a Worker to accept the HIT. Additionally, other actions can be restricted using the `ActionsGuarded` field on each `QualificationRequirement` structure.
         */
        public var qualificationRequirements: List<QualificationRequirement>? = null
        /**
         * The amount of money the Requester will pay a Worker for successfully completing the HIT.
         */
        public var reward: kotlin.String? = null
        /**
         * The title of the HIT. A title should be short and descriptive about the kind of task the HIT contains. On the Amazon Mechanical Turk web site, the HIT title appears in search results, and everywhere the HIT is mentioned.
         */
        public var title: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mturk.model.CreateHitTypeRequest) : this() {
            this.assignmentDurationInSeconds = x.assignmentDurationInSeconds
            this.autoApprovalDelayInSeconds = x.autoApprovalDelayInSeconds
            this.description = x.description
            this.keywords = x.keywords
            this.qualificationRequirements = x.qualificationRequirements
            this.reward = x.reward
            this.title = x.title
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mturk.model.CreateHitTypeRequest = CreateHitTypeRequest(this)
    }
}
