// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mturk.model



public class CreateHitRequest private constructor(builder: Builder) {
    /**
     * The amount of time, in seconds, that a Worker has to complete the HIT after accepting it. If a Worker does not complete the assignment within the specified duration, the assignment is considered abandoned. If the HIT is still active (that is, its lifetime has not elapsed), the assignment becomes available for other users to find and accept.
     */
    public val assignmentDurationInSeconds: kotlin.Long? = builder.assignmentDurationInSeconds
    /**
     * The Assignment-level Review Policy applies to the assignments under the HIT. You can specify for Mechanical Turk to take various actions based on the policy.
     */
    public val assignmentReviewPolicy: aws.sdk.kotlin.services.mturk.model.ReviewPolicy? = builder.assignmentReviewPolicy
    /**
     * The number of seconds after an assignment for the HIT has been submitted, after which the assignment is considered Approved automatically unless the Requester explicitly rejects it.
     */
    public val autoApprovalDelayInSeconds: kotlin.Long? = builder.autoApprovalDelayInSeconds
    /**
     * A general description of the HIT. A description includes detailed information about the kind of task the HIT contains. On the Amazon Mechanical Turk web site, the HIT description appears in the expanded view of search results, and in the HIT and assignment screens. A good description gives the user enough information to evaluate the HIT before accepting it.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The HITLayoutId allows you to use a pre-existing HIT design with placeholder values and create an additional HIT by providing those values as HITLayoutParameters.
     *
     *  Constraints: Either a Question parameter or a HITLayoutId parameter must be provided.
     */
    public val hitLayoutId: kotlin.String? = builder.hitLayoutId
    /**
     * If the HITLayoutId is provided, any placeholder values must be filled in with values using the HITLayoutParameter structure. For more information, see HITLayout.
     */
    public val hitLayoutParameters: List<HitLayoutParameter>? = builder.hitLayoutParameters
    /**
     * The HIT-level Review Policy applies to the HIT. You can specify for Mechanical Turk to take various actions based on the policy.
     */
    public val hitReviewPolicy: aws.sdk.kotlin.services.mturk.model.ReviewPolicy? = builder.hitReviewPolicy
    /**
     * One or more words or phrases that describe the HIT, separated by commas. These words are used in searches to find HITs.
     */
    public val keywords: kotlin.String? = builder.keywords
    /**
     * An amount of time, in seconds, after which the HIT is no longer available for users to accept. After the lifetime of the HIT elapses, the HIT no longer appears in HIT searches, even if not all of the assignments for the HIT have been accepted.
     */
    public val lifetimeInSeconds: kotlin.Long? = builder.lifetimeInSeconds
    /**
     * The number of times the HIT can be accepted and completed before the HIT becomes unavailable.
     */
    public val maxAssignments: kotlin.Int? = builder.maxAssignments
    /**
     * Conditions that a Worker's Qualifications must meet in order to accept the HIT. A HIT can have between zero and ten Qualification requirements. All requirements must be met in order for a Worker to accept the HIT. Additionally, other actions can be restricted using the `ActionsGuarded` field on each `QualificationRequirement` structure.
     */
    public val qualificationRequirements: List<QualificationRequirement>? = builder.qualificationRequirements
    /**
     * The data the person completing the HIT uses to produce the results.
     *
     *  Constraints: Must be a QuestionForm data structure, an ExternalQuestion data structure, or an HTMLQuestion data structure. The XML question data must not be larger than 64 kilobytes (65,535 bytes) in size, including whitespace.
     *
     * Either a Question parameter or a HITLayoutId parameter must be provided.
     */
    public val question: kotlin.String? = builder.question
    /**
     * An arbitrary data field. The RequesterAnnotation parameter lets your application attach arbitrary data to the HIT for tracking purposes. For example, this parameter could be an identifier internal to the Requester's application that corresponds with the HIT.
     *
     *  The RequesterAnnotation parameter for a HIT is only visible to the Requester who created the HIT. It is not shown to the Worker, or any other Requester.
     *
     *  The RequesterAnnotation parameter may be different for each HIT you submit. It does not affect how your HITs are grouped.
     */
    public val requesterAnnotation: kotlin.String? = builder.requesterAnnotation
    /**
     * The amount of money the Requester will pay a Worker for successfully completing the HIT.
     */
    public val reward: kotlin.String? = builder.reward
    /**
     * The title of the HIT. A title should be short and descriptive about the kind of task the HIT contains. On the Amazon Mechanical Turk web site, the HIT title appears in search results, and everywhere the HIT is mentioned.
     */
    public val title: kotlin.String? = builder.title
    /**
     * A unique identifier for this request which allows you to retry the call on error without creating duplicate HITs. This is useful in cases such as network timeouts where it is unclear whether or not the call succeeded on the server. If the HIT already exists in the system from a previous call using the same UniqueRequestToken, subsequent calls will return a AWS.MechanicalTurk.HitAlreadyExists error with a message containing the HITId.
     *
     *  Note: It is your responsibility to ensure uniqueness of the token. The unique token expires after 24 hours. Subsequent calls using the same UniqueRequestToken made after the 24 hour limit could create duplicate HITs.
     */
    public val uniqueRequestToken: kotlin.String? = builder.uniqueRequestToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mturk.model.CreateHitRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateHitRequest(")
        append("assignmentDurationInSeconds=$assignmentDurationInSeconds,")
        append("assignmentReviewPolicy=$assignmentReviewPolicy,")
        append("autoApprovalDelayInSeconds=$autoApprovalDelayInSeconds,")
        append("description=$description,")
        append("hitLayoutId=$hitLayoutId,")
        append("hitLayoutParameters=$hitLayoutParameters,")
        append("hitReviewPolicy=$hitReviewPolicy,")
        append("keywords=$keywords,")
        append("lifetimeInSeconds=$lifetimeInSeconds,")
        append("maxAssignments=$maxAssignments,")
        append("qualificationRequirements=$qualificationRequirements,")
        append("question=$question,")
        append("requesterAnnotation=$requesterAnnotation,")
        append("reward=$reward,")
        append("title=$title,")
        append("uniqueRequestToken=$uniqueRequestToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assignmentDurationInSeconds?.hashCode() ?: 0
        result = 31 * result + (assignmentReviewPolicy?.hashCode() ?: 0)
        result = 31 * result + (autoApprovalDelayInSeconds?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (hitLayoutId?.hashCode() ?: 0)
        result = 31 * result + (hitLayoutParameters?.hashCode() ?: 0)
        result = 31 * result + (hitReviewPolicy?.hashCode() ?: 0)
        result = 31 * result + (keywords?.hashCode() ?: 0)
        result = 31 * result + (lifetimeInSeconds?.hashCode() ?: 0)
        result = 31 * result + (maxAssignments ?: 0)
        result = 31 * result + (qualificationRequirements?.hashCode() ?: 0)
        result = 31 * result + (question?.hashCode() ?: 0)
        result = 31 * result + (requesterAnnotation?.hashCode() ?: 0)
        result = 31 * result + (reward?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        result = 31 * result + (uniqueRequestToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateHitRequest

        if (assignmentDurationInSeconds != other.assignmentDurationInSeconds) return false
        if (assignmentReviewPolicy != other.assignmentReviewPolicy) return false
        if (autoApprovalDelayInSeconds != other.autoApprovalDelayInSeconds) return false
        if (description != other.description) return false
        if (hitLayoutId != other.hitLayoutId) return false
        if (hitLayoutParameters != other.hitLayoutParameters) return false
        if (hitReviewPolicy != other.hitReviewPolicy) return false
        if (keywords != other.keywords) return false
        if (lifetimeInSeconds != other.lifetimeInSeconds) return false
        if (maxAssignments != other.maxAssignments) return false
        if (qualificationRequirements != other.qualificationRequirements) return false
        if (question != other.question) return false
        if (requesterAnnotation != other.requesterAnnotation) return false
        if (reward != other.reward) return false
        if (title != other.title) return false
        if (uniqueRequestToken != other.uniqueRequestToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mturk.model.CreateHitRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The amount of time, in seconds, that a Worker has to complete the HIT after accepting it. If a Worker does not complete the assignment within the specified duration, the assignment is considered abandoned. If the HIT is still active (that is, its lifetime has not elapsed), the assignment becomes available for other users to find and accept.
         */
        public var assignmentDurationInSeconds: kotlin.Long? = null
        /**
         * The Assignment-level Review Policy applies to the assignments under the HIT. You can specify for Mechanical Turk to take various actions based on the policy.
         */
        public var assignmentReviewPolicy: aws.sdk.kotlin.services.mturk.model.ReviewPolicy? = null
        /**
         * The number of seconds after an assignment for the HIT has been submitted, after which the assignment is considered Approved automatically unless the Requester explicitly rejects it.
         */
        public var autoApprovalDelayInSeconds: kotlin.Long? = null
        /**
         * A general description of the HIT. A description includes detailed information about the kind of task the HIT contains. On the Amazon Mechanical Turk web site, the HIT description appears in the expanded view of search results, and in the HIT and assignment screens. A good description gives the user enough information to evaluate the HIT before accepting it.
         */
        public var description: kotlin.String? = null
        /**
         * The HITLayoutId allows you to use a pre-existing HIT design with placeholder values and create an additional HIT by providing those values as HITLayoutParameters.
         *
         *  Constraints: Either a Question parameter or a HITLayoutId parameter must be provided.
         */
        public var hitLayoutId: kotlin.String? = null
        /**
         * If the HITLayoutId is provided, any placeholder values must be filled in with values using the HITLayoutParameter structure. For more information, see HITLayout.
         */
        public var hitLayoutParameters: List<HitLayoutParameter>? = null
        /**
         * The HIT-level Review Policy applies to the HIT. You can specify for Mechanical Turk to take various actions based on the policy.
         */
        public var hitReviewPolicy: aws.sdk.kotlin.services.mturk.model.ReviewPolicy? = null
        /**
         * One or more words or phrases that describe the HIT, separated by commas. These words are used in searches to find HITs.
         */
        public var keywords: kotlin.String? = null
        /**
         * An amount of time, in seconds, after which the HIT is no longer available for users to accept. After the lifetime of the HIT elapses, the HIT no longer appears in HIT searches, even if not all of the assignments for the HIT have been accepted.
         */
        public var lifetimeInSeconds: kotlin.Long? = null
        /**
         * The number of times the HIT can be accepted and completed before the HIT becomes unavailable.
         */
        public var maxAssignments: kotlin.Int? = null
        /**
         * Conditions that a Worker's Qualifications must meet in order to accept the HIT. A HIT can have between zero and ten Qualification requirements. All requirements must be met in order for a Worker to accept the HIT. Additionally, other actions can be restricted using the `ActionsGuarded` field on each `QualificationRequirement` structure.
         */
        public var qualificationRequirements: List<QualificationRequirement>? = null
        /**
         * The data the person completing the HIT uses to produce the results.
         *
         *  Constraints: Must be a QuestionForm data structure, an ExternalQuestion data structure, or an HTMLQuestion data structure. The XML question data must not be larger than 64 kilobytes (65,535 bytes) in size, including whitespace.
         *
         * Either a Question parameter or a HITLayoutId parameter must be provided.
         */
        public var question: kotlin.String? = null
        /**
         * An arbitrary data field. The RequesterAnnotation parameter lets your application attach arbitrary data to the HIT for tracking purposes. For example, this parameter could be an identifier internal to the Requester's application that corresponds with the HIT.
         *
         *  The RequesterAnnotation parameter for a HIT is only visible to the Requester who created the HIT. It is not shown to the Worker, or any other Requester.
         *
         *  The RequesterAnnotation parameter may be different for each HIT you submit. It does not affect how your HITs are grouped.
         */
        public var requesterAnnotation: kotlin.String? = null
        /**
         * The amount of money the Requester will pay a Worker for successfully completing the HIT.
         */
        public var reward: kotlin.String? = null
        /**
         * The title of the HIT. A title should be short and descriptive about the kind of task the HIT contains. On the Amazon Mechanical Turk web site, the HIT title appears in search results, and everywhere the HIT is mentioned.
         */
        public var title: kotlin.String? = null
        /**
         * A unique identifier for this request which allows you to retry the call on error without creating duplicate HITs. This is useful in cases such as network timeouts where it is unclear whether or not the call succeeded on the server. If the HIT already exists in the system from a previous call using the same UniqueRequestToken, subsequent calls will return a AWS.MechanicalTurk.HitAlreadyExists error with a message containing the HITId.
         *
         *  Note: It is your responsibility to ensure uniqueness of the token. The unique token expires after 24 hours. Subsequent calls using the same UniqueRequestToken made after the 24 hour limit could create duplicate HITs.
         */
        public var uniqueRequestToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mturk.model.CreateHitRequest) : this() {
            this.assignmentDurationInSeconds = x.assignmentDurationInSeconds
            this.assignmentReviewPolicy = x.assignmentReviewPolicy
            this.autoApprovalDelayInSeconds = x.autoApprovalDelayInSeconds
            this.description = x.description
            this.hitLayoutId = x.hitLayoutId
            this.hitLayoutParameters = x.hitLayoutParameters
            this.hitReviewPolicy = x.hitReviewPolicy
            this.keywords = x.keywords
            this.lifetimeInSeconds = x.lifetimeInSeconds
            this.maxAssignments = x.maxAssignments
            this.qualificationRequirements = x.qualificationRequirements
            this.question = x.question
            this.requesterAnnotation = x.requesterAnnotation
            this.reward = x.reward
            this.title = x.title
            this.uniqueRequestToken = x.uniqueRequestToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mturk.model.CreateHitRequest = CreateHitRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.mturk.model.ReviewPolicy] inside the given [block]
         */
        public fun assignmentReviewPolicy(block: aws.sdk.kotlin.services.mturk.model.ReviewPolicy.Builder.() -> kotlin.Unit) {
            this.assignmentReviewPolicy = aws.sdk.kotlin.services.mturk.model.ReviewPolicy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mturk.model.ReviewPolicy] inside the given [block]
         */
        public fun hitReviewPolicy(block: aws.sdk.kotlin.services.mturk.model.ReviewPolicy.Builder.() -> kotlin.Unit) {
            this.hitReviewPolicy = aws.sdk.kotlin.services.mturk.model.ReviewPolicy.invoke(block)
        }
    }
}
