// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mturk.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The Assignment data structure represents a single assignment of a HIT to a Worker. The assignment tracks the Worker's efforts to complete the HIT, and contains the results for later retrieval.
 */
public class Assignment private constructor(builder: Builder) {
    /**
     * The date and time the Worker accepted the assignment.
     */
    public val acceptTime: aws.smithy.kotlin.runtime.time.Instant? = builder.acceptTime
    /**
     * The Worker's answers submitted for the HIT contained in a QuestionFormAnswers document, if the Worker provides an answer. If the Worker does not provide any answers, Answer may contain a QuestionFormAnswers document, or Answer may be empty.
     */
    public val answer: kotlin.String? = builder.answer
    /**
     * If the Worker has submitted results and the Requester has approved the results, ApprovalTime is the date and time the Requester approved the results. This value is omitted from the assignment if the Requester has not yet approved the results.
     */
    public val approvalTime: aws.smithy.kotlin.runtime.time.Instant? = builder.approvalTime
    /**
     * A unique identifier for the assignment.
     */
    public val assignmentId: kotlin.String? = builder.assignmentId
    /**
     * The status of the assignment.
     */
    public val assignmentStatus: aws.sdk.kotlin.services.mturk.model.AssignmentStatus? = builder.assignmentStatus
    /**
     * If results have been submitted, AutoApprovalTime is the date and time the results of the assignment results are considered Approved automatically if they have not already been explicitly approved or rejected by the Requester. This value is derived from the auto-approval delay specified by the Requester in the HIT. This value is omitted from the assignment if the Worker has not yet submitted results.
     */
    public val autoApprovalTime: aws.smithy.kotlin.runtime.time.Instant? = builder.autoApprovalTime
    /**
     * The date and time of the deadline for the assignment. This value is derived from the deadline specification for the HIT and the date and time the Worker accepted the HIT.
     */
    public val deadline: aws.smithy.kotlin.runtime.time.Instant? = builder.deadline
    /**
     * The ID of the HIT.
     */
    public val hitId: kotlin.String? = builder.hitId
    /**
     * If the Worker has submitted results and the Requester has rejected the results, RejectionTime is the date and time the Requester rejected the results.
     */
    public val rejectionTime: aws.smithy.kotlin.runtime.time.Instant? = builder.rejectionTime
    /**
     * The feedback string included with the call to the ApproveAssignment operation or the RejectAssignment operation, if the Requester approved or rejected the assignment and specified feedback.
     */
    public val requesterFeedback: kotlin.String? = builder.requesterFeedback
    /**
     * If the Worker has submitted results, SubmitTime is the date and time the assignment was submitted. This value is omitted from the assignment if the Worker has not yet submitted results.
     */
    public val submitTime: aws.smithy.kotlin.runtime.time.Instant? = builder.submitTime
    /**
     * The ID of the Worker who accepted the HIT.
     */
    public val workerId: kotlin.String? = builder.workerId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mturk.model.Assignment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Assignment(")
        append("acceptTime=$acceptTime,")
        append("answer=$answer,")
        append("approvalTime=$approvalTime,")
        append("assignmentId=$assignmentId,")
        append("assignmentStatus=$assignmentStatus,")
        append("autoApprovalTime=$autoApprovalTime,")
        append("deadline=$deadline,")
        append("hitId=$hitId,")
        append("rejectionTime=$rejectionTime,")
        append("requesterFeedback=$requesterFeedback,")
        append("submitTime=$submitTime,")
        append("workerId=$workerId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceptTime?.hashCode() ?: 0
        result = 31 * result + (answer?.hashCode() ?: 0)
        result = 31 * result + (approvalTime?.hashCode() ?: 0)
        result = 31 * result + (assignmentId?.hashCode() ?: 0)
        result = 31 * result + (assignmentStatus?.hashCode() ?: 0)
        result = 31 * result + (autoApprovalTime?.hashCode() ?: 0)
        result = 31 * result + (deadline?.hashCode() ?: 0)
        result = 31 * result + (hitId?.hashCode() ?: 0)
        result = 31 * result + (rejectionTime?.hashCode() ?: 0)
        result = 31 * result + (requesterFeedback?.hashCode() ?: 0)
        result = 31 * result + (submitTime?.hashCode() ?: 0)
        result = 31 * result + (workerId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Assignment

        if (acceptTime != other.acceptTime) return false
        if (answer != other.answer) return false
        if (approvalTime != other.approvalTime) return false
        if (assignmentId != other.assignmentId) return false
        if (assignmentStatus != other.assignmentStatus) return false
        if (autoApprovalTime != other.autoApprovalTime) return false
        if (deadline != other.deadline) return false
        if (hitId != other.hitId) return false
        if (rejectionTime != other.rejectionTime) return false
        if (requesterFeedback != other.requesterFeedback) return false
        if (submitTime != other.submitTime) return false
        if (workerId != other.workerId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mturk.model.Assignment = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time the Worker accepted the assignment.
         */
        public var acceptTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Worker's answers submitted for the HIT contained in a QuestionFormAnswers document, if the Worker provides an answer. If the Worker does not provide any answers, Answer may contain a QuestionFormAnswers document, or Answer may be empty.
         */
        public var answer: kotlin.String? = null
        /**
         * If the Worker has submitted results and the Requester has approved the results, ApprovalTime is the date and time the Requester approved the results. This value is omitted from the assignment if the Requester has not yet approved the results.
         */
        public var approvalTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A unique identifier for the assignment.
         */
        public var assignmentId: kotlin.String? = null
        /**
         * The status of the assignment.
         */
        public var assignmentStatus: aws.sdk.kotlin.services.mturk.model.AssignmentStatus? = null
        /**
         * If results have been submitted, AutoApprovalTime is the date and time the results of the assignment results are considered Approved automatically if they have not already been explicitly approved or rejected by the Requester. This value is derived from the auto-approval delay specified by the Requester in the HIT. This value is omitted from the assignment if the Worker has not yet submitted results.
         */
        public var autoApprovalTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time of the deadline for the assignment. This value is derived from the deadline specification for the HIT and the date and time the Worker accepted the HIT.
         */
        public var deadline: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the HIT.
         */
        public var hitId: kotlin.String? = null
        /**
         * If the Worker has submitted results and the Requester has rejected the results, RejectionTime is the date and time the Requester rejected the results.
         */
        public var rejectionTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The feedback string included with the call to the ApproveAssignment operation or the RejectAssignment operation, if the Requester approved or rejected the assignment and specified feedback.
         */
        public var requesterFeedback: kotlin.String? = null
        /**
         * If the Worker has submitted results, SubmitTime is the date and time the assignment was submitted. This value is omitted from the assignment if the Worker has not yet submitted results.
         */
        public var submitTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the Worker who accepted the HIT.
         */
        public var workerId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mturk.model.Assignment) : this() {
            this.acceptTime = x.acceptTime
            this.answer = x.answer
            this.approvalTime = x.approvalTime
            this.assignmentId = x.assignmentId
            this.assignmentStatus = x.assignmentStatus
            this.autoApprovalTime = x.autoApprovalTime
            this.deadline = x.deadline
            this.hitId = x.hitId
            this.rejectionTime = x.rejectionTime
            this.requesterFeedback = x.requesterFeedback
            this.submitTime = x.submitTime
            this.workerId = x.workerId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mturk.model.Assignment = Assignment(this)
    }
}
