// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mq.transform

import aws.sdk.kotlin.services.mq.model.UpdateBrokerRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateBrokerOperationSerializer: HttpSerialize<UpdateBrokerRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateBrokerRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf(
                "v1",
                "brokers",
                "${input.brokerId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateBrokerOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        builder.headers.setMissing("Content-Type", "application/json")
        return builder
    }
}

private fun serializeUpdateBrokerOperationBody(context: ExecutionContext, input: UpdateBrokerRequest): ByteArray {
    val serializer = JsonSerializer()
    val AUTHENTICATIONSTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("authenticationStrategy"))
    val AUTOMINORVERSIONUPGRADE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("autoMinorVersionUpgrade"))
    val CONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("configuration"))
    val ENGINEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("engineVersion"))
    val HOSTINSTANCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("hostInstanceType"))
    val LDAPSERVERMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ldapServerMetadata"))
    val LOGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("logs"))
    val MAINTENANCEWINDOWSTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("maintenanceWindowStartTime"))
    val SECURITYGROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("securityGroups"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTHENTICATIONSTRATEGY_DESCRIPTOR)
        field(AUTOMINORVERSIONUPGRADE_DESCRIPTOR)
        field(CONFIGURATION_DESCRIPTOR)
        field(ENGINEVERSION_DESCRIPTOR)
        field(HOSTINSTANCETYPE_DESCRIPTOR)
        field(LDAPSERVERMETADATA_DESCRIPTOR)
        field(LOGS_DESCRIPTOR)
        field(MAINTENANCEWINDOWSTARTTIME_DESCRIPTOR)
        field(SECURITYGROUPS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.authenticationStrategy?.let { field(AUTHENTICATIONSTRATEGY_DESCRIPTOR, it.value) }
        input.autoMinorVersionUpgrade?.let { field(AUTOMINORVERSIONUPGRADE_DESCRIPTOR, it) }
        input.configuration?.let { field(CONFIGURATION_DESCRIPTOR, it, ::serializeConfigurationIdDocument) }
        input.engineVersion?.let { field(ENGINEVERSION_DESCRIPTOR, it) }
        input.hostInstanceType?.let { field(HOSTINSTANCETYPE_DESCRIPTOR, it) }
        input.ldapServerMetadata?.let { field(LDAPSERVERMETADATA_DESCRIPTOR, it, ::serializeLdapServerMetadataInputDocument) }
        input.logs?.let { field(LOGS_DESCRIPTOR, it, ::serializeLogsDocument) }
        input.maintenanceWindowStartTime?.let { field(MAINTENANCEWINDOWSTARTTIME_DESCRIPTOR, it, ::serializeWeeklyStartTimeDocument) }
        if (input.securityGroups != null) {
            listField(SECURITYGROUPS_DESCRIPTOR) {
                for (el0 in input.securityGroups) {
                    serializeString(el0)
                }
            }
        }
    }
    return serializer.toByteArray()
}
