// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mq.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.mq.model.DescribeConfigurationRevisionResponse
import aws.sdk.kotlin.services.mq.model.MqException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeConfigurationRevisionOperationDeserializer: HttpDeserialize<DescribeConfigurationRevisionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeConfigurationRevisionResponse {
        if (!response.status.isSuccess()) {
            throwDescribeConfigurationRevisionError(context, response)
        }
        val builder = DescribeConfigurationRevisionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeConfigurationRevisionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeDescribeConfigurationRevisionOperationBody(builder: DescribeConfigurationRevisionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONFIGURATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("configurationId"))
    val CREATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("created"))
    val DATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("data"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONFIGURATIONID_DESCRIPTOR)
        field(CREATED_DESCRIPTOR)
        field(DATA_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONFIGURATIONID_DESCRIPTOR.index -> builder.configurationId = deserializeString()
                CREATED_DESCRIPTOR.index -> builder.created = deserializeString().let { Instant.fromEpochSeconds(it) }
                DATA_DESCRIPTOR.index -> builder.data = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeConfigurationRevisionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer()
        "ForbiddenException" -> ForbiddenExceptionDeserializer()
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer()
        "NotFoundException" -> NotFoundExceptionDeserializer()
        else -> throw MqException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
