// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mq.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.mq.model.AuthenticationStrategy
import aws.sdk.kotlin.services.mq.model.CreateConfigurationResponse
import aws.sdk.kotlin.services.mq.model.MqException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class CreateConfigurationOperationDeserializer: HttpDeserialize<CreateConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateConfigurationResponse {
        if (!response.status.isSuccess()) {
            throwCreateConfigurationError(context, response)
        }
        val builder = CreateConfigurationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateConfigurationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeCreateConfigurationOperationBody(builder: CreateConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val AUTHENTICATIONSTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("authenticationStrategy"))
    val CREATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("created"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val LATESTREVISION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("latestRevision"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(AUTHENTICATIONSTRATEGY_DESCRIPTOR)
        field(CREATED_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(LATESTREVISION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                AUTHENTICATIONSTRATEGY_DESCRIPTOR.index -> builder.authenticationStrategy = deserializeString().let { AuthenticationStrategy.fromValue(it) }
                CREATED_DESCRIPTOR.index -> builder.created = deserializeString().let { Instant.fromEpochSeconds(it) }
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                LATESTREVISION_DESCRIPTOR.index -> builder.latestRevision = deserializeConfigurationRevisionDocument(deserializer)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwCreateConfigurationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer()
        "ConflictException" -> ConflictExceptionDeserializer()
        "ForbiddenException" -> ForbiddenExceptionDeserializer()
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer()
        else -> throw MqException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
