// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mq.transform

import aws.sdk.kotlin.services.mq.model.CreateBrokerRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateBrokerOperationSerializer: HttpSerialize<CreateBrokerRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateBrokerRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/v1/brokers"
        }

        val payload = serializeCreateBrokerOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        builder.headers.setMissing("Content-Type", "application/json")
        return builder
    }
}

private fun serializeCreateBrokerOperationBody(context: ExecutionContext, input: CreateBrokerRequest): ByteArray {
    val serializer = JsonSerializer()
    val AUTHENTICATIONSTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("authenticationStrategy"))
    val AUTOMINORVERSIONUPGRADE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("autoMinorVersionUpgrade"))
    val BROKERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("brokerName"))
    val CONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("configuration"))
    val CREATORREQUESTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("creatorRequestId"))
    val DEPLOYMENTMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deploymentMode"))
    val ENCRYPTIONOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("encryptionOptions"))
    val ENGINETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("engineType"))
    val ENGINEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("engineVersion"))
    val HOSTINSTANCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("hostInstanceType"))
    val LDAPSERVERMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ldapServerMetadata"))
    val LOGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("logs"))
    val MAINTENANCEWINDOWSTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("maintenanceWindowStartTime"))
    val PUBLICLYACCESSIBLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("publiclyAccessible"))
    val SECURITYGROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("securityGroups"))
    val STORAGETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("storageType"))
    val SUBNETIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("subnetIds"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val USERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("users"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTHENTICATIONSTRATEGY_DESCRIPTOR)
        field(AUTOMINORVERSIONUPGRADE_DESCRIPTOR)
        field(BROKERNAME_DESCRIPTOR)
        field(CONFIGURATION_DESCRIPTOR)
        field(CREATORREQUESTID_DESCRIPTOR)
        field(DEPLOYMENTMODE_DESCRIPTOR)
        field(ENCRYPTIONOPTIONS_DESCRIPTOR)
        field(ENGINETYPE_DESCRIPTOR)
        field(ENGINEVERSION_DESCRIPTOR)
        field(HOSTINSTANCETYPE_DESCRIPTOR)
        field(LDAPSERVERMETADATA_DESCRIPTOR)
        field(LOGS_DESCRIPTOR)
        field(MAINTENANCEWINDOWSTARTTIME_DESCRIPTOR)
        field(PUBLICLYACCESSIBLE_DESCRIPTOR)
        field(SECURITYGROUPS_DESCRIPTOR)
        field(STORAGETYPE_DESCRIPTOR)
        field(SUBNETIDS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(USERS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.authenticationStrategy?.let { field(AUTHENTICATIONSTRATEGY_DESCRIPTOR, it.value) }
        input.autoMinorVersionUpgrade?.let { field(AUTOMINORVERSIONUPGRADE_DESCRIPTOR, it) }
        input.brokerName?.let { field(BROKERNAME_DESCRIPTOR, it) }
        input.configuration?.let { field(CONFIGURATION_DESCRIPTOR, it, ::serializeConfigurationIdDocument) }
        input.creatorRequestId?.let { field(CREATORREQUESTID_DESCRIPTOR, it) } ?: field(CREATORREQUESTID_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.deploymentMode?.let { field(DEPLOYMENTMODE_DESCRIPTOR, it.value) }
        input.encryptionOptions?.let { field(ENCRYPTIONOPTIONS_DESCRIPTOR, it, ::serializeEncryptionOptionsDocument) }
        input.engineType?.let { field(ENGINETYPE_DESCRIPTOR, it.value) }
        input.engineVersion?.let { field(ENGINEVERSION_DESCRIPTOR, it) }
        input.hostInstanceType?.let { field(HOSTINSTANCETYPE_DESCRIPTOR, it) }
        input.ldapServerMetadata?.let { field(LDAPSERVERMETADATA_DESCRIPTOR, it, ::serializeLdapServerMetadataInputDocument) }
        input.logs?.let { field(LOGS_DESCRIPTOR, it, ::serializeLogsDocument) }
        input.maintenanceWindowStartTime?.let { field(MAINTENANCEWINDOWSTARTTIME_DESCRIPTOR, it, ::serializeWeeklyStartTimeDocument) }
        input.publiclyAccessible?.let { field(PUBLICLYACCESSIBLE_DESCRIPTOR, it) }
        if (input.securityGroups != null) {
            listField(SECURITYGROUPS_DESCRIPTOR) {
                for (el0 in input.securityGroups) {
                    serializeString(el0)
                }
            }
        }
        input.storageType?.let { field(STORAGETYPE_DESCRIPTOR, it.value) }
        if (input.subnetIds != null) {
            listField(SUBNETIDS_DESCRIPTOR) {
                for (el0 in input.subnetIds) {
                    serializeString(el0)
                }
            }
        }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) -> entry(key, value) }
            }
        }
        if (input.users != null) {
            listField(USERS_DESCRIPTOR) {
                for (el0 in input.users) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeUserDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
