// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mq.model



/**
 * Updates the information for an ActiveMQ user.
 */
class UpdateUserRequest private constructor(builder: Builder) {
    /**
     * The unique ID that Amazon MQ generates for the broker.
     */
    val brokerId: kotlin.String? = builder.brokerId
    /**
     * Enables access to the the ActiveMQ Web Console for the ActiveMQ user.
     */
    val consoleAccess: kotlin.Boolean? = builder.consoleAccess
    /**
     * The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
     */
    val groups: List<String>? = builder.groups
    /**
     * The password of the user. This value must be at least 12 characters long, must contain at least 4 unique characters, and must not contain commas, colons, or equal signs (,:=).
     */
    val password: kotlin.String? = builder.password
    /**
     * The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
     */
    val username: kotlin.String? = builder.username

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mq.model.UpdateUserRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateUserRequest(")
        append("brokerId=$brokerId,")
        append("consoleAccess=$consoleAccess,")
        append("groups=$groups,")
        append("password=$password,")
        append("username=$username)")
    }

    override fun hashCode(): kotlin.Int {
        var result = brokerId?.hashCode() ?: 0
        result = 31 * result + (consoleAccess?.hashCode() ?: 0)
        result = 31 * result + (groups?.hashCode() ?: 0)
        result = 31 * result + (password?.hashCode() ?: 0)
        result = 31 * result + (username?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateUserRequest

        if (brokerId != other.brokerId) return false
        if (consoleAccess != other.consoleAccess) return false
        if (groups != other.groups) return false
        if (password != other.password) return false
        if (username != other.username) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mq.model.UpdateUserRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The unique ID that Amazon MQ generates for the broker.
         */
        var brokerId: kotlin.String? = null
        /**
         * Enables access to the the ActiveMQ Web Console for the ActiveMQ user.
         */
        var consoleAccess: kotlin.Boolean? = null
        /**
         * The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
         */
        var groups: List<String>? = null
        /**
         * The password of the user. This value must be at least 12 characters long, must contain at least 4 unique characters, and must not contain commas, colons, or equal signs (,:=).
         */
        var password: kotlin.String? = null
        /**
         * The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
         */
        var username: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mq.model.UpdateUserRequest) : this() {
            this.brokerId = x.brokerId
            this.consoleAccess = x.consoleAccess
            this.groups = x.groups
            this.password = x.password
            this.username = x.username
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mq.model.UpdateUserRequest = UpdateUserRequest(this)
    }
}
