// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mq.model



class UpdateBrokerResponse private constructor(builder: Builder) {
    /**
     * Optional. The authentication strategy used to secure the broker. The default is SIMPLE.
     */
    val authenticationStrategy: aws.sdk.kotlin.services.mq.model.AuthenticationStrategy? = builder.authenticationStrategy
    /**
     * The new boolean value that specifies whether broker engines automatically upgrade to new minor versions as new versions are released and supported by Amazon MQ.
     */
    val autoMinorVersionUpgrade: kotlin.Boolean? = builder.autoMinorVersionUpgrade
    /**
     * Required. The unique ID that Amazon MQ generates for the broker.
     */
    val brokerId: kotlin.String? = builder.brokerId
    /**
     * The ID of the updated configuration.
     */
    val configuration: aws.sdk.kotlin.services.mq.model.ConfigurationId? = builder.configuration
    /**
     * The broker engine version to upgrade to. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines.
     */
    val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The broker's host instance type to upgrade to. For a list of supported instance types, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types">Broker instance types.
     */
    val hostInstanceType: kotlin.String? = builder.hostInstanceType
    /**
     * Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.
     */
    val ldapServerMetadata: aws.sdk.kotlin.services.mq.model.LdapServerMetadataOutput? = builder.ldapServerMetadata
    /**
     * The list of information about logs to be enabled for the specified broker.
     */
    val logs: aws.sdk.kotlin.services.mq.model.Logs? = builder.logs
    /**
     * The parameters that determine the WeeklyStartTime.
     */
    val maintenanceWindowStartTime: aws.sdk.kotlin.services.mq.model.WeeklyStartTime? = builder.maintenanceWindowStartTime
    /**
     * The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.
     */
    val securityGroups: List<String>? = builder.securityGroups

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mq.model.UpdateBrokerResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateBrokerResponse(")
        append("authenticationStrategy=$authenticationStrategy,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("brokerId=$brokerId,")
        append("configuration=$configuration,")
        append("engineVersion=$engineVersion,")
        append("hostInstanceType=$hostInstanceType,")
        append("ldapServerMetadata=$ldapServerMetadata,")
        append("logs=$logs,")
        append("maintenanceWindowStartTime=$maintenanceWindowStartTime,")
        append("securityGroups=$securityGroups)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationStrategy?.hashCode() ?: 0
        result = 31 * result + (autoMinorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (brokerId?.hashCode() ?: 0)
        result = 31 * result + (configuration?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (hostInstanceType?.hashCode() ?: 0)
        result = 31 * result + (ldapServerMetadata?.hashCode() ?: 0)
        result = 31 * result + (logs?.hashCode() ?: 0)
        result = 31 * result + (maintenanceWindowStartTime?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateBrokerResponse

        if (authenticationStrategy != other.authenticationStrategy) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (brokerId != other.brokerId) return false
        if (configuration != other.configuration) return false
        if (engineVersion != other.engineVersion) return false
        if (hostInstanceType != other.hostInstanceType) return false
        if (ldapServerMetadata != other.ldapServerMetadata) return false
        if (logs != other.logs) return false
        if (maintenanceWindowStartTime != other.maintenanceWindowStartTime) return false
        if (securityGroups != other.securityGroups) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mq.model.UpdateBrokerResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * Optional. The authentication strategy used to secure the broker. The default is SIMPLE.
         */
        var authenticationStrategy: aws.sdk.kotlin.services.mq.model.AuthenticationStrategy? = null
        /**
         * The new boolean value that specifies whether broker engines automatically upgrade to new minor versions as new versions are released and supported by Amazon MQ.
         */
        var autoMinorVersionUpgrade: kotlin.Boolean? = null
        /**
         * Required. The unique ID that Amazon MQ generates for the broker.
         */
        var brokerId: kotlin.String? = null
        /**
         * The ID of the updated configuration.
         */
        var configuration: aws.sdk.kotlin.services.mq.model.ConfigurationId? = null
        /**
         * The broker engine version to upgrade to. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines.
         */
        var engineVersion: kotlin.String? = null
        /**
         * The broker's host instance type to upgrade to. For a list of supported instance types, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types">Broker instance types.
         */
        var hostInstanceType: kotlin.String? = null
        /**
         * Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.
         */
        var ldapServerMetadata: aws.sdk.kotlin.services.mq.model.LdapServerMetadataOutput? = null
        /**
         * The list of information about logs to be enabled for the specified broker.
         */
        var logs: aws.sdk.kotlin.services.mq.model.Logs? = null
        /**
         * The parameters that determine the WeeklyStartTime.
         */
        var maintenanceWindowStartTime: aws.sdk.kotlin.services.mq.model.WeeklyStartTime? = null
        /**
         * The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.
         */
        var securityGroups: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mq.model.UpdateBrokerResponse) : this() {
            this.authenticationStrategy = x.authenticationStrategy
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.brokerId = x.brokerId
            this.configuration = x.configuration
            this.engineVersion = x.engineVersion
            this.hostInstanceType = x.hostInstanceType
            this.ldapServerMetadata = x.ldapServerMetadata
            this.logs = x.logs
            this.maintenanceWindowStartTime = x.maintenanceWindowStartTime
            this.securityGroups = x.securityGroups
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mq.model.UpdateBrokerResponse = UpdateBrokerResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.ConfigurationId] inside the given [block]
         */
        fun configuration(block: aws.sdk.kotlin.services.mq.model.ConfigurationId.Builder.() -> kotlin.Unit) {
            this.configuration = aws.sdk.kotlin.services.mq.model.ConfigurationId.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.LdapServerMetadataOutput] inside the given [block]
         */
        fun ldapServerMetadata(block: aws.sdk.kotlin.services.mq.model.LdapServerMetadataOutput.Builder.() -> kotlin.Unit) {
            this.ldapServerMetadata = aws.sdk.kotlin.services.mq.model.LdapServerMetadataOutput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.Logs] inside the given [block]
         */
        fun logs(block: aws.sdk.kotlin.services.mq.model.Logs.Builder.() -> kotlin.Unit) {
            this.logs = aws.sdk.kotlin.services.mq.model.Logs.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.WeeklyStartTime] inside the given [block]
         */
        fun maintenanceWindowStartTime(block: aws.sdk.kotlin.services.mq.model.WeeklyStartTime.Builder.() -> kotlin.Unit) {
            this.maintenanceWindowStartTime = aws.sdk.kotlin.services.mq.model.WeeklyStartTime.invoke(block)
        }
    }
}
