// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mq.model

import aws.smithy.kotlin.runtime.time.Instant

class DescribeBrokerResponse private constructor(builder: Builder) {
    /**
     * The authentication strategy used to secure the broker. The default is SIMPLE.
     */
    val authenticationStrategy: aws.sdk.kotlin.services.mq.model.AuthenticationStrategy? = builder.authenticationStrategy
    /**
     * Enables automatic upgrades to new minor versions for brokers, as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot.
     */
    val autoMinorVersionUpgrade: kotlin.Boolean? = builder.autoMinorVersionUpgrade
    /**
     * The broker's Amazon Resource Name (ARN).
     */
    val brokerArn: kotlin.String? = builder.brokerArn
    /**
     * The unique ID that Amazon MQ generates for the broker.
     */
    val brokerId: kotlin.String? = builder.brokerId
    /**
     * A list of information about allocated brokers.
     */
    val brokerInstances: List<BrokerInstance>? = builder.brokerInstances
    /**
     * The broker's name. This value must be unique in your AWS account, 1-50 characters long, must contain only letters, numbers, dashes, and underscores, and must not contain white spaces, brackets, wildcard characters, or special characters.
     */
    val brokerName: kotlin.String? = builder.brokerName
    /**
     * The broker's status.
     */
    val brokerState: aws.sdk.kotlin.services.mq.model.BrokerState? = builder.brokerState
    /**
     * The list of all revisions for the specified configuration.
     */
    val configurations: aws.sdk.kotlin.services.mq.model.Configurations? = builder.configurations
    /**
     * The time when the broker was created.
     */
    val created: aws.smithy.kotlin.runtime.time.Instant? = builder.created
    /**
     * The broker's deployment mode.
     */
    val deploymentMode: aws.sdk.kotlin.services.mq.model.DeploymentMode? = builder.deploymentMode
    /**
     * Encryption options for the broker. Does not apply to RabbitMQ brokers.
     */
    val encryptionOptions: aws.sdk.kotlin.services.mq.model.EncryptionOptions? = builder.encryptionOptions
    /**
     * The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.
     */
    val engineType: aws.sdk.kotlin.services.mq.model.EngineType? = builder.engineType
    /**
     * The broker engine's version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines.
     */
    val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The broker's instance type.
     */
    val hostInstanceType: kotlin.String? = builder.hostInstanceType
    /**
     * The metadata of the LDAP server used to authenticate and authorize connections to the broker.
     */
    val ldapServerMetadata: aws.sdk.kotlin.services.mq.model.LdapServerMetadataOutput? = builder.ldapServerMetadata
    /**
     * The list of information about logs currently enabled and pending to be deployed for the specified broker.
     */
    val logs: aws.sdk.kotlin.services.mq.model.LogsSummary? = builder.logs
    /**
     * The parameters that determine the WeeklyStartTime.
     */
    val maintenanceWindowStartTime: aws.sdk.kotlin.services.mq.model.WeeklyStartTime? = builder.maintenanceWindowStartTime
    /**
     * The authentication strategy that will be applied when the broker is rebooted. The default is SIMPLE.
     */
    val pendingAuthenticationStrategy: aws.sdk.kotlin.services.mq.model.AuthenticationStrategy? = builder.pendingAuthenticationStrategy
    /**
     * The broker engine version to upgrade to. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines.
     */
    val pendingEngineVersion: kotlin.String? = builder.pendingEngineVersion
    /**
     * The broker's host instance type to upgrade to. For a list of supported instance types, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types">Broker instance types.
     */
    val pendingHostInstanceType: kotlin.String? = builder.pendingHostInstanceType
    /**
     * The metadata of the LDAP server that will be used to authenticate and authorize connections to the broker after it is rebooted.
     */
    val pendingLdapServerMetadata: aws.sdk.kotlin.services.mq.model.LdapServerMetadataOutput? = builder.pendingLdapServerMetadata
    /**
     * The list of pending security groups to authorize connections to brokers.
     */
    val pendingSecurityGroups: List<String>? = builder.pendingSecurityGroups
    /**
     * Enables connections from applications outside of the VPC that hosts the broker's subnets.
     */
    val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.
     */
    val securityGroups: List<String>? = builder.securityGroups
    /**
     * The broker's storage type.
     */
    val storageType: aws.sdk.kotlin.services.mq.model.BrokerStorageType? = builder.storageType
    /**
     * The list of groups that define which subnets and IP ranges the broker can use from different Availability Zones.
     */
    val subnetIds: List<String>? = builder.subnetIds
    /**
     * The list of all tags associated with this broker.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The list of all broker usernames for the specified broker.
     */
    val users: List<UserSummary>? = builder.users

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mq.model.DescribeBrokerResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeBrokerResponse(")
        append("authenticationStrategy=$authenticationStrategy,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("brokerArn=$brokerArn,")
        append("brokerId=$brokerId,")
        append("brokerInstances=$brokerInstances,")
        append("brokerName=$brokerName,")
        append("brokerState=$brokerState,")
        append("configurations=$configurations,")
        append("created=$created,")
        append("deploymentMode=$deploymentMode,")
        append("encryptionOptions=$encryptionOptions,")
        append("engineType=$engineType,")
        append("engineVersion=$engineVersion,")
        append("hostInstanceType=$hostInstanceType,")
        append("ldapServerMetadata=$ldapServerMetadata,")
        append("logs=$logs,")
        append("maintenanceWindowStartTime=$maintenanceWindowStartTime,")
        append("pendingAuthenticationStrategy=$pendingAuthenticationStrategy,")
        append("pendingEngineVersion=$pendingEngineVersion,")
        append("pendingHostInstanceType=$pendingHostInstanceType,")
        append("pendingLdapServerMetadata=$pendingLdapServerMetadata,")
        append("pendingSecurityGroups=$pendingSecurityGroups,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("securityGroups=$securityGroups,")
        append("storageType=$storageType,")
        append("subnetIds=$subnetIds,")
        append("tags=$tags,")
        append("users=$users)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationStrategy?.hashCode() ?: 0
        result = 31 * result + (autoMinorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (brokerArn?.hashCode() ?: 0)
        result = 31 * result + (brokerId?.hashCode() ?: 0)
        result = 31 * result + (brokerInstances?.hashCode() ?: 0)
        result = 31 * result + (brokerName?.hashCode() ?: 0)
        result = 31 * result + (brokerState?.hashCode() ?: 0)
        result = 31 * result + (configurations?.hashCode() ?: 0)
        result = 31 * result + (created?.hashCode() ?: 0)
        result = 31 * result + (deploymentMode?.hashCode() ?: 0)
        result = 31 * result + (encryptionOptions?.hashCode() ?: 0)
        result = 31 * result + (engineType?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (hostInstanceType?.hashCode() ?: 0)
        result = 31 * result + (ldapServerMetadata?.hashCode() ?: 0)
        result = 31 * result + (logs?.hashCode() ?: 0)
        result = 31 * result + (maintenanceWindowStartTime?.hashCode() ?: 0)
        result = 31 * result + (pendingAuthenticationStrategy?.hashCode() ?: 0)
        result = 31 * result + (pendingEngineVersion?.hashCode() ?: 0)
        result = 31 * result + (pendingHostInstanceType?.hashCode() ?: 0)
        result = 31 * result + (pendingLdapServerMetadata?.hashCode() ?: 0)
        result = 31 * result + (pendingSecurityGroups?.hashCode() ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (users?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeBrokerResponse

        if (authenticationStrategy != other.authenticationStrategy) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (brokerArn != other.brokerArn) return false
        if (brokerId != other.brokerId) return false
        if (brokerInstances != other.brokerInstances) return false
        if (brokerName != other.brokerName) return false
        if (brokerState != other.brokerState) return false
        if (configurations != other.configurations) return false
        if (created != other.created) return false
        if (deploymentMode != other.deploymentMode) return false
        if (encryptionOptions != other.encryptionOptions) return false
        if (engineType != other.engineType) return false
        if (engineVersion != other.engineVersion) return false
        if (hostInstanceType != other.hostInstanceType) return false
        if (ldapServerMetadata != other.ldapServerMetadata) return false
        if (logs != other.logs) return false
        if (maintenanceWindowStartTime != other.maintenanceWindowStartTime) return false
        if (pendingAuthenticationStrategy != other.pendingAuthenticationStrategy) return false
        if (pendingEngineVersion != other.pendingEngineVersion) return false
        if (pendingHostInstanceType != other.pendingHostInstanceType) return false
        if (pendingLdapServerMetadata != other.pendingLdapServerMetadata) return false
        if (pendingSecurityGroups != other.pendingSecurityGroups) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (securityGroups != other.securityGroups) return false
        if (storageType != other.storageType) return false
        if (subnetIds != other.subnetIds) return false
        if (tags != other.tags) return false
        if (users != other.users) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mq.model.DescribeBrokerResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The authentication strategy used to secure the broker. The default is SIMPLE.
         */
        var authenticationStrategy: aws.sdk.kotlin.services.mq.model.AuthenticationStrategy? = null
        /**
         * Enables automatic upgrades to new minor versions for brokers, as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot.
         */
        var autoMinorVersionUpgrade: kotlin.Boolean? = null
        /**
         * The broker's Amazon Resource Name (ARN).
         */
        var brokerArn: kotlin.String? = null
        /**
         * The unique ID that Amazon MQ generates for the broker.
         */
        var brokerId: kotlin.String? = null
        /**
         * A list of information about allocated brokers.
         */
        var brokerInstances: List<BrokerInstance>? = null
        /**
         * The broker's name. This value must be unique in your AWS account, 1-50 characters long, must contain only letters, numbers, dashes, and underscores, and must not contain white spaces, brackets, wildcard characters, or special characters.
         */
        var brokerName: kotlin.String? = null
        /**
         * The broker's status.
         */
        var brokerState: aws.sdk.kotlin.services.mq.model.BrokerState? = null
        /**
         * The list of all revisions for the specified configuration.
         */
        var configurations: aws.sdk.kotlin.services.mq.model.Configurations? = null
        /**
         * The time when the broker was created.
         */
        var created: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The broker's deployment mode.
         */
        var deploymentMode: aws.sdk.kotlin.services.mq.model.DeploymentMode? = null
        /**
         * Encryption options for the broker. Does not apply to RabbitMQ brokers.
         */
        var encryptionOptions: aws.sdk.kotlin.services.mq.model.EncryptionOptions? = null
        /**
         * The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.
         */
        var engineType: aws.sdk.kotlin.services.mq.model.EngineType? = null
        /**
         * The broker engine's version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines.
         */
        var engineVersion: kotlin.String? = null
        /**
         * The broker's instance type.
         */
        var hostInstanceType: kotlin.String? = null
        /**
         * The metadata of the LDAP server used to authenticate and authorize connections to the broker.
         */
        var ldapServerMetadata: aws.sdk.kotlin.services.mq.model.LdapServerMetadataOutput? = null
        /**
         * The list of information about logs currently enabled and pending to be deployed for the specified broker.
         */
        var logs: aws.sdk.kotlin.services.mq.model.LogsSummary? = null
        /**
         * The parameters that determine the WeeklyStartTime.
         */
        var maintenanceWindowStartTime: aws.sdk.kotlin.services.mq.model.WeeklyStartTime? = null
        /**
         * The authentication strategy that will be applied when the broker is rebooted. The default is SIMPLE.
         */
        var pendingAuthenticationStrategy: aws.sdk.kotlin.services.mq.model.AuthenticationStrategy? = null
        /**
         * The broker engine version to upgrade to. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines.
         */
        var pendingEngineVersion: kotlin.String? = null
        /**
         * The broker's host instance type to upgrade to. For a list of supported instance types, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types">Broker instance types.
         */
        var pendingHostInstanceType: kotlin.String? = null
        /**
         * The metadata of the LDAP server that will be used to authenticate and authorize connections to the broker after it is rebooted.
         */
        var pendingLdapServerMetadata: aws.sdk.kotlin.services.mq.model.LdapServerMetadataOutput? = null
        /**
         * The list of pending security groups to authorize connections to brokers.
         */
        var pendingSecurityGroups: List<String>? = null
        /**
         * Enables connections from applications outside of the VPC that hosts the broker's subnets.
         */
        var publiclyAccessible: kotlin.Boolean? = null
        /**
         * The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.
         */
        var securityGroups: List<String>? = null
        /**
         * The broker's storage type.
         */
        var storageType: aws.sdk.kotlin.services.mq.model.BrokerStorageType? = null
        /**
         * The list of groups that define which subnets and IP ranges the broker can use from different Availability Zones.
         */
        var subnetIds: List<String>? = null
        /**
         * The list of all tags associated with this broker.
         */
        var tags: Map<String, String>? = null
        /**
         * The list of all broker usernames for the specified broker.
         */
        var users: List<UserSummary>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mq.model.DescribeBrokerResponse) : this() {
            this.authenticationStrategy = x.authenticationStrategy
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.brokerArn = x.brokerArn
            this.brokerId = x.brokerId
            this.brokerInstances = x.brokerInstances
            this.brokerName = x.brokerName
            this.brokerState = x.brokerState
            this.configurations = x.configurations
            this.created = x.created
            this.deploymentMode = x.deploymentMode
            this.encryptionOptions = x.encryptionOptions
            this.engineType = x.engineType
            this.engineVersion = x.engineVersion
            this.hostInstanceType = x.hostInstanceType
            this.ldapServerMetadata = x.ldapServerMetadata
            this.logs = x.logs
            this.maintenanceWindowStartTime = x.maintenanceWindowStartTime
            this.pendingAuthenticationStrategy = x.pendingAuthenticationStrategy
            this.pendingEngineVersion = x.pendingEngineVersion
            this.pendingHostInstanceType = x.pendingHostInstanceType
            this.pendingLdapServerMetadata = x.pendingLdapServerMetadata
            this.pendingSecurityGroups = x.pendingSecurityGroups
            this.publiclyAccessible = x.publiclyAccessible
            this.securityGroups = x.securityGroups
            this.storageType = x.storageType
            this.subnetIds = x.subnetIds
            this.tags = x.tags
            this.users = x.users
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mq.model.DescribeBrokerResponse = DescribeBrokerResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.Configurations] inside the given [block]
         */
        fun configurations(block: aws.sdk.kotlin.services.mq.model.Configurations.Builder.() -> kotlin.Unit) {
            this.configurations = aws.sdk.kotlin.services.mq.model.Configurations.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.EncryptionOptions] inside the given [block]
         */
        fun encryptionOptions(block: aws.sdk.kotlin.services.mq.model.EncryptionOptions.Builder.() -> kotlin.Unit) {
            this.encryptionOptions = aws.sdk.kotlin.services.mq.model.EncryptionOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.LdapServerMetadataOutput] inside the given [block]
         */
        fun ldapServerMetadata(block: aws.sdk.kotlin.services.mq.model.LdapServerMetadataOutput.Builder.() -> kotlin.Unit) {
            this.ldapServerMetadata = aws.sdk.kotlin.services.mq.model.LdapServerMetadataOutput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.LogsSummary] inside the given [block]
         */
        fun logs(block: aws.sdk.kotlin.services.mq.model.LogsSummary.Builder.() -> kotlin.Unit) {
            this.logs = aws.sdk.kotlin.services.mq.model.LogsSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.WeeklyStartTime] inside the given [block]
         */
        fun maintenanceWindowStartTime(block: aws.sdk.kotlin.services.mq.model.WeeklyStartTime.Builder.() -> kotlin.Unit) {
            this.maintenanceWindowStartTime = aws.sdk.kotlin.services.mq.model.WeeklyStartTime.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.LdapServerMetadataOutput] inside the given [block]
         */
        fun pendingLdapServerMetadata(block: aws.sdk.kotlin.services.mq.model.LdapServerMetadataOutput.Builder.() -> kotlin.Unit) {
            this.pendingLdapServerMetadata = aws.sdk.kotlin.services.mq.model.LdapServerMetadataOutput.invoke(block)
        }
    }
}
