// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mq.model



/**
 * Creates a new configuration for the specified configuration name. Amazon MQ uses the default configuration (the engine type and version).
 */
class CreateConfigurationRequest private constructor(builder: Builder) {
    /**
     * Optional. The authentication strategy associated with the configuration. The default is SIMPLE.
     */
    val authenticationStrategy: aws.sdk.kotlin.services.mq.model.AuthenticationStrategy? = builder.authenticationStrategy
    /**
     * Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.
     */
    val engineType: aws.sdk.kotlin.services.mq.model.EngineType? = builder.engineType
    /**
     * Required. The broker engine's version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines.
     */
    val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.
     */
    val name: kotlin.String? = builder.name
    /**
     * Create tags when creating the configuration.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mq.model.CreateConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateConfigurationRequest(")
        append("authenticationStrategy=$authenticationStrategy,")
        append("engineType=$engineType,")
        append("engineVersion=$engineVersion,")
        append("name=$name,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationStrategy?.hashCode() ?: 0
        result = 31 * result + (engineType?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateConfigurationRequest

        if (authenticationStrategy != other.authenticationStrategy) return false
        if (engineType != other.engineType) return false
        if (engineVersion != other.engineVersion) return false
        if (name != other.name) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mq.model.CreateConfigurationRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Optional. The authentication strategy associated with the configuration. The default is SIMPLE.
         */
        var authenticationStrategy: aws.sdk.kotlin.services.mq.model.AuthenticationStrategy? = null
        /**
         * Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.
         */
        var engineType: aws.sdk.kotlin.services.mq.model.EngineType? = null
        /**
         * Required. The broker engine's version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines.
         */
        var engineVersion: kotlin.String? = null
        /**
         * Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.
         */
        var name: kotlin.String? = null
        /**
         * Create tags when creating the configuration.
         */
        var tags: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mq.model.CreateConfigurationRequest) : this() {
            this.authenticationStrategy = x.authenticationStrategy
            this.engineType = x.engineType
            this.engineVersion = x.engineVersion
            this.name = x.name
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mq.model.CreateConfigurationRequest = CreateConfigurationRequest(this)
    }
}
