// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mq.model



/**
 * Creates a broker using the specified properties.
 */
class CreateBrokerRequest private constructor(builder: Builder) {
    /**
     * Optional. The authentication strategy used to secure the broker. The default is SIMPLE.
     */
    val authenticationStrategy: aws.sdk.kotlin.services.mq.model.AuthenticationStrategy? = builder.authenticationStrategy
    /**
     * Enables automatic upgrades to new minor versions for brokers, as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot. Set to true by default, if no value is specified.
     */
    val autoMinorVersionUpgrade: kotlin.Boolean? = builder.autoMinorVersionUpgrade
    /**
     * Required. The broker's name. This value must be unique in your AWS account, 1-50 characters long, must contain only letters, numbers, dashes, and underscores, and must not contain white spaces, brackets, wildcard characters, or special characters.
     */
    val brokerName: kotlin.String? = builder.brokerName
    /**
     * A list of information about the configuration.
     */
    val configuration: aws.sdk.kotlin.services.mq.model.ConfigurationId? = builder.configuration
    /**
     * The unique ID that the requester receives for the created broker. Amazon MQ passes your ID with the API action. Note: We recommend using a Universally Unique Identifier (UUID) for the creatorRequestId. You may omit the creatorRequestId if your application doesn't require idempotency.
     */
    val creatorRequestId: kotlin.String? = builder.creatorRequestId
    /**
     * Required. The broker's deployment mode.
     */
    val deploymentMode: aws.sdk.kotlin.services.mq.model.DeploymentMode? = builder.deploymentMode
    /**
     * Encryption options for the broker. Does not apply to RabbitMQ brokers.
     */
    val encryptionOptions: aws.sdk.kotlin.services.mq.model.EncryptionOptions? = builder.encryptionOptions
    /**
     * Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.
     */
    val engineType: aws.sdk.kotlin.services.mq.model.EngineType? = builder.engineType
    /**
     * Required. The broker engine's version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines.
     */
    val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * Required. The broker's instance type.
     */
    val hostInstanceType: kotlin.String? = builder.hostInstanceType
    /**
     * Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.
     */
    val ldapServerMetadata: aws.sdk.kotlin.services.mq.model.LdapServerMetadataInput? = builder.ldapServerMetadata
    /**
     * Enables Amazon CloudWatch logging for brokers.
     */
    val logs: aws.sdk.kotlin.services.mq.model.Logs? = builder.logs
    /**
     * The parameters that determine the WeeklyStartTime.
     */
    val maintenanceWindowStartTime: aws.sdk.kotlin.services.mq.model.WeeklyStartTime? = builder.maintenanceWindowStartTime
    /**
     * Enables connections from applications outside of the VPC that hosts the broker's subnets. Set to false by default, if no value is provided.
     */
    val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.
     */
    val securityGroups: List<String>? = builder.securityGroups
    /**
     * The broker's storage type.
     */
    val storageType: aws.sdk.kotlin.services.mq.model.BrokerStorageType? = builder.storageType
    /**
     * The list of groups that define which subnets and IP ranges the broker can use from different Availability Zones. If you specify more than one subnet, the subnets must be in different Availability Zones. Amazon MQ will not be able to create VPC endpoints for your broker with multiple subnets in the same Availability Zone. A SINGLE_INSTANCE deployment requires one subnet (for example, the default subnet). An ACTIVE_STANDBY_MULTI_AZ Amazon MQ for ActiveMQ deployment requires two subnets. A CLUSTER_MULTI_AZ Amazon MQ for RabbitMQ deployment has no subnet requirements when deployed with public accessibility. Deployment without public accessibility requires at least one subnet. If you specify subnets in a <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-sharing.html">shared VPC for a RabbitMQ broker, the associated VPC to which the specified subnets belong must be owned by your AWS account. Amazon MQ will not be able to create VPC endpoints in VPCs that are not owned by your AWS account.
     */
    val subnetIds: List<String>? = builder.subnetIds
    /**
     * Create tags when creating the broker.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * Required. The list of broker users (persons or applications) who can access queues and topics. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long. <title>Amazon MQ for RabbitMQ</title> When you create an Amazon MQ for RabbitMQ broker, one and only one administrative user is accepted and created when a broker is first provisioned. All subsequent broker users are created by making RabbitMQ API calls directly to brokers or via the RabbitMQ web console.
     */
    val users: List<User>? = builder.users

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mq.model.CreateBrokerRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateBrokerRequest(")
        append("authenticationStrategy=$authenticationStrategy,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("brokerName=$brokerName,")
        append("configuration=$configuration,")
        append("creatorRequestId=$creatorRequestId,")
        append("deploymentMode=$deploymentMode,")
        append("encryptionOptions=$encryptionOptions,")
        append("engineType=$engineType,")
        append("engineVersion=$engineVersion,")
        append("hostInstanceType=$hostInstanceType,")
        append("ldapServerMetadata=$ldapServerMetadata,")
        append("logs=$logs,")
        append("maintenanceWindowStartTime=$maintenanceWindowStartTime,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("securityGroups=$securityGroups,")
        append("storageType=$storageType,")
        append("subnetIds=$subnetIds,")
        append("tags=$tags,")
        append("users=$users)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationStrategy?.hashCode() ?: 0
        result = 31 * result + (autoMinorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (brokerName?.hashCode() ?: 0)
        result = 31 * result + (configuration?.hashCode() ?: 0)
        result = 31 * result + (creatorRequestId?.hashCode() ?: 0)
        result = 31 * result + (deploymentMode?.hashCode() ?: 0)
        result = 31 * result + (encryptionOptions?.hashCode() ?: 0)
        result = 31 * result + (engineType?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (hostInstanceType?.hashCode() ?: 0)
        result = 31 * result + (ldapServerMetadata?.hashCode() ?: 0)
        result = 31 * result + (logs?.hashCode() ?: 0)
        result = 31 * result + (maintenanceWindowStartTime?.hashCode() ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (users?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateBrokerRequest

        if (authenticationStrategy != other.authenticationStrategy) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (brokerName != other.brokerName) return false
        if (configuration != other.configuration) return false
        if (creatorRequestId != other.creatorRequestId) return false
        if (deploymentMode != other.deploymentMode) return false
        if (encryptionOptions != other.encryptionOptions) return false
        if (engineType != other.engineType) return false
        if (engineVersion != other.engineVersion) return false
        if (hostInstanceType != other.hostInstanceType) return false
        if (ldapServerMetadata != other.ldapServerMetadata) return false
        if (logs != other.logs) return false
        if (maintenanceWindowStartTime != other.maintenanceWindowStartTime) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (securityGroups != other.securityGroups) return false
        if (storageType != other.storageType) return false
        if (subnetIds != other.subnetIds) return false
        if (tags != other.tags) return false
        if (users != other.users) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mq.model.CreateBrokerRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Optional. The authentication strategy used to secure the broker. The default is SIMPLE.
         */
        var authenticationStrategy: aws.sdk.kotlin.services.mq.model.AuthenticationStrategy? = null
        /**
         * Enables automatic upgrades to new minor versions for brokers, as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot. Set to true by default, if no value is specified.
         */
        var autoMinorVersionUpgrade: kotlin.Boolean? = null
        /**
         * Required. The broker's name. This value must be unique in your AWS account, 1-50 characters long, must contain only letters, numbers, dashes, and underscores, and must not contain white spaces, brackets, wildcard characters, or special characters.
         */
        var brokerName: kotlin.String? = null
        /**
         * A list of information about the configuration.
         */
        var configuration: aws.sdk.kotlin.services.mq.model.ConfigurationId? = null
        /**
         * The unique ID that the requester receives for the created broker. Amazon MQ passes your ID with the API action. Note: We recommend using a Universally Unique Identifier (UUID) for the creatorRequestId. You may omit the creatorRequestId if your application doesn't require idempotency.
         */
        var creatorRequestId: kotlin.String? = null
        /**
         * Required. The broker's deployment mode.
         */
        var deploymentMode: aws.sdk.kotlin.services.mq.model.DeploymentMode? = null
        /**
         * Encryption options for the broker. Does not apply to RabbitMQ brokers.
         */
        var encryptionOptions: aws.sdk.kotlin.services.mq.model.EncryptionOptions? = null
        /**
         * Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.
         */
        var engineType: aws.sdk.kotlin.services.mq.model.EngineType? = null
        /**
         * Required. The broker engine's version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines.
         */
        var engineVersion: kotlin.String? = null
        /**
         * Required. The broker's instance type.
         */
        var hostInstanceType: kotlin.String? = null
        /**
         * Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.
         */
        var ldapServerMetadata: aws.sdk.kotlin.services.mq.model.LdapServerMetadataInput? = null
        /**
         * Enables Amazon CloudWatch logging for brokers.
         */
        var logs: aws.sdk.kotlin.services.mq.model.Logs? = null
        /**
         * The parameters that determine the WeeklyStartTime.
         */
        var maintenanceWindowStartTime: aws.sdk.kotlin.services.mq.model.WeeklyStartTime? = null
        /**
         * Enables connections from applications outside of the VPC that hosts the broker's subnets. Set to false by default, if no value is provided.
         */
        var publiclyAccessible: kotlin.Boolean? = null
        /**
         * The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.
         */
        var securityGroups: List<String>? = null
        /**
         * The broker's storage type.
         */
        var storageType: aws.sdk.kotlin.services.mq.model.BrokerStorageType? = null
        /**
         * The list of groups that define which subnets and IP ranges the broker can use from different Availability Zones. If you specify more than one subnet, the subnets must be in different Availability Zones. Amazon MQ will not be able to create VPC endpoints for your broker with multiple subnets in the same Availability Zone. A SINGLE_INSTANCE deployment requires one subnet (for example, the default subnet). An ACTIVE_STANDBY_MULTI_AZ Amazon MQ for ActiveMQ deployment requires two subnets. A CLUSTER_MULTI_AZ Amazon MQ for RabbitMQ deployment has no subnet requirements when deployed with public accessibility. Deployment without public accessibility requires at least one subnet. If you specify subnets in a <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-sharing.html">shared VPC for a RabbitMQ broker, the associated VPC to which the specified subnets belong must be owned by your AWS account. Amazon MQ will not be able to create VPC endpoints in VPCs that are not owned by your AWS account.
         */
        var subnetIds: List<String>? = null
        /**
         * Create tags when creating the broker.
         */
        var tags: Map<String, String>? = null
        /**
         * Required. The list of broker users (persons or applications) who can access queues and topics. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long. <title>Amazon MQ for RabbitMQ</title> When you create an Amazon MQ for RabbitMQ broker, one and only one administrative user is accepted and created when a broker is first provisioned. All subsequent broker users are created by making RabbitMQ API calls directly to brokers or via the RabbitMQ web console.
         */
        var users: List<User>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mq.model.CreateBrokerRequest) : this() {
            this.authenticationStrategy = x.authenticationStrategy
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.brokerName = x.brokerName
            this.configuration = x.configuration
            this.creatorRequestId = x.creatorRequestId
            this.deploymentMode = x.deploymentMode
            this.encryptionOptions = x.encryptionOptions
            this.engineType = x.engineType
            this.engineVersion = x.engineVersion
            this.hostInstanceType = x.hostInstanceType
            this.ldapServerMetadata = x.ldapServerMetadata
            this.logs = x.logs
            this.maintenanceWindowStartTime = x.maintenanceWindowStartTime
            this.publiclyAccessible = x.publiclyAccessible
            this.securityGroups = x.securityGroups
            this.storageType = x.storageType
            this.subnetIds = x.subnetIds
            this.tags = x.tags
            this.users = x.users
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mq.model.CreateBrokerRequest = CreateBrokerRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.ConfigurationId] inside the given [block]
         */
        fun configuration(block: aws.sdk.kotlin.services.mq.model.ConfigurationId.Builder.() -> kotlin.Unit) {
            this.configuration = aws.sdk.kotlin.services.mq.model.ConfigurationId.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.EncryptionOptions] inside the given [block]
         */
        fun encryptionOptions(block: aws.sdk.kotlin.services.mq.model.EncryptionOptions.Builder.() -> kotlin.Unit) {
            this.encryptionOptions = aws.sdk.kotlin.services.mq.model.EncryptionOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.LdapServerMetadataInput] inside the given [block]
         */
        fun ldapServerMetadata(block: aws.sdk.kotlin.services.mq.model.LdapServerMetadataInput.Builder.() -> kotlin.Unit) {
            this.ldapServerMetadata = aws.sdk.kotlin.services.mq.model.LdapServerMetadataInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.Logs] inside the given [block]
         */
        fun logs(block: aws.sdk.kotlin.services.mq.model.Logs.Builder.() -> kotlin.Unit) {
            this.logs = aws.sdk.kotlin.services.mq.model.Logs.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.WeeklyStartTime] inside the given [block]
         */
        fun maintenanceWindowStartTime(block: aws.sdk.kotlin.services.mq.model.WeeklyStartTime.Builder.() -> kotlin.Unit) {
            this.maintenanceWindowStartTime = aws.sdk.kotlin.services.mq.model.WeeklyStartTime.invoke(block)
        }
    }
}
