// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mq.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Returns information about all brokers.
 */
class BrokerSummary private constructor(builder: Builder) {
    /**
     * The broker's Amazon Resource Name (ARN).
     */
    val brokerArn: kotlin.String? = builder.brokerArn
    /**
     * The unique ID that Amazon MQ generates for the broker.
     */
    val brokerId: kotlin.String? = builder.brokerId
    /**
     * The broker's name. This value is unique in your AWS account, 1-50 characters long, and containing only letters, numbers, dashes, and underscores, and must not contain white spaces, brackets, wildcard characters, or special characters.
     */
    val brokerName: kotlin.String? = builder.brokerName
    /**
     * The broker's status.
     */
    val brokerState: aws.sdk.kotlin.services.mq.model.BrokerState? = builder.brokerState
    /**
     * The time when the broker was created.
     */
    val created: aws.smithy.kotlin.runtime.time.Instant? = builder.created
    /**
     * The broker's deployment mode.
     */
    val deploymentMode: aws.sdk.kotlin.services.mq.model.DeploymentMode? = builder.deploymentMode
    /**
     * The type of broker engine.
     */
    val engineType: aws.sdk.kotlin.services.mq.model.EngineType? = builder.engineType
    /**
     * The broker's instance type.
     */
    val hostInstanceType: kotlin.String? = builder.hostInstanceType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mq.model.BrokerSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BrokerSummary(")
        append("brokerArn=$brokerArn,")
        append("brokerId=$brokerId,")
        append("brokerName=$brokerName,")
        append("brokerState=$brokerState,")
        append("created=$created,")
        append("deploymentMode=$deploymentMode,")
        append("engineType=$engineType,")
        append("hostInstanceType=$hostInstanceType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = brokerArn?.hashCode() ?: 0
        result = 31 * result + (brokerId?.hashCode() ?: 0)
        result = 31 * result + (brokerName?.hashCode() ?: 0)
        result = 31 * result + (brokerState?.hashCode() ?: 0)
        result = 31 * result + (created?.hashCode() ?: 0)
        result = 31 * result + (deploymentMode?.hashCode() ?: 0)
        result = 31 * result + (engineType?.hashCode() ?: 0)
        result = 31 * result + (hostInstanceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as BrokerSummary

        if (brokerArn != other.brokerArn) return false
        if (brokerId != other.brokerId) return false
        if (brokerName != other.brokerName) return false
        if (brokerState != other.brokerState) return false
        if (created != other.created) return false
        if (deploymentMode != other.deploymentMode) return false
        if (engineType != other.engineType) return false
        if (hostInstanceType != other.hostInstanceType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mq.model.BrokerSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The broker's Amazon Resource Name (ARN).
         */
        var brokerArn: kotlin.String? = null
        /**
         * The unique ID that Amazon MQ generates for the broker.
         */
        var brokerId: kotlin.String? = null
        /**
         * The broker's name. This value is unique in your AWS account, 1-50 characters long, and containing only letters, numbers, dashes, and underscores, and must not contain white spaces, brackets, wildcard characters, or special characters.
         */
        var brokerName: kotlin.String? = null
        /**
         * The broker's status.
         */
        var brokerState: aws.sdk.kotlin.services.mq.model.BrokerState? = null
        /**
         * The time when the broker was created.
         */
        var created: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The broker's deployment mode.
         */
        var deploymentMode: aws.sdk.kotlin.services.mq.model.DeploymentMode? = null
        /**
         * The type of broker engine.
         */
        var engineType: aws.sdk.kotlin.services.mq.model.EngineType? = null
        /**
         * The broker's instance type.
         */
        var hostInstanceType: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mq.model.BrokerSummary) : this() {
            this.brokerArn = x.brokerArn
            this.brokerId = x.brokerId
            this.brokerName = x.brokerName
            this.brokerState = x.brokerState
            this.created = x.created
            this.deploymentMode = x.deploymentMode
            this.engineType = x.engineType
            this.hostInstanceType = x.hostInstanceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mq.model.BrokerSummary = BrokerSummary(this)
    }
}
