// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mq

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.mq.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.mq.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * Amazon MQ is a managed message broker service for Apache ActiveMQ and RabbitMQ that makes it easy to set up and operate message brokers in the cloud. A message broker allows software applications and components to communicate using various programming languages, operating systems, and formal messaging protocols.
 */
interface MqClient : SdkClient {

    override val serviceName: String
        get() = "mq"
    /**
     * MqClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.Builder.() -> Unit = {}): MqClient {
            val config = Config.Builder().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
            }.apply(block).build()
            return DefaultMqClient(config)
        }

        operator fun invoke(config: Config): MqClient = DefaultMqClient(config)

        /**
         * Construct a [MqClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): MqClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return MqClient(sharedConfig)
        }
    }

    class Config private constructor(builder: Builder): AwsClientConfig, HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a broker. Note: This API is asynchronous. To create a broker, you must either use the AmazonMQFullAccess IAM policy or include the following EC2 permissions in your IAM policy. ec2:CreateNetworkInterface This permission is required to allow Amazon MQ to create an elastic network interface (ENI) on behalf of your account. ec2:CreateNetworkInterfacePermission This permission is required to attach the ENI to the broker instance. ec2:DeleteNetworkInterface ec2:DeleteNetworkInterfacePermission ec2:DetachNetworkInterface ec2:DescribeInternetGateways ec2:DescribeNetworkInterfaces ec2:DescribeNetworkInterfacePermissions ec2:DescribeRouteTables ec2:DescribeSecurityGroups ec2:DescribeSubnets ec2:DescribeVpcs For more information, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/amazon-mq-setting-up.html#create-iam-user">Create an IAM User and Get Your AWS Credentials and <a href="https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/connecting-to-amazon-mq.html#never-modify-delete-elastic-network-interface">Never Modify or Delete the Amazon MQ Elastic Network Interface in the Amazon MQ Developer Guide.
     */
    suspend fun createBroker(input: CreateBrokerRequest): CreateBrokerResponse

    /**
     * Creates a broker. Note: This API is asynchronous. To create a broker, you must either use the AmazonMQFullAccess IAM policy or include the following EC2 permissions in your IAM policy. ec2:CreateNetworkInterface This permission is required to allow Amazon MQ to create an elastic network interface (ENI) on behalf of your account. ec2:CreateNetworkInterfacePermission This permission is required to attach the ENI to the broker instance. ec2:DeleteNetworkInterface ec2:DeleteNetworkInterfacePermission ec2:DetachNetworkInterface ec2:DescribeInternetGateways ec2:DescribeNetworkInterfaces ec2:DescribeNetworkInterfacePermissions ec2:DescribeRouteTables ec2:DescribeSecurityGroups ec2:DescribeSubnets ec2:DescribeVpcs For more information, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/amazon-mq-setting-up.html#create-iam-user">Create an IAM User and Get Your AWS Credentials and <a href="https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/connecting-to-amazon-mq.html#never-modify-delete-elastic-network-interface">Never Modify or Delete the Amazon MQ Elastic Network Interface in the Amazon MQ Developer Guide.
     */
    suspend fun createBroker(block: CreateBrokerRequest.Builder.() -> Unit) = createBroker(CreateBrokerRequest.Builder().apply(block).build())

    /**
     * Creates a new configuration for the specified configuration name. Amazon MQ uses the default configuration (the engine type and version).
     */
    suspend fun createConfiguration(input: CreateConfigurationRequest): CreateConfigurationResponse

    /**
     * Creates a new configuration for the specified configuration name. Amazon MQ uses the default configuration (the engine type and version).
     */
    suspend fun createConfiguration(block: CreateConfigurationRequest.Builder.() -> Unit) = createConfiguration(CreateConfigurationRequest.Builder().apply(block).build())

    /**
     * Add a tag to a resource.
     */
    suspend fun createTags(input: CreateTagsRequest): CreateTagsResponse

    /**
     * Add a tag to a resource.
     */
    suspend fun createTags(block: CreateTagsRequest.Builder.() -> Unit) = createTags(CreateTagsRequest.Builder().apply(block).build())

    /**
     * Creates an ActiveMQ user.
     */
    suspend fun createUser(input: CreateUserRequest): CreateUserResponse

    /**
     * Creates an ActiveMQ user.
     */
    suspend fun createUser(block: CreateUserRequest.Builder.() -> Unit) = createUser(CreateUserRequest.Builder().apply(block).build())

    /**
     * Deletes a broker. Note: This API is asynchronous.
     */
    suspend fun deleteBroker(input: DeleteBrokerRequest): DeleteBrokerResponse

    /**
     * Deletes a broker. Note: This API is asynchronous.
     */
    suspend fun deleteBroker(block: DeleteBrokerRequest.Builder.() -> Unit) = deleteBroker(DeleteBrokerRequest.Builder().apply(block).build())

    /**
     * Removes a tag from a resource.
     */
    suspend fun deleteTags(input: DeleteTagsRequest): DeleteTagsResponse

    /**
     * Removes a tag from a resource.
     */
    suspend fun deleteTags(block: DeleteTagsRequest.Builder.() -> Unit) = deleteTags(DeleteTagsRequest.Builder().apply(block).build())

    /**
     * Deletes an ActiveMQ user.
     */
    suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse

    /**
     * Deletes an ActiveMQ user.
     */
    suspend fun deleteUser(block: DeleteUserRequest.Builder.() -> Unit) = deleteUser(DeleteUserRequest.Builder().apply(block).build())

    /**
     * Returns information about the specified broker.
     */
    suspend fun describeBroker(input: DescribeBrokerRequest): DescribeBrokerResponse

    /**
     * Returns information about the specified broker.
     */
    suspend fun describeBroker(block: DescribeBrokerRequest.Builder.() -> Unit) = describeBroker(DescribeBrokerRequest.Builder().apply(block).build())

    /**
     * Describe available engine types and versions.
     */
    suspend fun describeBrokerEngineTypes(input: DescribeBrokerEngineTypesRequest): DescribeBrokerEngineTypesResponse

    /**
     * Describe available engine types and versions.
     */
    suspend fun describeBrokerEngineTypes(block: DescribeBrokerEngineTypesRequest.Builder.() -> Unit) = describeBrokerEngineTypes(DescribeBrokerEngineTypesRequest.Builder().apply(block).build())

    /**
     * Describe available broker instance options.
     */
    suspend fun describeBrokerInstanceOptions(input: DescribeBrokerInstanceOptionsRequest): DescribeBrokerInstanceOptionsResponse

    /**
     * Describe available broker instance options.
     */
    suspend fun describeBrokerInstanceOptions(block: DescribeBrokerInstanceOptionsRequest.Builder.() -> Unit) = describeBrokerInstanceOptions(DescribeBrokerInstanceOptionsRequest.Builder().apply(block).build())

    /**
     * Returns information about the specified configuration.
     */
    suspend fun describeConfiguration(input: DescribeConfigurationRequest): DescribeConfigurationResponse

    /**
     * Returns information about the specified configuration.
     */
    suspend fun describeConfiguration(block: DescribeConfigurationRequest.Builder.() -> Unit) = describeConfiguration(DescribeConfigurationRequest.Builder().apply(block).build())

    /**
     * Returns the specified configuration revision for the specified configuration.
     */
    suspend fun describeConfigurationRevision(input: DescribeConfigurationRevisionRequest): DescribeConfigurationRevisionResponse

    /**
     * Returns the specified configuration revision for the specified configuration.
     */
    suspend fun describeConfigurationRevision(block: DescribeConfigurationRevisionRequest.Builder.() -> Unit) = describeConfigurationRevision(DescribeConfigurationRevisionRequest.Builder().apply(block).build())

    /**
     * Returns information about an ActiveMQ user.
     */
    suspend fun describeUser(input: DescribeUserRequest): DescribeUserResponse

    /**
     * Returns information about an ActiveMQ user.
     */
    suspend fun describeUser(block: DescribeUserRequest.Builder.() -> Unit) = describeUser(DescribeUserRequest.Builder().apply(block).build())

    /**
     * Returns a list of all brokers.
     */
    suspend fun listBrokers(input: ListBrokersRequest): ListBrokersResponse

    /**
     * Returns a list of all brokers.
     */
    suspend fun listBrokers(block: ListBrokersRequest.Builder.() -> Unit) = listBrokers(ListBrokersRequest.Builder().apply(block).build())

    /**
     * Returns a list of all revisions for the specified configuration.
     */
    suspend fun listConfigurationRevisions(input: ListConfigurationRevisionsRequest): ListConfigurationRevisionsResponse

    /**
     * Returns a list of all revisions for the specified configuration.
     */
    suspend fun listConfigurationRevisions(block: ListConfigurationRevisionsRequest.Builder.() -> Unit) = listConfigurationRevisions(ListConfigurationRevisionsRequest.Builder().apply(block).build())

    /**
     * Returns a list of all configurations.
     */
    suspend fun listConfigurations(input: ListConfigurationsRequest): ListConfigurationsResponse

    /**
     * Returns a list of all configurations.
     */
    suspend fun listConfigurations(block: ListConfigurationsRequest.Builder.() -> Unit) = listConfigurations(ListConfigurationsRequest.Builder().apply(block).build())

    /**
     * Lists tags for a resource.
     */
    suspend fun listTags(input: ListTagsRequest): ListTagsResponse

    /**
     * Lists tags for a resource.
     */
    suspend fun listTags(block: ListTagsRequest.Builder.() -> Unit) = listTags(ListTagsRequest.Builder().apply(block).build())

    /**
     * Returns a list of all ActiveMQ users.
     */
    suspend fun listUsers(input: ListUsersRequest): ListUsersResponse

    /**
     * Returns a list of all ActiveMQ users.
     */
    suspend fun listUsers(block: ListUsersRequest.Builder.() -> Unit) = listUsers(ListUsersRequest.Builder().apply(block).build())

    /**
     * Reboots a broker. Note: This API is asynchronous.
     */
    suspend fun rebootBroker(input: RebootBrokerRequest): RebootBrokerResponse

    /**
     * Reboots a broker. Note: This API is asynchronous.
     */
    suspend fun rebootBroker(block: RebootBrokerRequest.Builder.() -> Unit) = rebootBroker(RebootBrokerRequest.Builder().apply(block).build())

    /**
     * Adds a pending configuration change to a broker.
     */
    suspend fun updateBroker(input: UpdateBrokerRequest): UpdateBrokerResponse

    /**
     * Adds a pending configuration change to a broker.
     */
    suspend fun updateBroker(block: UpdateBrokerRequest.Builder.() -> Unit) = updateBroker(UpdateBrokerRequest.Builder().apply(block).build())

    /**
     * Updates the specified configuration.
     */
    suspend fun updateConfiguration(input: UpdateConfigurationRequest): UpdateConfigurationResponse

    /**
     * Updates the specified configuration.
     */
    suspend fun updateConfiguration(block: UpdateConfigurationRequest.Builder.() -> Unit) = updateConfiguration(UpdateConfigurationRequest.Builder().apply(block).build())

    /**
     * Updates the information for an ActiveMQ user.
     */
    suspend fun updateUser(input: UpdateUserRequest): UpdateUserResponse

    /**
     * Updates the information for an ActiveMQ user.
     */
    suspend fun updateUser(block: UpdateUserRequest.Builder.() -> Unit) = updateUser(UpdateUserRequest.Builder().apply(block).build())
}
