// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mq

import aws.sdk.kotlin.runtime.auth.signing.AwsSigV4SigningMiddleware
import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.mq.model.*
import aws.sdk.kotlin.services.mq.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.middleware.Retry
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "mq"
const val ServiceApiVersion: String = "2017-11-27"
const val SdkVersion: String = "0.9.3-alpha"

internal class DefaultMqClient(override val config: MqClient.Config) : MqClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Creates a broker. Note: This API is asynchronous. To create a broker, you must either use the AmazonMQFullAccess IAM policy or include the following EC2 permissions in your IAM policy. ec2:CreateNetworkInterface This permission is required to allow Amazon MQ to create an elastic network interface (ENI) on behalf of your account. ec2:CreateNetworkInterfacePermission This permission is required to attach the ENI to the broker instance. ec2:DeleteNetworkInterface ec2:DeleteNetworkInterfacePermission ec2:DetachNetworkInterface ec2:DescribeInternetGateways ec2:DescribeNetworkInterfaces ec2:DescribeNetworkInterfacePermissions ec2:DescribeRouteTables ec2:DescribeSecurityGroups ec2:DescribeSubnets ec2:DescribeVpcs For more information, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/amazon-mq-setting-up.html#create-iam-user">Create an IAM User and Get Your AWS Credentials and <a href="https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/connecting-to-amazon-mq.html#never-modify-delete-elastic-network-interface">Never Modify or Delete the Amazon MQ Elastic Network Interface in the Amazon MQ Developer Guide.
     */
    override suspend fun createBroker(input: CreateBrokerRequest): CreateBrokerResponse {
        val op = SdkHttpOperation.build<CreateBrokerRequest, CreateBrokerResponse> {
            serializer = CreateBrokerOperationSerializer()
            deserializer = CreateBrokerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateBroker"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "mq"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new configuration for the specified configuration name. Amazon MQ uses the default configuration (the engine type and version).
     */
    override suspend fun createConfiguration(input: CreateConfigurationRequest): CreateConfigurationResponse {
        val op = SdkHttpOperation.build<CreateConfigurationRequest, CreateConfigurationResponse> {
            serializer = CreateConfigurationOperationSerializer()
            deserializer = CreateConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "mq"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Add a tag to a resource.
     */
    override suspend fun createTags(input: CreateTagsRequest): CreateTagsResponse {
        val op = SdkHttpOperation.build<CreateTagsRequest, CreateTagsResponse> {
            serializer = CreateTagsOperationSerializer()
            deserializer = CreateTagsOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "CreateTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "mq"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Creates an ActiveMQ user.
     */
    override suspend fun createUser(input: CreateUserRequest): CreateUserResponse {
        val op = SdkHttpOperation.build<CreateUserRequest, CreateUserResponse> {
            serializer = CreateUserOperationSerializer()
            deserializer = CreateUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "mq"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a broker. Note: This API is asynchronous.
     */
    override suspend fun deleteBroker(input: DeleteBrokerRequest): DeleteBrokerResponse {
        val op = SdkHttpOperation.build<DeleteBrokerRequest, DeleteBrokerResponse> {
            serializer = DeleteBrokerOperationSerializer()
            deserializer = DeleteBrokerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteBroker"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "mq"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Removes a tag from a resource.
     */
    override suspend fun deleteTags(input: DeleteTagsRequest): DeleteTagsResponse {
        val op = SdkHttpOperation.build<DeleteTagsRequest, DeleteTagsResponse> {
            serializer = DeleteTagsOperationSerializer()
            deserializer = DeleteTagsOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "mq"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an ActiveMQ user.
     */
    override suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse {
        val op = SdkHttpOperation.build<DeleteUserRequest, DeleteUserResponse> {
            serializer = DeleteUserOperationSerializer()
            deserializer = DeleteUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "mq"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the specified broker.
     */
    override suspend fun describeBroker(input: DescribeBrokerRequest): DescribeBrokerResponse {
        val op = SdkHttpOperation.build<DescribeBrokerRequest, DescribeBrokerResponse> {
            serializer = DescribeBrokerOperationSerializer()
            deserializer = DescribeBrokerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeBroker"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "mq"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Describe available engine types and versions.
     */
    override suspend fun describeBrokerEngineTypes(input: DescribeBrokerEngineTypesRequest): DescribeBrokerEngineTypesResponse {
        val op = SdkHttpOperation.build<DescribeBrokerEngineTypesRequest, DescribeBrokerEngineTypesResponse> {
            serializer = DescribeBrokerEngineTypesOperationSerializer()
            deserializer = DescribeBrokerEngineTypesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeBrokerEngineTypes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "mq"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Describe available broker instance options.
     */
    override suspend fun describeBrokerInstanceOptions(input: DescribeBrokerInstanceOptionsRequest): DescribeBrokerInstanceOptionsResponse {
        val op = SdkHttpOperation.build<DescribeBrokerInstanceOptionsRequest, DescribeBrokerInstanceOptionsResponse> {
            serializer = DescribeBrokerInstanceOptionsOperationSerializer()
            deserializer = DescribeBrokerInstanceOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeBrokerInstanceOptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "mq"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the specified configuration.
     */
    override suspend fun describeConfiguration(input: DescribeConfigurationRequest): DescribeConfigurationResponse {
        val op = SdkHttpOperation.build<DescribeConfigurationRequest, DescribeConfigurationResponse> {
            serializer = DescribeConfigurationOperationSerializer()
            deserializer = DescribeConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "mq"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns the specified configuration revision for the specified configuration.
     */
    override suspend fun describeConfigurationRevision(input: DescribeConfigurationRevisionRequest): DescribeConfigurationRevisionResponse {
        val op = SdkHttpOperation.build<DescribeConfigurationRevisionRequest, DescribeConfigurationRevisionResponse> {
            serializer = DescribeConfigurationRevisionOperationSerializer()
            deserializer = DescribeConfigurationRevisionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeConfigurationRevision"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "mq"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about an ActiveMQ user.
     */
    override suspend fun describeUser(input: DescribeUserRequest): DescribeUserResponse {
        val op = SdkHttpOperation.build<DescribeUserRequest, DescribeUserResponse> {
            serializer = DescribeUserOperationSerializer()
            deserializer = DescribeUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "mq"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of all brokers.
     */
    override suspend fun listBrokers(input: ListBrokersRequest): ListBrokersResponse {
        val op = SdkHttpOperation.build<ListBrokersRequest, ListBrokersResponse> {
            serializer = ListBrokersOperationSerializer()
            deserializer = ListBrokersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListBrokers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "mq"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of all revisions for the specified configuration.
     */
    override suspend fun listConfigurationRevisions(input: ListConfigurationRevisionsRequest): ListConfigurationRevisionsResponse {
        val op = SdkHttpOperation.build<ListConfigurationRevisionsRequest, ListConfigurationRevisionsResponse> {
            serializer = ListConfigurationRevisionsOperationSerializer()
            deserializer = ListConfigurationRevisionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListConfigurationRevisions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "mq"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of all configurations.
     */
    override suspend fun listConfigurations(input: ListConfigurationsRequest): ListConfigurationsResponse {
        val op = SdkHttpOperation.build<ListConfigurationsRequest, ListConfigurationsResponse> {
            serializer = ListConfigurationsOperationSerializer()
            deserializer = ListConfigurationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListConfigurations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "mq"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Lists tags for a resource.
     */
    override suspend fun listTags(input: ListTagsRequest): ListTagsResponse {
        val op = SdkHttpOperation.build<ListTagsRequest, ListTagsResponse> {
            serializer = ListTagsOperationSerializer()
            deserializer = ListTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "mq"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of all ActiveMQ users.
     */
    override suspend fun listUsers(input: ListUsersRequest): ListUsersResponse {
        val op = SdkHttpOperation.build<ListUsersRequest, ListUsersResponse> {
            serializer = ListUsersOperationSerializer()
            deserializer = ListUsersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListUsers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "mq"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Reboots a broker. Note: This API is asynchronous.
     */
    override suspend fun rebootBroker(input: RebootBrokerRequest): RebootBrokerResponse {
        val op = SdkHttpOperation.build<RebootBrokerRequest, RebootBrokerResponse> {
            serializer = RebootBrokerOperationSerializer()
            deserializer = RebootBrokerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RebootBroker"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "mq"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Adds a pending configuration change to a broker.
     */
    override suspend fun updateBroker(input: UpdateBrokerRequest): UpdateBrokerResponse {
        val op = SdkHttpOperation.build<UpdateBrokerRequest, UpdateBrokerResponse> {
            serializer = UpdateBrokerOperationSerializer()
            deserializer = UpdateBrokerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateBroker"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "mq"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified configuration.
     */
    override suspend fun updateConfiguration(input: UpdateConfigurationRequest): UpdateConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateConfigurationRequest, UpdateConfigurationResponse> {
            serializer = UpdateConfigurationOperationSerializer()
            deserializer = UpdateConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "mq"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Updates the information for an ActiveMQ user.
     */
    override suspend fun updateUser(input: UpdateUserRequest): UpdateUserResponse {
        val op = SdkHttpOperation.build<UpdateUserRequest, UpdateUserResponse> {
            serializer = UpdateUserOperationSerializer()
            deserializer = UpdateUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "mq"
        }
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
