// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mq.serde

import aws.sdk.kotlin.services.mq.model.AuthenticationStrategy
import aws.sdk.kotlin.services.mq.model.ConfigurationId
import aws.sdk.kotlin.services.mq.model.DataReplicationMetadataOutput
import aws.sdk.kotlin.services.mq.model.DataReplicationMode
import aws.sdk.kotlin.services.mq.model.LdapServerMetadataOutput
import aws.sdk.kotlin.services.mq.model.Logs
import aws.sdk.kotlin.services.mq.model.MqException
import aws.sdk.kotlin.services.mq.model.UpdateBrokerResponse
import aws.sdk.kotlin.services.mq.model.WeeklyStartTime
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class UpdateBrokerOperationDeserializer: HttpDeserializer.NonStreaming<UpdateBrokerResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateBrokerResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateBrokerError(context, call, payload)
        }
        val builder = UpdateBrokerResponse.Builder()

        if (payload != null) {
            deserializeUpdateBrokerOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateBrokerError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MqException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> MqException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateBrokerOperationBody(builder: UpdateBrokerResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUTHENTICATIONSTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("authenticationStrategy"))
    val AUTOMINORVERSIONUPGRADE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("autoMinorVersionUpgrade"))
    val BROKERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("brokerId"))
    val CONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("configuration"))
    val DATAREPLICATIONMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("dataReplicationMetadata"))
    val DATAREPLICATIONMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("dataReplicationMode"))
    val ENGINEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("engineVersion"))
    val HOSTINSTANCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("hostInstanceType"))
    val LDAPSERVERMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ldapServerMetadata"))
    val LOGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("logs"))
    val MAINTENANCEWINDOWSTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("maintenanceWindowStartTime"))
    val PENDINGDATAREPLICATIONMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("pendingDataReplicationMetadata"))
    val PENDINGDATAREPLICATIONMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("pendingDataReplicationMode"))
    val SECURITYGROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("securityGroups"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTHENTICATIONSTRATEGY_DESCRIPTOR)
        field(AUTOMINORVERSIONUPGRADE_DESCRIPTOR)
        field(BROKERID_DESCRIPTOR)
        field(CONFIGURATION_DESCRIPTOR)
        field(DATAREPLICATIONMETADATA_DESCRIPTOR)
        field(DATAREPLICATIONMODE_DESCRIPTOR)
        field(ENGINEVERSION_DESCRIPTOR)
        field(HOSTINSTANCETYPE_DESCRIPTOR)
        field(LDAPSERVERMETADATA_DESCRIPTOR)
        field(LOGS_DESCRIPTOR)
        field(MAINTENANCEWINDOWSTARTTIME_DESCRIPTOR)
        field(PENDINGDATAREPLICATIONMETADATA_DESCRIPTOR)
        field(PENDINGDATAREPLICATIONMODE_DESCRIPTOR)
        field(SECURITYGROUPS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTHENTICATIONSTRATEGY_DESCRIPTOR.index -> builder.authenticationStrategy = deserializeString().let { AuthenticationStrategy.fromValue(it) }
                AUTOMINORVERSIONUPGRADE_DESCRIPTOR.index -> builder.autoMinorVersionUpgrade = deserializeBoolean()
                BROKERID_DESCRIPTOR.index -> builder.brokerId = deserializeString()
                CONFIGURATION_DESCRIPTOR.index -> builder.configuration = deserializeConfigurationIdDocument(deserializer)
                DATAREPLICATIONMETADATA_DESCRIPTOR.index -> builder.dataReplicationMetadata = deserializeDataReplicationMetadataOutputDocument(deserializer)
                DATAREPLICATIONMODE_DESCRIPTOR.index -> builder.dataReplicationMode = deserializeString().let { DataReplicationMode.fromValue(it) }
                ENGINEVERSION_DESCRIPTOR.index -> builder.engineVersion = deserializeString()
                HOSTINSTANCETYPE_DESCRIPTOR.index -> builder.hostInstanceType = deserializeString()
                LDAPSERVERMETADATA_DESCRIPTOR.index -> builder.ldapServerMetadata = deserializeLdapServerMetadataOutputDocument(deserializer)
                LOGS_DESCRIPTOR.index -> builder.logs = deserializeLogsDocument(deserializer)
                MAINTENANCEWINDOWSTARTTIME_DESCRIPTOR.index -> builder.maintenanceWindowStartTime = deserializeWeeklyStartTimeDocument(deserializer)
                PENDINGDATAREPLICATIONMETADATA_DESCRIPTOR.index -> builder.pendingDataReplicationMetadata = deserializeDataReplicationMetadataOutputDocument(deserializer)
                PENDINGDATAREPLICATIONMODE_DESCRIPTOR.index -> builder.pendingDataReplicationMode = deserializeString().let { DataReplicationMode.fromValue(it) }
                SECURITYGROUPS_DESCRIPTOR.index -> builder.securityGroups =
                    deserializer.deserializeList(SECURITYGROUPS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
