// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mq.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeBrokerResponse private constructor(builder: Builder) {
    /**
     * Actions required for a broker.
     */
    public val actionsRequired: List<ActionRequired>? = builder.actionsRequired
    /**
     * The authentication strategy used to secure the broker. The default is SIMPLE.
     */
    public val authenticationStrategy: aws.sdk.kotlin.services.mq.model.AuthenticationStrategy? = builder.authenticationStrategy
    /**
     * Enables automatic upgrades to new patch versions for brokers as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window or after a manual broker reboot.
     */
    public val autoMinorVersionUpgrade: kotlin.Boolean? = builder.autoMinorVersionUpgrade
    /**
     * The broker's Amazon Resource Name (ARN).
     */
    public val brokerArn: kotlin.String? = builder.brokerArn
    /**
     * The unique ID that Amazon MQ generates for the broker.
     */
    public val brokerId: kotlin.String? = builder.brokerId
    /**
     * A list of information about allocated brokers.
     */
    public val brokerInstances: List<BrokerInstance>? = builder.brokerInstances
    /**
     * The broker's name. This value must be unique in your Amazon Web Services account account, 1-50 characters long, must contain only letters, numbers, dashes, and underscores, and must not contain white spaces, brackets, wildcard characters, or special characters.
     */
    public val brokerName: kotlin.String? = builder.brokerName
    /**
     * The broker's status.
     */
    public val brokerState: aws.sdk.kotlin.services.mq.model.BrokerState? = builder.brokerState
    /**
     * The list of all revisions for the specified configuration.
     */
    public val configurations: aws.sdk.kotlin.services.mq.model.Configurations? = builder.configurations
    /**
     * The time when the broker was created.
     */
    public val created: aws.smithy.kotlin.runtime.time.Instant? = builder.created
    /**
     * The replication details of the data replication-enabled broker. Only returned if dataReplicationMode is set to CRDR.
     */
    public val dataReplicationMetadata: aws.sdk.kotlin.services.mq.model.DataReplicationMetadataOutput? = builder.dataReplicationMetadata
    /**
     * Describes whether this broker is a part of a data replication pair.
     */
    public val dataReplicationMode: aws.sdk.kotlin.services.mq.model.DataReplicationMode? = builder.dataReplicationMode
    /**
     * The broker's deployment mode.
     */
    public val deploymentMode: aws.sdk.kotlin.services.mq.model.DeploymentMode? = builder.deploymentMode
    /**
     * Encryption options for the broker.
     */
    public val encryptionOptions: aws.sdk.kotlin.services.mq.model.EncryptionOptions? = builder.encryptionOptions
    /**
     * The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.
     */
    public val engineType: aws.sdk.kotlin.services.mq.model.EngineType? = builder.engineType
    /**
     * The broker engine version. For more information, see the [ActiveMQ version management](https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/activemq-version-management.html) and the [RabbitMQ version management](https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/rabbitmq-version-management.html) sections in the Amazon MQ Developer Guide.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The broker's instance type.
     */
    public val hostInstanceType: kotlin.String? = builder.hostInstanceType
    /**
     * The metadata of the LDAP server used to authenticate and authorize connections to the broker.
     */
    public val ldapServerMetadata: aws.sdk.kotlin.services.mq.model.LdapServerMetadataOutput? = builder.ldapServerMetadata
    /**
     * The list of information about logs currently enabled and pending to be deployed for the specified broker.
     */
    public val logs: aws.sdk.kotlin.services.mq.model.LogsSummary? = builder.logs
    /**
     * The parameters that determine the WeeklyStartTime.
     */
    public val maintenanceWindowStartTime: aws.sdk.kotlin.services.mq.model.WeeklyStartTime? = builder.maintenanceWindowStartTime
    /**
     * The authentication strategy that will be applied when the broker is rebooted. The default is SIMPLE.
     */
    public val pendingAuthenticationStrategy: aws.sdk.kotlin.services.mq.model.AuthenticationStrategy? = builder.pendingAuthenticationStrategy
    /**
     * The pending replication details of the data replication-enabled broker. Only returned if pendingDataReplicationMode is set to CRDR.
     */
    public val pendingDataReplicationMetadata: aws.sdk.kotlin.services.mq.model.DataReplicationMetadataOutput? = builder.pendingDataReplicationMetadata
    /**
     * Describes whether this broker will be a part of a data replication pair after reboot.
     */
    public val pendingDataReplicationMode: aws.sdk.kotlin.services.mq.model.DataReplicationMode? = builder.pendingDataReplicationMode
    /**
     * The broker engine version to upgrade to. For more information, see the [ActiveMQ version management](https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/activemq-version-management.html) and the [RabbitMQ version management](https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/rabbitmq-version-management.html) sections in the Amazon MQ Developer Guide.
     */
    public val pendingEngineVersion: kotlin.String? = builder.pendingEngineVersion
    /**
     * The broker's host instance type to upgrade to. For a list of supported instance types, see [Broker instance types](https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types).
     */
    public val pendingHostInstanceType: kotlin.String? = builder.pendingHostInstanceType
    /**
     * The metadata of the LDAP server that will be used to authenticate and authorize connections to the broker after it is rebooted.
     */
    public val pendingLdapServerMetadata: aws.sdk.kotlin.services.mq.model.LdapServerMetadataOutput? = builder.pendingLdapServerMetadata
    /**
     * The list of pending security groups to authorize connections to brokers.
     */
    public val pendingSecurityGroups: List<String>? = builder.pendingSecurityGroups
    /**
     * Enables connections from applications outside of the VPC that hosts the broker's subnets.
     */
    public val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.
     */
    public val securityGroups: List<String>? = builder.securityGroups
    /**
     * The broker's storage type.
     */
    public val storageType: aws.sdk.kotlin.services.mq.model.BrokerStorageType? = builder.storageType
    /**
     * The list of groups that define which subnets and IP ranges the broker can use from different Availability Zones.
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * The list of all tags associated with this broker.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The list of all broker usernames for the specified broker.
     */
    public val users: List<UserSummary>? = builder.users

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mq.model.DescribeBrokerResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeBrokerResponse(")
        append("actionsRequired=$actionsRequired,")
        append("authenticationStrategy=$authenticationStrategy,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("brokerArn=$brokerArn,")
        append("brokerId=$brokerId,")
        append("brokerInstances=$brokerInstances,")
        append("brokerName=$brokerName,")
        append("brokerState=$brokerState,")
        append("configurations=$configurations,")
        append("created=$created,")
        append("dataReplicationMetadata=$dataReplicationMetadata,")
        append("dataReplicationMode=$dataReplicationMode,")
        append("deploymentMode=$deploymentMode,")
        append("encryptionOptions=$encryptionOptions,")
        append("engineType=$engineType,")
        append("engineVersion=$engineVersion,")
        append("hostInstanceType=$hostInstanceType,")
        append("ldapServerMetadata=$ldapServerMetadata,")
        append("logs=$logs,")
        append("maintenanceWindowStartTime=$maintenanceWindowStartTime,")
        append("pendingAuthenticationStrategy=$pendingAuthenticationStrategy,")
        append("pendingDataReplicationMetadata=$pendingDataReplicationMetadata,")
        append("pendingDataReplicationMode=$pendingDataReplicationMode,")
        append("pendingEngineVersion=$pendingEngineVersion,")
        append("pendingHostInstanceType=$pendingHostInstanceType,")
        append("pendingLdapServerMetadata=$pendingLdapServerMetadata,")
        append("pendingSecurityGroups=$pendingSecurityGroups,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("securityGroups=$securityGroups,")
        append("storageType=$storageType,")
        append("subnetIds=$subnetIds,")
        append("tags=$tags,")
        append("users=$users")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionsRequired?.hashCode() ?: 0
        result = 31 * result + (authenticationStrategy?.hashCode() ?: 0)
        result = 31 * result + (autoMinorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (brokerArn?.hashCode() ?: 0)
        result = 31 * result + (brokerId?.hashCode() ?: 0)
        result = 31 * result + (brokerInstances?.hashCode() ?: 0)
        result = 31 * result + (brokerName?.hashCode() ?: 0)
        result = 31 * result + (brokerState?.hashCode() ?: 0)
        result = 31 * result + (configurations?.hashCode() ?: 0)
        result = 31 * result + (created?.hashCode() ?: 0)
        result = 31 * result + (dataReplicationMetadata?.hashCode() ?: 0)
        result = 31 * result + (dataReplicationMode?.hashCode() ?: 0)
        result = 31 * result + (deploymentMode?.hashCode() ?: 0)
        result = 31 * result + (encryptionOptions?.hashCode() ?: 0)
        result = 31 * result + (engineType?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (hostInstanceType?.hashCode() ?: 0)
        result = 31 * result + (ldapServerMetadata?.hashCode() ?: 0)
        result = 31 * result + (logs?.hashCode() ?: 0)
        result = 31 * result + (maintenanceWindowStartTime?.hashCode() ?: 0)
        result = 31 * result + (pendingAuthenticationStrategy?.hashCode() ?: 0)
        result = 31 * result + (pendingDataReplicationMetadata?.hashCode() ?: 0)
        result = 31 * result + (pendingDataReplicationMode?.hashCode() ?: 0)
        result = 31 * result + (pendingEngineVersion?.hashCode() ?: 0)
        result = 31 * result + (pendingHostInstanceType?.hashCode() ?: 0)
        result = 31 * result + (pendingLdapServerMetadata?.hashCode() ?: 0)
        result = 31 * result + (pendingSecurityGroups?.hashCode() ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (users?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeBrokerResponse

        if (actionsRequired != other.actionsRequired) return false
        if (authenticationStrategy != other.authenticationStrategy) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (brokerArn != other.brokerArn) return false
        if (brokerId != other.brokerId) return false
        if (brokerInstances != other.brokerInstances) return false
        if (brokerName != other.brokerName) return false
        if (brokerState != other.brokerState) return false
        if (configurations != other.configurations) return false
        if (created != other.created) return false
        if (dataReplicationMetadata != other.dataReplicationMetadata) return false
        if (dataReplicationMode != other.dataReplicationMode) return false
        if (deploymentMode != other.deploymentMode) return false
        if (encryptionOptions != other.encryptionOptions) return false
        if (engineType != other.engineType) return false
        if (engineVersion != other.engineVersion) return false
        if (hostInstanceType != other.hostInstanceType) return false
        if (ldapServerMetadata != other.ldapServerMetadata) return false
        if (logs != other.logs) return false
        if (maintenanceWindowStartTime != other.maintenanceWindowStartTime) return false
        if (pendingAuthenticationStrategy != other.pendingAuthenticationStrategy) return false
        if (pendingDataReplicationMetadata != other.pendingDataReplicationMetadata) return false
        if (pendingDataReplicationMode != other.pendingDataReplicationMode) return false
        if (pendingEngineVersion != other.pendingEngineVersion) return false
        if (pendingHostInstanceType != other.pendingHostInstanceType) return false
        if (pendingLdapServerMetadata != other.pendingLdapServerMetadata) return false
        if (pendingSecurityGroups != other.pendingSecurityGroups) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (securityGroups != other.securityGroups) return false
        if (storageType != other.storageType) return false
        if (subnetIds != other.subnetIds) return false
        if (tags != other.tags) return false
        if (users != other.users) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mq.model.DescribeBrokerResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Actions required for a broker.
         */
        public var actionsRequired: List<ActionRequired>? = null
        /**
         * The authentication strategy used to secure the broker. The default is SIMPLE.
         */
        public var authenticationStrategy: aws.sdk.kotlin.services.mq.model.AuthenticationStrategy? = null
        /**
         * Enables automatic upgrades to new patch versions for brokers as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window or after a manual broker reboot.
         */
        public var autoMinorVersionUpgrade: kotlin.Boolean? = null
        /**
         * The broker's Amazon Resource Name (ARN).
         */
        public var brokerArn: kotlin.String? = null
        /**
         * The unique ID that Amazon MQ generates for the broker.
         */
        public var brokerId: kotlin.String? = null
        /**
         * A list of information about allocated brokers.
         */
        public var brokerInstances: List<BrokerInstance>? = null
        /**
         * The broker's name. This value must be unique in your Amazon Web Services account account, 1-50 characters long, must contain only letters, numbers, dashes, and underscores, and must not contain white spaces, brackets, wildcard characters, or special characters.
         */
        public var brokerName: kotlin.String? = null
        /**
         * The broker's status.
         */
        public var brokerState: aws.sdk.kotlin.services.mq.model.BrokerState? = null
        /**
         * The list of all revisions for the specified configuration.
         */
        public var configurations: aws.sdk.kotlin.services.mq.model.Configurations? = null
        /**
         * The time when the broker was created.
         */
        public var created: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The replication details of the data replication-enabled broker. Only returned if dataReplicationMode is set to CRDR.
         */
        public var dataReplicationMetadata: aws.sdk.kotlin.services.mq.model.DataReplicationMetadataOutput? = null
        /**
         * Describes whether this broker is a part of a data replication pair.
         */
        public var dataReplicationMode: aws.sdk.kotlin.services.mq.model.DataReplicationMode? = null
        /**
         * The broker's deployment mode.
         */
        public var deploymentMode: aws.sdk.kotlin.services.mq.model.DeploymentMode? = null
        /**
         * Encryption options for the broker.
         */
        public var encryptionOptions: aws.sdk.kotlin.services.mq.model.EncryptionOptions? = null
        /**
         * The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.
         */
        public var engineType: aws.sdk.kotlin.services.mq.model.EngineType? = null
        /**
         * The broker engine version. For more information, see the [ActiveMQ version management](https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/activemq-version-management.html) and the [RabbitMQ version management](https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/rabbitmq-version-management.html) sections in the Amazon MQ Developer Guide.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The broker's instance type.
         */
        public var hostInstanceType: kotlin.String? = null
        /**
         * The metadata of the LDAP server used to authenticate and authorize connections to the broker.
         */
        public var ldapServerMetadata: aws.sdk.kotlin.services.mq.model.LdapServerMetadataOutput? = null
        /**
         * The list of information about logs currently enabled and pending to be deployed for the specified broker.
         */
        public var logs: aws.sdk.kotlin.services.mq.model.LogsSummary? = null
        /**
         * The parameters that determine the WeeklyStartTime.
         */
        public var maintenanceWindowStartTime: aws.sdk.kotlin.services.mq.model.WeeklyStartTime? = null
        /**
         * The authentication strategy that will be applied when the broker is rebooted. The default is SIMPLE.
         */
        public var pendingAuthenticationStrategy: aws.sdk.kotlin.services.mq.model.AuthenticationStrategy? = null
        /**
         * The pending replication details of the data replication-enabled broker. Only returned if pendingDataReplicationMode is set to CRDR.
         */
        public var pendingDataReplicationMetadata: aws.sdk.kotlin.services.mq.model.DataReplicationMetadataOutput? = null
        /**
         * Describes whether this broker will be a part of a data replication pair after reboot.
         */
        public var pendingDataReplicationMode: aws.sdk.kotlin.services.mq.model.DataReplicationMode? = null
        /**
         * The broker engine version to upgrade to. For more information, see the [ActiveMQ version management](https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/activemq-version-management.html) and the [RabbitMQ version management](https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/rabbitmq-version-management.html) sections in the Amazon MQ Developer Guide.
         */
        public var pendingEngineVersion: kotlin.String? = null
        /**
         * The broker's host instance type to upgrade to. For a list of supported instance types, see [Broker instance types](https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types).
         */
        public var pendingHostInstanceType: kotlin.String? = null
        /**
         * The metadata of the LDAP server that will be used to authenticate and authorize connections to the broker after it is rebooted.
         */
        public var pendingLdapServerMetadata: aws.sdk.kotlin.services.mq.model.LdapServerMetadataOutput? = null
        /**
         * The list of pending security groups to authorize connections to brokers.
         */
        public var pendingSecurityGroups: List<String>? = null
        /**
         * Enables connections from applications outside of the VPC that hosts the broker's subnets.
         */
        public var publiclyAccessible: kotlin.Boolean? = null
        /**
         * The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.
         */
        public var securityGroups: List<String>? = null
        /**
         * The broker's storage type.
         */
        public var storageType: aws.sdk.kotlin.services.mq.model.BrokerStorageType? = null
        /**
         * The list of groups that define which subnets and IP ranges the broker can use from different Availability Zones.
         */
        public var subnetIds: List<String>? = null
        /**
         * The list of all tags associated with this broker.
         */
        public var tags: Map<String, String>? = null
        /**
         * The list of all broker usernames for the specified broker.
         */
        public var users: List<UserSummary>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mq.model.DescribeBrokerResponse) : this() {
            this.actionsRequired = x.actionsRequired
            this.authenticationStrategy = x.authenticationStrategy
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.brokerArn = x.brokerArn
            this.brokerId = x.brokerId
            this.brokerInstances = x.brokerInstances
            this.brokerName = x.brokerName
            this.brokerState = x.brokerState
            this.configurations = x.configurations
            this.created = x.created
            this.dataReplicationMetadata = x.dataReplicationMetadata
            this.dataReplicationMode = x.dataReplicationMode
            this.deploymentMode = x.deploymentMode
            this.encryptionOptions = x.encryptionOptions
            this.engineType = x.engineType
            this.engineVersion = x.engineVersion
            this.hostInstanceType = x.hostInstanceType
            this.ldapServerMetadata = x.ldapServerMetadata
            this.logs = x.logs
            this.maintenanceWindowStartTime = x.maintenanceWindowStartTime
            this.pendingAuthenticationStrategy = x.pendingAuthenticationStrategy
            this.pendingDataReplicationMetadata = x.pendingDataReplicationMetadata
            this.pendingDataReplicationMode = x.pendingDataReplicationMode
            this.pendingEngineVersion = x.pendingEngineVersion
            this.pendingHostInstanceType = x.pendingHostInstanceType
            this.pendingLdapServerMetadata = x.pendingLdapServerMetadata
            this.pendingSecurityGroups = x.pendingSecurityGroups
            this.publiclyAccessible = x.publiclyAccessible
            this.securityGroups = x.securityGroups
            this.storageType = x.storageType
            this.subnetIds = x.subnetIds
            this.tags = x.tags
            this.users = x.users
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mq.model.DescribeBrokerResponse = DescribeBrokerResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.Configurations] inside the given [block]
         */
        public fun configurations(block: aws.sdk.kotlin.services.mq.model.Configurations.Builder.() -> kotlin.Unit) {
            this.configurations = aws.sdk.kotlin.services.mq.model.Configurations.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.DataReplicationMetadataOutput] inside the given [block]
         */
        public fun dataReplicationMetadata(block: aws.sdk.kotlin.services.mq.model.DataReplicationMetadataOutput.Builder.() -> kotlin.Unit) {
            this.dataReplicationMetadata = aws.sdk.kotlin.services.mq.model.DataReplicationMetadataOutput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.EncryptionOptions] inside the given [block]
         */
        public fun encryptionOptions(block: aws.sdk.kotlin.services.mq.model.EncryptionOptions.Builder.() -> kotlin.Unit) {
            this.encryptionOptions = aws.sdk.kotlin.services.mq.model.EncryptionOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.LdapServerMetadataOutput] inside the given [block]
         */
        public fun ldapServerMetadata(block: aws.sdk.kotlin.services.mq.model.LdapServerMetadataOutput.Builder.() -> kotlin.Unit) {
            this.ldapServerMetadata = aws.sdk.kotlin.services.mq.model.LdapServerMetadataOutput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.LogsSummary] inside the given [block]
         */
        public fun logs(block: aws.sdk.kotlin.services.mq.model.LogsSummary.Builder.() -> kotlin.Unit) {
            this.logs = aws.sdk.kotlin.services.mq.model.LogsSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.WeeklyStartTime] inside the given [block]
         */
        public fun maintenanceWindowStartTime(block: aws.sdk.kotlin.services.mq.model.WeeklyStartTime.Builder.() -> kotlin.Unit) {
            this.maintenanceWindowStartTime = aws.sdk.kotlin.services.mq.model.WeeklyStartTime.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.DataReplicationMetadataOutput] inside the given [block]
         */
        public fun pendingDataReplicationMetadata(block: aws.sdk.kotlin.services.mq.model.DataReplicationMetadataOutput.Builder.() -> kotlin.Unit) {
            this.pendingDataReplicationMetadata = aws.sdk.kotlin.services.mq.model.DataReplicationMetadataOutput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.LdapServerMetadataOutput] inside the given [block]
         */
        public fun pendingLdapServerMetadata(block: aws.sdk.kotlin.services.mq.model.LdapServerMetadataOutput.Builder.() -> kotlin.Unit) {
            this.pendingLdapServerMetadata = aws.sdk.kotlin.services.mq.model.LdapServerMetadataOutput.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
