// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mq.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Creates a broker using the specified properties.
 */
public class CreateBrokerRequest private constructor(builder: Builder) {
    /**
     * Optional. The authentication strategy used to secure the broker. The default is SIMPLE.
     */
    public val authenticationStrategy: aws.sdk.kotlin.services.mq.model.AuthenticationStrategy? = builder.authenticationStrategy
    /**
     * Enables automatic upgrades to new patch versions for brokers as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window or after a manual broker reboot. Set to true by default, if no value is specified.
     *
     * Must be set to true for ActiveMQ brokers version 5.18 and above and for RabbitMQ brokers version 3.13 and above.
     */
    public val autoMinorVersionUpgrade: kotlin.Boolean? = builder.autoMinorVersionUpgrade
    /**
     * Required. The broker's name. This value must be unique in your Amazon Web Services account, 1-50 characters long, must contain only letters, numbers, dashes, and underscores, and must not contain white spaces, brackets, wildcard characters, or special characters.
     *
     * Do not add personally identifiable information (PII) or other confidential or sensitive information in broker names. Broker names are accessible to other Amazon Web Services services, including CloudWatch Logs. Broker names are not intended to be used for private or sensitive data.
     */
    public val brokerName: kotlin.String? = builder.brokerName
    /**
     * A list of information about the configuration.
     */
    public val configuration: aws.sdk.kotlin.services.mq.model.ConfigurationId? = builder.configuration
    /**
     * The unique ID that the requester receives for the created broker. Amazon MQ passes your ID with the API action.
     *
     * We recommend using a Universally Unique Identifier (UUID) for the creatorRequestId. You may omit the creatorRequestId if your application doesn't require idempotency.
     */
    public val creatorRequestId: kotlin.String? = builder.creatorRequestId
    /**
     * Defines whether this broker is a part of a data replication pair.
     */
    public val dataReplicationMode: aws.sdk.kotlin.services.mq.model.DataReplicationMode? = builder.dataReplicationMode
    /**
     * The Amazon Resource Name (ARN) of the primary broker that is used to replicate data from in a data replication pair, and is applied to the replica broker. Must be set when dataReplicationMode is set to CRDR.
     */
    public val dataReplicationPrimaryBrokerArn: kotlin.String? = builder.dataReplicationPrimaryBrokerArn
    /**
     * Required. The broker's deployment mode.
     */
    public val deploymentMode: aws.sdk.kotlin.services.mq.model.DeploymentMode? = builder.deploymentMode
    /**
     * Encryption options for the broker.
     */
    public val encryptionOptions: aws.sdk.kotlin.services.mq.model.EncryptionOptions? = builder.encryptionOptions
    /**
     * Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.
     */
    public val engineType: aws.sdk.kotlin.services.mq.model.EngineType? = builder.engineType
    /**
     * The broker engine version. Defaults to the latest available version for the specified broker engine type. For more information, see the [ActiveMQ version management](https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/activemq-version-management.html) and the [RabbitMQ version management](https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/rabbitmq-version-management.html) sections in the Amazon MQ Developer Guide.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * Required. The broker's instance type.
     */
    public val hostInstanceType: kotlin.String? = builder.hostInstanceType
    /**
     * Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.
     */
    public val ldapServerMetadata: aws.sdk.kotlin.services.mq.model.LdapServerMetadataInput? = builder.ldapServerMetadata
    /**
     * Enables Amazon CloudWatch logging for brokers.
     */
    public val logs: aws.sdk.kotlin.services.mq.model.Logs? = builder.logs
    /**
     * The parameters that determine the WeeklyStartTime.
     */
    public val maintenanceWindowStartTime: aws.sdk.kotlin.services.mq.model.WeeklyStartTime? = builder.maintenanceWindowStartTime
    /**
     * Enables connections from applications outside of the VPC that hosts the broker's subnets. Set to false by default, if no value is provided.
     */
    public val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.
     */
    public val securityGroups: List<String>? = builder.securityGroups
    /**
     * The broker's storage type.
     */
    public val storageType: aws.sdk.kotlin.services.mq.model.BrokerStorageType? = builder.storageType
    /**
     * The list of groups that define which subnets and IP ranges the broker can use from different Availability Zones. If you specify more than one subnet, the subnets must be in different Availability Zones. Amazon MQ will not be able to create VPC endpoints for your broker with multiple subnets in the same Availability Zone. A SINGLE_INSTANCE deployment requires one subnet (for example, the default subnet). An ACTIVE_STANDBY_MULTI_AZ Amazon MQ for ActiveMQ deployment requires two subnets. A CLUSTER_MULTI_AZ Amazon MQ for RabbitMQ deployment has no subnet requirements when deployed with public accessibility. Deployment without public accessibility requires at least one subnet.
     *
     * If you specify subnets in a [shared VPC](https://docs.aws.amazon.com/vpc/latest/userguide/vpc-sharing.html) for a RabbitMQ broker, the associated VPC to which the specified subnets belong must be owned by your Amazon Web Services account. Amazon MQ will not be able to create VPC endpoints in VPCs that are not owned by your Amazon Web Services account.
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * Create tags when creating the broker.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The list of broker users (persons or applications) who can access queues and topics. For Amazon MQ for RabbitMQ brokers, one and only one administrative user is accepted and created when a broker is first provisioned. All subsequent broker users are created by making RabbitMQ API calls directly to brokers or via the RabbitMQ web console.
     */
    public val users: List<User>? = builder.users

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mq.model.CreateBrokerRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateBrokerRequest(")
        append("authenticationStrategy=$authenticationStrategy,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("brokerName=$brokerName,")
        append("configuration=$configuration,")
        append("creatorRequestId=$creatorRequestId,")
        append("dataReplicationMode=$dataReplicationMode,")
        append("dataReplicationPrimaryBrokerArn=$dataReplicationPrimaryBrokerArn,")
        append("deploymentMode=$deploymentMode,")
        append("encryptionOptions=$encryptionOptions,")
        append("engineType=$engineType,")
        append("engineVersion=$engineVersion,")
        append("hostInstanceType=$hostInstanceType,")
        append("ldapServerMetadata=$ldapServerMetadata,")
        append("logs=$logs,")
        append("maintenanceWindowStartTime=$maintenanceWindowStartTime,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("securityGroups=$securityGroups,")
        append("storageType=$storageType,")
        append("subnetIds=$subnetIds,")
        append("tags=$tags,")
        append("users=$users")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationStrategy?.hashCode() ?: 0
        result = 31 * result + (autoMinorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (brokerName?.hashCode() ?: 0)
        result = 31 * result + (configuration?.hashCode() ?: 0)
        result = 31 * result + (creatorRequestId?.hashCode() ?: 0)
        result = 31 * result + (dataReplicationMode?.hashCode() ?: 0)
        result = 31 * result + (dataReplicationPrimaryBrokerArn?.hashCode() ?: 0)
        result = 31 * result + (deploymentMode?.hashCode() ?: 0)
        result = 31 * result + (encryptionOptions?.hashCode() ?: 0)
        result = 31 * result + (engineType?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (hostInstanceType?.hashCode() ?: 0)
        result = 31 * result + (ldapServerMetadata?.hashCode() ?: 0)
        result = 31 * result + (logs?.hashCode() ?: 0)
        result = 31 * result + (maintenanceWindowStartTime?.hashCode() ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (users?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateBrokerRequest

        if (authenticationStrategy != other.authenticationStrategy) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (brokerName != other.brokerName) return false
        if (configuration != other.configuration) return false
        if (creatorRequestId != other.creatorRequestId) return false
        if (dataReplicationMode != other.dataReplicationMode) return false
        if (dataReplicationPrimaryBrokerArn != other.dataReplicationPrimaryBrokerArn) return false
        if (deploymentMode != other.deploymentMode) return false
        if (encryptionOptions != other.encryptionOptions) return false
        if (engineType != other.engineType) return false
        if (engineVersion != other.engineVersion) return false
        if (hostInstanceType != other.hostInstanceType) return false
        if (ldapServerMetadata != other.ldapServerMetadata) return false
        if (logs != other.logs) return false
        if (maintenanceWindowStartTime != other.maintenanceWindowStartTime) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (securityGroups != other.securityGroups) return false
        if (storageType != other.storageType) return false
        if (subnetIds != other.subnetIds) return false
        if (tags != other.tags) return false
        if (users != other.users) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mq.model.CreateBrokerRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Optional. The authentication strategy used to secure the broker. The default is SIMPLE.
         */
        public var authenticationStrategy: aws.sdk.kotlin.services.mq.model.AuthenticationStrategy? = null
        /**
         * Enables automatic upgrades to new patch versions for brokers as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window or after a manual broker reboot. Set to true by default, if no value is specified.
         *
         * Must be set to true for ActiveMQ brokers version 5.18 and above and for RabbitMQ brokers version 3.13 and above.
         */
        public var autoMinorVersionUpgrade: kotlin.Boolean? = null
        /**
         * Required. The broker's name. This value must be unique in your Amazon Web Services account, 1-50 characters long, must contain only letters, numbers, dashes, and underscores, and must not contain white spaces, brackets, wildcard characters, or special characters.
         *
         * Do not add personally identifiable information (PII) or other confidential or sensitive information in broker names. Broker names are accessible to other Amazon Web Services services, including CloudWatch Logs. Broker names are not intended to be used for private or sensitive data.
         */
        public var brokerName: kotlin.String? = null
        /**
         * A list of information about the configuration.
         */
        public var configuration: aws.sdk.kotlin.services.mq.model.ConfigurationId? = null
        /**
         * The unique ID that the requester receives for the created broker. Amazon MQ passes your ID with the API action.
         *
         * We recommend using a Universally Unique Identifier (UUID) for the creatorRequestId. You may omit the creatorRequestId if your application doesn't require idempotency.
         */
        public var creatorRequestId: kotlin.String? = null
        /**
         * Defines whether this broker is a part of a data replication pair.
         */
        public var dataReplicationMode: aws.sdk.kotlin.services.mq.model.DataReplicationMode? = null
        /**
         * The Amazon Resource Name (ARN) of the primary broker that is used to replicate data from in a data replication pair, and is applied to the replica broker. Must be set when dataReplicationMode is set to CRDR.
         */
        public var dataReplicationPrimaryBrokerArn: kotlin.String? = null
        /**
         * Required. The broker's deployment mode.
         */
        public var deploymentMode: aws.sdk.kotlin.services.mq.model.DeploymentMode? = null
        /**
         * Encryption options for the broker.
         */
        public var encryptionOptions: aws.sdk.kotlin.services.mq.model.EncryptionOptions? = null
        /**
         * Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.
         */
        public var engineType: aws.sdk.kotlin.services.mq.model.EngineType? = null
        /**
         * The broker engine version. Defaults to the latest available version for the specified broker engine type. For more information, see the [ActiveMQ version management](https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/activemq-version-management.html) and the [RabbitMQ version management](https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/rabbitmq-version-management.html) sections in the Amazon MQ Developer Guide.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * Required. The broker's instance type.
         */
        public var hostInstanceType: kotlin.String? = null
        /**
         * Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.
         */
        public var ldapServerMetadata: aws.sdk.kotlin.services.mq.model.LdapServerMetadataInput? = null
        /**
         * Enables Amazon CloudWatch logging for brokers.
         */
        public var logs: aws.sdk.kotlin.services.mq.model.Logs? = null
        /**
         * The parameters that determine the WeeklyStartTime.
         */
        public var maintenanceWindowStartTime: aws.sdk.kotlin.services.mq.model.WeeklyStartTime? = null
        /**
         * Enables connections from applications outside of the VPC that hosts the broker's subnets. Set to false by default, if no value is provided.
         */
        public var publiclyAccessible: kotlin.Boolean? = null
        /**
         * The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.
         */
        public var securityGroups: List<String>? = null
        /**
         * The broker's storage type.
         */
        public var storageType: aws.sdk.kotlin.services.mq.model.BrokerStorageType? = null
        /**
         * The list of groups that define which subnets and IP ranges the broker can use from different Availability Zones. If you specify more than one subnet, the subnets must be in different Availability Zones. Amazon MQ will not be able to create VPC endpoints for your broker with multiple subnets in the same Availability Zone. A SINGLE_INSTANCE deployment requires one subnet (for example, the default subnet). An ACTIVE_STANDBY_MULTI_AZ Amazon MQ for ActiveMQ deployment requires two subnets. A CLUSTER_MULTI_AZ Amazon MQ for RabbitMQ deployment has no subnet requirements when deployed with public accessibility. Deployment without public accessibility requires at least one subnet.
         *
         * If you specify subnets in a [shared VPC](https://docs.aws.amazon.com/vpc/latest/userguide/vpc-sharing.html) for a RabbitMQ broker, the associated VPC to which the specified subnets belong must be owned by your Amazon Web Services account. Amazon MQ will not be able to create VPC endpoints in VPCs that are not owned by your Amazon Web Services account.
         */
        public var subnetIds: List<String>? = null
        /**
         * Create tags when creating the broker.
         */
        public var tags: Map<String, String>? = null
        /**
         * The list of broker users (persons or applications) who can access queues and topics. For Amazon MQ for RabbitMQ brokers, one and only one administrative user is accepted and created when a broker is first provisioned. All subsequent broker users are created by making RabbitMQ API calls directly to brokers or via the RabbitMQ web console.
         */
        public var users: List<User>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mq.model.CreateBrokerRequest) : this() {
            this.authenticationStrategy = x.authenticationStrategy
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.brokerName = x.brokerName
            this.configuration = x.configuration
            this.creatorRequestId = x.creatorRequestId
            this.dataReplicationMode = x.dataReplicationMode
            this.dataReplicationPrimaryBrokerArn = x.dataReplicationPrimaryBrokerArn
            this.deploymentMode = x.deploymentMode
            this.encryptionOptions = x.encryptionOptions
            this.engineType = x.engineType
            this.engineVersion = x.engineVersion
            this.hostInstanceType = x.hostInstanceType
            this.ldapServerMetadata = x.ldapServerMetadata
            this.logs = x.logs
            this.maintenanceWindowStartTime = x.maintenanceWindowStartTime
            this.publiclyAccessible = x.publiclyAccessible
            this.securityGroups = x.securityGroups
            this.storageType = x.storageType
            this.subnetIds = x.subnetIds
            this.tags = x.tags
            this.users = x.users
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mq.model.CreateBrokerRequest = CreateBrokerRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.ConfigurationId] inside the given [block]
         */
        public fun configuration(block: aws.sdk.kotlin.services.mq.model.ConfigurationId.Builder.() -> kotlin.Unit) {
            this.configuration = aws.sdk.kotlin.services.mq.model.ConfigurationId.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.EncryptionOptions] inside the given [block]
         */
        public fun encryptionOptions(block: aws.sdk.kotlin.services.mq.model.EncryptionOptions.Builder.() -> kotlin.Unit) {
            this.encryptionOptions = aws.sdk.kotlin.services.mq.model.EncryptionOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.LdapServerMetadataInput] inside the given [block]
         */
        public fun ldapServerMetadata(block: aws.sdk.kotlin.services.mq.model.LdapServerMetadataInput.Builder.() -> kotlin.Unit) {
            this.ldapServerMetadata = aws.sdk.kotlin.services.mq.model.LdapServerMetadataInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.Logs] inside the given [block]
         */
        public fun logs(block: aws.sdk.kotlin.services.mq.model.Logs.Builder.() -> kotlin.Unit) {
            this.logs = aws.sdk.kotlin.services.mq.model.Logs.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.WeeklyStartTime] inside the given [block]
         */
        public fun maintenanceWindowStartTime(block: aws.sdk.kotlin.services.mq.model.WeeklyStartTime.Builder.() -> kotlin.Unit) {
            this.maintenanceWindowStartTime = aws.sdk.kotlin.services.mq.model.WeeklyStartTime.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
