// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mq.serde

import aws.sdk.kotlin.services.mq.model.DescribeUserResponse
import aws.sdk.kotlin.services.mq.model.MqException
import aws.sdk.kotlin.services.mq.model.UserPendingChanges
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeUserOperationDeserializer: HttpDeserializer.NonStreaming<DescribeUserResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeUserResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeUserError(context, call, payload)
        }
        val builder = DescribeUserResponse.Builder()

        if (payload != null) {
            deserializeDescribeUserOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeUserError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MqException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> MqException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeUserOperationBody(builder: DescribeUserResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BROKERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("brokerId"))
    val CONSOLEACCESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("consoleAccess"))
    val GROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("groups"))
    val PENDING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("pending"))
    val REPLICATIONUSER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("replicationUser"))
    val USERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("username"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BROKERID_DESCRIPTOR)
        field(CONSOLEACCESS_DESCRIPTOR)
        field(GROUPS_DESCRIPTOR)
        field(PENDING_DESCRIPTOR)
        field(REPLICATIONUSER_DESCRIPTOR)
        field(USERNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BROKERID_DESCRIPTOR.index -> builder.brokerId = deserializeString()
                CONSOLEACCESS_DESCRIPTOR.index -> builder.consoleAccess = deserializeBoolean()
                GROUPS_DESCRIPTOR.index -> builder.groups =
                    deserializer.deserializeList(GROUPS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PENDING_DESCRIPTOR.index -> builder.pending = deserializeUserPendingChangesDocument(deserializer)
                REPLICATIONUSER_DESCRIPTOR.index -> builder.replicationUser = deserializeBoolean()
                USERNAME_DESCRIPTOR.index -> builder.username = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
