// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mq

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.mq.auth.DefaultMqAuthSchemeProvider
import aws.sdk.kotlin.services.mq.auth.MqAuthSchemeProvider
import aws.sdk.kotlin.services.mq.endpoints.DefaultMqEndpointProvider
import aws.sdk.kotlin.services.mq.endpoints.MqEndpointParameters
import aws.sdk.kotlin.services.mq.endpoints.MqEndpointProvider
import aws.sdk.kotlin.services.mq.model.CreateBrokerRequest
import aws.sdk.kotlin.services.mq.model.CreateBrokerResponse
import aws.sdk.kotlin.services.mq.model.CreateConfigurationRequest
import aws.sdk.kotlin.services.mq.model.CreateConfigurationResponse
import aws.sdk.kotlin.services.mq.model.CreateTagsRequest
import aws.sdk.kotlin.services.mq.model.CreateTagsResponse
import aws.sdk.kotlin.services.mq.model.CreateUserRequest
import aws.sdk.kotlin.services.mq.model.CreateUserResponse
import aws.sdk.kotlin.services.mq.model.DeleteBrokerRequest
import aws.sdk.kotlin.services.mq.model.DeleteBrokerResponse
import aws.sdk.kotlin.services.mq.model.DeleteTagsRequest
import aws.sdk.kotlin.services.mq.model.DeleteTagsResponse
import aws.sdk.kotlin.services.mq.model.DeleteUserRequest
import aws.sdk.kotlin.services.mq.model.DeleteUserResponse
import aws.sdk.kotlin.services.mq.model.DescribeBrokerEngineTypesRequest
import aws.sdk.kotlin.services.mq.model.DescribeBrokerEngineTypesResponse
import aws.sdk.kotlin.services.mq.model.DescribeBrokerInstanceOptionsRequest
import aws.sdk.kotlin.services.mq.model.DescribeBrokerInstanceOptionsResponse
import aws.sdk.kotlin.services.mq.model.DescribeBrokerRequest
import aws.sdk.kotlin.services.mq.model.DescribeBrokerResponse
import aws.sdk.kotlin.services.mq.model.DescribeConfigurationRequest
import aws.sdk.kotlin.services.mq.model.DescribeConfigurationResponse
import aws.sdk.kotlin.services.mq.model.DescribeConfigurationRevisionRequest
import aws.sdk.kotlin.services.mq.model.DescribeConfigurationRevisionResponse
import aws.sdk.kotlin.services.mq.model.DescribeUserRequest
import aws.sdk.kotlin.services.mq.model.DescribeUserResponse
import aws.sdk.kotlin.services.mq.model.ListBrokersRequest
import aws.sdk.kotlin.services.mq.model.ListBrokersResponse
import aws.sdk.kotlin.services.mq.model.ListConfigurationRevisionsRequest
import aws.sdk.kotlin.services.mq.model.ListConfigurationRevisionsResponse
import aws.sdk.kotlin.services.mq.model.ListConfigurationsRequest
import aws.sdk.kotlin.services.mq.model.ListConfigurationsResponse
import aws.sdk.kotlin.services.mq.model.ListTagsRequest
import aws.sdk.kotlin.services.mq.model.ListTagsResponse
import aws.sdk.kotlin.services.mq.model.ListUsersRequest
import aws.sdk.kotlin.services.mq.model.ListUsersResponse
import aws.sdk.kotlin.services.mq.model.PromoteRequest
import aws.sdk.kotlin.services.mq.model.PromoteResponse
import aws.sdk.kotlin.services.mq.model.RebootBrokerRequest
import aws.sdk.kotlin.services.mq.model.RebootBrokerResponse
import aws.sdk.kotlin.services.mq.model.UpdateBrokerRequest
import aws.sdk.kotlin.services.mq.model.UpdateBrokerResponse
import aws.sdk.kotlin.services.mq.model.UpdateConfigurationRequest
import aws.sdk.kotlin.services.mq.model.UpdateConfigurationResponse
import aws.sdk.kotlin.services.mq.model.UpdateUserRequest
import aws.sdk.kotlin.services.mq.model.UpdateUserResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "mq"
public const val SdkVersion: String = "1.3.81"
public const val ServiceApiVersion: String = "2017-11-27"

/**
 * Amazon MQ is a managed message broker service for Apache ActiveMQ and RabbitMQ that makes it easy to set up and operate message brokers in the cloud. A message broker allows software applications and components to communicate using various programming languages, operating systems, and formal messaging protocols.
 */
public interface MqClient : SdkClient {
    /**
     * MqClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, MqClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Mq",
                "MQ",
                "mq",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, MqClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): MqClient = DefaultMqClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: MqEndpointProvider = builder.endpointProvider ?: DefaultMqEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: MqAuthSchemeProvider = builder.authSchemeProvider ?: DefaultMqAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "mq"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: MqEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: MqAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a broker. Note: This API is asynchronous.
     *
     * To create a broker, you must either use the AmazonMQFullAccess IAM policy or include the following EC2 permissions in your IAM policy.
     * + ec2:CreateNetworkInterfaceThis permission is required to allow Amazon MQ to create an elastic network interface (ENI) on behalf of your account.
     * + ec2:CreateNetworkInterfacePermissionThis permission is required to attach the ENI to the broker instance.
     * + ec2:DeleteNetworkInterface
     * + ec2:DeleteNetworkInterfacePermission
     * + ec2:DetachNetworkInterface
     * + ec2:DescribeInternetGateways
     * + ec2:DescribeNetworkInterfaces
     * + ec2:DescribeNetworkInterfacePermissions
     * + ec2:DescribeRouteTables
     * + ec2:DescribeSecurityGroups
     * + ec2:DescribeSubnets
     * + ec2:DescribeVpcs
     *
     * For more information, see [Create an IAM User and Get Your Amazon Web Services Credentials](https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/amazon-mq-setting-up.html#create-iam-user) and [Never Modify or Delete the Amazon MQ Elastic Network Interface](https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/connecting-to-amazon-mq.html#never-modify-delete-elastic-network-interface) in the *Amazon MQ Developer Guide*.
     */
    public suspend fun createBroker(input: CreateBrokerRequest): CreateBrokerResponse

    /**
     * Creates a new configuration for the specified configuration name. Amazon MQ uses the default configuration (the engine type and version).
     */
    public suspend fun createConfiguration(input: CreateConfigurationRequest): CreateConfigurationResponse

    /**
     * Add a tag to a resource.
     */
    public suspend fun createTags(input: CreateTagsRequest): CreateTagsResponse

    /**
     * Creates an ActiveMQ user.
     *
     * Do not add personally identifiable information (PII) or other confidential or sensitive information in broker usernames. Broker usernames are accessible to other Amazon Web Services services, including CloudWatch Logs. Broker usernames are not intended to be used for private or sensitive data.
     */
    public suspend fun createUser(input: CreateUserRequest): CreateUserResponse

    /**
     * Deletes a broker. Note: This API is asynchronous.
     */
    public suspend fun deleteBroker(input: DeleteBrokerRequest): DeleteBrokerResponse

    /**
     * Removes a tag from a resource.
     */
    public suspend fun deleteTags(input: DeleteTagsRequest): DeleteTagsResponse

    /**
     * Deletes an ActiveMQ user.
     */
    public suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse

    /**
     * Returns information about the specified broker.
     */
    public suspend fun describeBroker(input: DescribeBrokerRequest): DescribeBrokerResponse

    /**
     * Describe available engine types and versions.
     */
    public suspend fun describeBrokerEngineTypes(input: DescribeBrokerEngineTypesRequest = DescribeBrokerEngineTypesRequest { }): DescribeBrokerEngineTypesResponse

    /**
     * Describe available broker instance options.
     */
    public suspend fun describeBrokerInstanceOptions(input: DescribeBrokerInstanceOptionsRequest = DescribeBrokerInstanceOptionsRequest { }): DescribeBrokerInstanceOptionsResponse

    /**
     * Returns information about the specified configuration.
     */
    public suspend fun describeConfiguration(input: DescribeConfigurationRequest): DescribeConfigurationResponse

    /**
     * Returns the specified configuration revision for the specified configuration.
     */
    public suspend fun describeConfigurationRevision(input: DescribeConfigurationRevisionRequest): DescribeConfigurationRevisionResponse

    /**
     * Returns information about an ActiveMQ user.
     */
    public suspend fun describeUser(input: DescribeUserRequest): DescribeUserResponse

    /**
     * Returns a list of all brokers.
     */
    public suspend fun listBrokers(input: ListBrokersRequest = ListBrokersRequest { }): ListBrokersResponse

    /**
     * Returns a list of all revisions for the specified configuration.
     */
    public suspend fun listConfigurationRevisions(input: ListConfigurationRevisionsRequest): ListConfigurationRevisionsResponse

    /**
     * Returns a list of all configurations.
     */
    public suspend fun listConfigurations(input: ListConfigurationsRequest = ListConfigurationsRequest { }): ListConfigurationsResponse

    /**
     * Lists tags for a resource.
     */
    public suspend fun listTags(input: ListTagsRequest): ListTagsResponse

    /**
     * Returns a list of all ActiveMQ users.
     */
    public suspend fun listUsers(input: ListUsersRequest): ListUsersResponse

    /**
     * Promotes a data replication replica broker to the primary broker role.
     */
    public suspend fun promote(input: PromoteRequest): PromoteResponse

    /**
     * Reboots a broker. Note: This API is asynchronous.
     */
    public suspend fun rebootBroker(input: RebootBrokerRequest): RebootBrokerResponse

    /**
     * Adds a pending configuration change to a broker.
     */
    public suspend fun updateBroker(input: UpdateBrokerRequest): UpdateBrokerResponse

    /**
     * Updates the specified configuration.
     */
    public suspend fun updateConfiguration(input: UpdateConfigurationRequest): UpdateConfigurationResponse

    /**
     * Updates the information for an ActiveMQ user.
     */
    public suspend fun updateUser(input: UpdateUserRequest): UpdateUserResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun MqClient.withConfig(block: MqClient.Config.Builder.() -> Unit): MqClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultMqClient(newConfig)
}

/**
 * Creates a broker. Note: This API is asynchronous.
 *
 * To create a broker, you must either use the AmazonMQFullAccess IAM policy or include the following EC2 permissions in your IAM policy.
 * + ec2:CreateNetworkInterfaceThis permission is required to allow Amazon MQ to create an elastic network interface (ENI) on behalf of your account.
 * + ec2:CreateNetworkInterfacePermissionThis permission is required to attach the ENI to the broker instance.
 * + ec2:DeleteNetworkInterface
 * + ec2:DeleteNetworkInterfacePermission
 * + ec2:DetachNetworkInterface
 * + ec2:DescribeInternetGateways
 * + ec2:DescribeNetworkInterfaces
 * + ec2:DescribeNetworkInterfacePermissions
 * + ec2:DescribeRouteTables
 * + ec2:DescribeSecurityGroups
 * + ec2:DescribeSubnets
 * + ec2:DescribeVpcs
 *
 * For more information, see [Create an IAM User and Get Your Amazon Web Services Credentials](https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/amazon-mq-setting-up.html#create-iam-user) and [Never Modify or Delete the Amazon MQ Elastic Network Interface](https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/connecting-to-amazon-mq.html#never-modify-delete-elastic-network-interface) in the *Amazon MQ Developer Guide*.
 */
public suspend inline fun MqClient.createBroker(crossinline block: CreateBrokerRequest.Builder.() -> Unit): CreateBrokerResponse = createBroker(CreateBrokerRequest.Builder().apply(block).build())

/**
 * Creates a new configuration for the specified configuration name. Amazon MQ uses the default configuration (the engine type and version).
 */
public suspend inline fun MqClient.createConfiguration(crossinline block: CreateConfigurationRequest.Builder.() -> Unit): CreateConfigurationResponse = createConfiguration(CreateConfigurationRequest.Builder().apply(block).build())

/**
 * Add a tag to a resource.
 */
public suspend inline fun MqClient.createTags(crossinline block: CreateTagsRequest.Builder.() -> Unit): CreateTagsResponse = createTags(CreateTagsRequest.Builder().apply(block).build())

/**
 * Creates an ActiveMQ user.
 *
 * Do not add personally identifiable information (PII) or other confidential or sensitive information in broker usernames. Broker usernames are accessible to other Amazon Web Services services, including CloudWatch Logs. Broker usernames are not intended to be used for private or sensitive data.
 */
public suspend inline fun MqClient.createUser(crossinline block: CreateUserRequest.Builder.() -> Unit): CreateUserResponse = createUser(CreateUserRequest.Builder().apply(block).build())

/**
 * Deletes a broker. Note: This API is asynchronous.
 */
public suspend inline fun MqClient.deleteBroker(crossinline block: DeleteBrokerRequest.Builder.() -> Unit): DeleteBrokerResponse = deleteBroker(DeleteBrokerRequest.Builder().apply(block).build())

/**
 * Removes a tag from a resource.
 */
public suspend inline fun MqClient.deleteTags(crossinline block: DeleteTagsRequest.Builder.() -> Unit): DeleteTagsResponse = deleteTags(DeleteTagsRequest.Builder().apply(block).build())

/**
 * Deletes an ActiveMQ user.
 */
public suspend inline fun MqClient.deleteUser(crossinline block: DeleteUserRequest.Builder.() -> Unit): DeleteUserResponse = deleteUser(DeleteUserRequest.Builder().apply(block).build())

/**
 * Returns information about the specified broker.
 */
public suspend inline fun MqClient.describeBroker(crossinline block: DescribeBrokerRequest.Builder.() -> Unit): DescribeBrokerResponse = describeBroker(DescribeBrokerRequest.Builder().apply(block).build())

/**
 * Describe available engine types and versions.
 */
public suspend inline fun MqClient.describeBrokerEngineTypes(crossinline block: DescribeBrokerEngineTypesRequest.Builder.() -> Unit): DescribeBrokerEngineTypesResponse = describeBrokerEngineTypes(DescribeBrokerEngineTypesRequest.Builder().apply(block).build())

/**
 * Describe available broker instance options.
 */
public suspend inline fun MqClient.describeBrokerInstanceOptions(crossinline block: DescribeBrokerInstanceOptionsRequest.Builder.() -> Unit): DescribeBrokerInstanceOptionsResponse = describeBrokerInstanceOptions(DescribeBrokerInstanceOptionsRequest.Builder().apply(block).build())

/**
 * Returns information about the specified configuration.
 */
public suspend inline fun MqClient.describeConfiguration(crossinline block: DescribeConfigurationRequest.Builder.() -> Unit): DescribeConfigurationResponse = describeConfiguration(DescribeConfigurationRequest.Builder().apply(block).build())

/**
 * Returns the specified configuration revision for the specified configuration.
 */
public suspend inline fun MqClient.describeConfigurationRevision(crossinline block: DescribeConfigurationRevisionRequest.Builder.() -> Unit): DescribeConfigurationRevisionResponse = describeConfigurationRevision(DescribeConfigurationRevisionRequest.Builder().apply(block).build())

/**
 * Returns information about an ActiveMQ user.
 */
public suspend inline fun MqClient.describeUser(crossinline block: DescribeUserRequest.Builder.() -> Unit): DescribeUserResponse = describeUser(DescribeUserRequest.Builder().apply(block).build())

/**
 * Returns a list of all brokers.
 */
public suspend inline fun MqClient.listBrokers(crossinline block: ListBrokersRequest.Builder.() -> Unit): ListBrokersResponse = listBrokers(ListBrokersRequest.Builder().apply(block).build())

/**
 * Returns a list of all revisions for the specified configuration.
 */
public suspend inline fun MqClient.listConfigurationRevisions(crossinline block: ListConfigurationRevisionsRequest.Builder.() -> Unit): ListConfigurationRevisionsResponse = listConfigurationRevisions(ListConfigurationRevisionsRequest.Builder().apply(block).build())

/**
 * Returns a list of all configurations.
 */
public suspend inline fun MqClient.listConfigurations(crossinline block: ListConfigurationsRequest.Builder.() -> Unit): ListConfigurationsResponse = listConfigurations(ListConfigurationsRequest.Builder().apply(block).build())

/**
 * Lists tags for a resource.
 */
public suspend inline fun MqClient.listTags(crossinline block: ListTagsRequest.Builder.() -> Unit): ListTagsResponse = listTags(ListTagsRequest.Builder().apply(block).build())

/**
 * Returns a list of all ActiveMQ users.
 */
public suspend inline fun MqClient.listUsers(crossinline block: ListUsersRequest.Builder.() -> Unit): ListUsersResponse = listUsers(ListUsersRequest.Builder().apply(block).build())

/**
 * Promotes a data replication replica broker to the primary broker role.
 */
public suspend inline fun MqClient.promote(crossinline block: PromoteRequest.Builder.() -> Unit): PromoteResponse = promote(PromoteRequest.Builder().apply(block).build())

/**
 * Reboots a broker. Note: This API is asynchronous.
 */
public suspend inline fun MqClient.rebootBroker(crossinline block: RebootBrokerRequest.Builder.() -> Unit): RebootBrokerResponse = rebootBroker(RebootBrokerRequest.Builder().apply(block).build())

/**
 * Adds a pending configuration change to a broker.
 */
public suspend inline fun MqClient.updateBroker(crossinline block: UpdateBrokerRequest.Builder.() -> Unit): UpdateBrokerResponse = updateBroker(UpdateBrokerRequest.Builder().apply(block).build())

/**
 * Updates the specified configuration.
 */
public suspend inline fun MqClient.updateConfiguration(crossinline block: UpdateConfigurationRequest.Builder.() -> Unit): UpdateConfigurationResponse = updateConfiguration(UpdateConfigurationRequest.Builder().apply(block).build())

/**
 * Updates the information for an ActiveMQ user.
 */
public suspend inline fun MqClient.updateUser(crossinline block: UpdateUserRequest.Builder.() -> Unit): UpdateUserResponse = updateUser(UpdateUserRequest.Builder().apply(block).build())
