// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mq.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Updates the broker using the specified properties.
 */
public class UpdateBrokerRequest private constructor(builder: Builder) {
    /**
     * Optional. The authentication strategy used to secure the broker. The default is SIMPLE.
     */
    public val authenticationStrategy: aws.sdk.kotlin.services.mq.model.AuthenticationStrategy? = builder.authenticationStrategy
    /**
     * Enables automatic upgrades to new patch versions for brokers as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window or after a manual broker reboot.
     *
     * Must be set to true for ActiveMQ brokers version 5.18 and above and for RabbitMQ brokers version 3.13 and above.
     */
    public val autoMinorVersionUpgrade: kotlin.Boolean? = builder.autoMinorVersionUpgrade
    /**
     * The unique ID that Amazon MQ generates for the broker.
     */
    public val brokerId: kotlin.String? = builder.brokerId
    /**
     * A list of information about the configuration.
     */
    public val configuration: aws.sdk.kotlin.services.mq.model.ConfigurationId? = builder.configuration
    /**
     * Defines whether this broker is a part of a data replication pair.
     */
    public val dataReplicationMode: aws.sdk.kotlin.services.mq.model.DataReplicationMode? = builder.dataReplicationMode
    /**
     * The broker engine version. For more information, see the [ActiveMQ version management](https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/activemq-version-management.html) and the [RabbitMQ version management](https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/rabbitmq-version-management.html) sections in the Amazon MQ Developer Guide.
     *
     * When upgrading to ActiveMQ version 5.18 and above or RabbitMQ version 3.13 and above, you must have autoMinorVersionUpgrade set to true for the broker.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The broker's host instance type to upgrade to. For a list of supported instance types, see [Broker instance types](https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types).
     */
    public val hostInstanceType: kotlin.String? = builder.hostInstanceType
    /**
     * Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.
     */
    public val ldapServerMetadata: aws.sdk.kotlin.services.mq.model.LdapServerMetadataInput? = builder.ldapServerMetadata
    /**
     * Enables Amazon CloudWatch logging for brokers.
     */
    public val logs: aws.sdk.kotlin.services.mq.model.Logs? = builder.logs
    /**
     * The parameters that determine the WeeklyStartTime.
     */
    public val maintenanceWindowStartTime: aws.sdk.kotlin.services.mq.model.WeeklyStartTime? = builder.maintenanceWindowStartTime
    /**
     * The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.
     */
    public val securityGroups: List<String>? = builder.securityGroups

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mq.model.UpdateBrokerRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateBrokerRequest(")
        append("authenticationStrategy=$authenticationStrategy,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("brokerId=$brokerId,")
        append("configuration=$configuration,")
        append("dataReplicationMode=$dataReplicationMode,")
        append("engineVersion=$engineVersion,")
        append("hostInstanceType=$hostInstanceType,")
        append("ldapServerMetadata=$ldapServerMetadata,")
        append("logs=$logs,")
        append("maintenanceWindowStartTime=$maintenanceWindowStartTime,")
        append("securityGroups=$securityGroups")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationStrategy?.hashCode() ?: 0
        result = 31 * result + (autoMinorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (brokerId?.hashCode() ?: 0)
        result = 31 * result + (configuration?.hashCode() ?: 0)
        result = 31 * result + (dataReplicationMode?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (hostInstanceType?.hashCode() ?: 0)
        result = 31 * result + (ldapServerMetadata?.hashCode() ?: 0)
        result = 31 * result + (logs?.hashCode() ?: 0)
        result = 31 * result + (maintenanceWindowStartTime?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateBrokerRequest

        if (authenticationStrategy != other.authenticationStrategy) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (brokerId != other.brokerId) return false
        if (configuration != other.configuration) return false
        if (dataReplicationMode != other.dataReplicationMode) return false
        if (engineVersion != other.engineVersion) return false
        if (hostInstanceType != other.hostInstanceType) return false
        if (ldapServerMetadata != other.ldapServerMetadata) return false
        if (logs != other.logs) return false
        if (maintenanceWindowStartTime != other.maintenanceWindowStartTime) return false
        if (securityGroups != other.securityGroups) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mq.model.UpdateBrokerRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Optional. The authentication strategy used to secure the broker. The default is SIMPLE.
         */
        public var authenticationStrategy: aws.sdk.kotlin.services.mq.model.AuthenticationStrategy? = null
        /**
         * Enables automatic upgrades to new patch versions for brokers as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window or after a manual broker reboot.
         *
         * Must be set to true for ActiveMQ brokers version 5.18 and above and for RabbitMQ brokers version 3.13 and above.
         */
        public var autoMinorVersionUpgrade: kotlin.Boolean? = null
        /**
         * The unique ID that Amazon MQ generates for the broker.
         */
        public var brokerId: kotlin.String? = null
        /**
         * A list of information about the configuration.
         */
        public var configuration: aws.sdk.kotlin.services.mq.model.ConfigurationId? = null
        /**
         * Defines whether this broker is a part of a data replication pair.
         */
        public var dataReplicationMode: aws.sdk.kotlin.services.mq.model.DataReplicationMode? = null
        /**
         * The broker engine version. For more information, see the [ActiveMQ version management](https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/activemq-version-management.html) and the [RabbitMQ version management](https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/rabbitmq-version-management.html) sections in the Amazon MQ Developer Guide.
         *
         * When upgrading to ActiveMQ version 5.18 and above or RabbitMQ version 3.13 and above, you must have autoMinorVersionUpgrade set to true for the broker.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The broker's host instance type to upgrade to. For a list of supported instance types, see [Broker instance types](https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types).
         */
        public var hostInstanceType: kotlin.String? = null
        /**
         * Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.
         */
        public var ldapServerMetadata: aws.sdk.kotlin.services.mq.model.LdapServerMetadataInput? = null
        /**
         * Enables Amazon CloudWatch logging for brokers.
         */
        public var logs: aws.sdk.kotlin.services.mq.model.Logs? = null
        /**
         * The parameters that determine the WeeklyStartTime.
         */
        public var maintenanceWindowStartTime: aws.sdk.kotlin.services.mq.model.WeeklyStartTime? = null
        /**
         * The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.
         */
        public var securityGroups: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mq.model.UpdateBrokerRequest) : this() {
            this.authenticationStrategy = x.authenticationStrategy
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.brokerId = x.brokerId
            this.configuration = x.configuration
            this.dataReplicationMode = x.dataReplicationMode
            this.engineVersion = x.engineVersion
            this.hostInstanceType = x.hostInstanceType
            this.ldapServerMetadata = x.ldapServerMetadata
            this.logs = x.logs
            this.maintenanceWindowStartTime = x.maintenanceWindowStartTime
            this.securityGroups = x.securityGroups
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mq.model.UpdateBrokerRequest = UpdateBrokerRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.ConfigurationId] inside the given [block]
         */
        public fun configuration(block: aws.sdk.kotlin.services.mq.model.ConfigurationId.Builder.() -> kotlin.Unit) {
            this.configuration = aws.sdk.kotlin.services.mq.model.ConfigurationId.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.LdapServerMetadataInput] inside the given [block]
         */
        public fun ldapServerMetadata(block: aws.sdk.kotlin.services.mq.model.LdapServerMetadataInput.Builder.() -> kotlin.Unit) {
            this.ldapServerMetadata = aws.sdk.kotlin.services.mq.model.LdapServerMetadataInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.Logs] inside the given [block]
         */
        public fun logs(block: aws.sdk.kotlin.services.mq.model.Logs.Builder.() -> kotlin.Unit) {
            this.logs = aws.sdk.kotlin.services.mq.model.Logs.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.WeeklyStartTime] inside the given [block]
         */
        public fun maintenanceWindowStartTime(block: aws.sdk.kotlin.services.mq.model.WeeklyStartTime.Builder.() -> kotlin.Unit) {
            this.maintenanceWindowStartTime = aws.sdk.kotlin.services.mq.model.WeeklyStartTime.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
