// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mq.serde

import aws.sdk.kotlin.services.mq.model.ActionRequired
import aws.sdk.kotlin.services.mq.model.AuthenticationStrategy
import aws.sdk.kotlin.services.mq.model.BrokerInstance
import aws.sdk.kotlin.services.mq.model.BrokerState
import aws.sdk.kotlin.services.mq.model.BrokerStorageType
import aws.sdk.kotlin.services.mq.model.Configurations
import aws.sdk.kotlin.services.mq.model.DataReplicationMetadataOutput
import aws.sdk.kotlin.services.mq.model.DataReplicationMode
import aws.sdk.kotlin.services.mq.model.DeploymentMode
import aws.sdk.kotlin.services.mq.model.DescribeBrokerResponse
import aws.sdk.kotlin.services.mq.model.EncryptionOptions
import aws.sdk.kotlin.services.mq.model.EngineType
import aws.sdk.kotlin.services.mq.model.LdapServerMetadataOutput
import aws.sdk.kotlin.services.mq.model.LogsSummary
import aws.sdk.kotlin.services.mq.model.MqException
import aws.sdk.kotlin.services.mq.model.UserSummary
import aws.sdk.kotlin.services.mq.model.WeeklyStartTime
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class DescribeBrokerOperationDeserializer: HttpDeserializer.NonStreaming<DescribeBrokerResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeBrokerResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeBrokerError(context, call, payload)
        }
        val builder = DescribeBrokerResponse.Builder()

        if (payload != null) {
            deserializeDescribeBrokerOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeBrokerError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MqException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> MqException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeBrokerOperationBody(builder: DescribeBrokerResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACTIONSREQUIRED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("actionsRequired"))
    val AUTHENTICATIONSTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("authenticationStrategy"))
    val AUTOMINORVERSIONUPGRADE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("autoMinorVersionUpgrade"))
    val BROKERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("brokerArn"))
    val BROKERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("brokerId"))
    val BROKERINSTANCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("brokerInstances"))
    val BROKERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("brokerName"))
    val BROKERSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("brokerState"))
    val CONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("configurations"))
    val CREATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("created"))
    val DATAREPLICATIONMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("dataReplicationMetadata"))
    val DATAREPLICATIONMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("dataReplicationMode"))
    val DEPLOYMENTMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("deploymentMode"))
    val ENCRYPTIONOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("encryptionOptions"))
    val ENGINETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("engineType"))
    val ENGINEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("engineVersion"))
    val HOSTINSTANCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("hostInstanceType"))
    val LDAPSERVERMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ldapServerMetadata"))
    val LOGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("logs"))
    val MAINTENANCEWINDOWSTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("maintenanceWindowStartTime"))
    val PENDINGAUTHENTICATIONSTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("pendingAuthenticationStrategy"))
    val PENDINGDATAREPLICATIONMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("pendingDataReplicationMetadata"))
    val PENDINGDATAREPLICATIONMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("pendingDataReplicationMode"))
    val PENDINGENGINEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("pendingEngineVersion"))
    val PENDINGHOSTINSTANCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("pendingHostInstanceType"))
    val PENDINGLDAPSERVERMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("pendingLdapServerMetadata"))
    val PENDINGSECURITYGROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("pendingSecurityGroups"))
    val PUBLICLYACCESSIBLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("publiclyAccessible"))
    val SECURITYGROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("securityGroups"))
    val STORAGETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("storageType"))
    val SUBNETIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("subnetIds"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val USERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("users"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIONSREQUIRED_DESCRIPTOR)
        field(AUTHENTICATIONSTRATEGY_DESCRIPTOR)
        field(AUTOMINORVERSIONUPGRADE_DESCRIPTOR)
        field(BROKERARN_DESCRIPTOR)
        field(BROKERID_DESCRIPTOR)
        field(BROKERINSTANCES_DESCRIPTOR)
        field(BROKERNAME_DESCRIPTOR)
        field(BROKERSTATE_DESCRIPTOR)
        field(CONFIGURATIONS_DESCRIPTOR)
        field(CREATED_DESCRIPTOR)
        field(DATAREPLICATIONMETADATA_DESCRIPTOR)
        field(DATAREPLICATIONMODE_DESCRIPTOR)
        field(DEPLOYMENTMODE_DESCRIPTOR)
        field(ENCRYPTIONOPTIONS_DESCRIPTOR)
        field(ENGINETYPE_DESCRIPTOR)
        field(ENGINEVERSION_DESCRIPTOR)
        field(HOSTINSTANCETYPE_DESCRIPTOR)
        field(LDAPSERVERMETADATA_DESCRIPTOR)
        field(LOGS_DESCRIPTOR)
        field(MAINTENANCEWINDOWSTARTTIME_DESCRIPTOR)
        field(PENDINGAUTHENTICATIONSTRATEGY_DESCRIPTOR)
        field(PENDINGDATAREPLICATIONMETADATA_DESCRIPTOR)
        field(PENDINGDATAREPLICATIONMODE_DESCRIPTOR)
        field(PENDINGENGINEVERSION_DESCRIPTOR)
        field(PENDINGHOSTINSTANCETYPE_DESCRIPTOR)
        field(PENDINGLDAPSERVERMETADATA_DESCRIPTOR)
        field(PENDINGSECURITYGROUPS_DESCRIPTOR)
        field(PUBLICLYACCESSIBLE_DESCRIPTOR)
        field(SECURITYGROUPS_DESCRIPTOR)
        field(STORAGETYPE_DESCRIPTOR)
        field(SUBNETIDS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(USERS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACTIONSREQUIRED_DESCRIPTOR.index -> builder.actionsRequired =
                    deserializer.deserializeList(ACTIONSREQUIRED_DESCRIPTOR) {
                        val col0 = mutableListOf<ActionRequired>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeActionRequiredDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                AUTHENTICATIONSTRATEGY_DESCRIPTOR.index -> builder.authenticationStrategy = deserializeString().let { AuthenticationStrategy.fromValue(it) }
                AUTOMINORVERSIONUPGRADE_DESCRIPTOR.index -> builder.autoMinorVersionUpgrade = deserializeBoolean()
                BROKERARN_DESCRIPTOR.index -> builder.brokerArn = deserializeString()
                BROKERID_DESCRIPTOR.index -> builder.brokerId = deserializeString()
                BROKERINSTANCES_DESCRIPTOR.index -> builder.brokerInstances =
                    deserializer.deserializeList(BROKERINSTANCES_DESCRIPTOR) {
                        val col0 = mutableListOf<BrokerInstance>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBrokerInstanceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                BROKERNAME_DESCRIPTOR.index -> builder.brokerName = deserializeString()
                BROKERSTATE_DESCRIPTOR.index -> builder.brokerState = deserializeString().let { BrokerState.fromValue(it) }
                CONFIGURATIONS_DESCRIPTOR.index -> builder.configurations = deserializeConfigurationsDocument(deserializer)
                CREATED_DESCRIPTOR.index -> builder.created = deserializeInstant(TimestampFormat.ISO_8601)
                DATAREPLICATIONMETADATA_DESCRIPTOR.index -> builder.dataReplicationMetadata = deserializeDataReplicationMetadataOutputDocument(deserializer)
                DATAREPLICATIONMODE_DESCRIPTOR.index -> builder.dataReplicationMode = deserializeString().let { DataReplicationMode.fromValue(it) }
                DEPLOYMENTMODE_DESCRIPTOR.index -> builder.deploymentMode = deserializeString().let { DeploymentMode.fromValue(it) }
                ENCRYPTIONOPTIONS_DESCRIPTOR.index -> builder.encryptionOptions = deserializeEncryptionOptionsDocument(deserializer)
                ENGINETYPE_DESCRIPTOR.index -> builder.engineType = deserializeString().let { EngineType.fromValue(it) }
                ENGINEVERSION_DESCRIPTOR.index -> builder.engineVersion = deserializeString()
                HOSTINSTANCETYPE_DESCRIPTOR.index -> builder.hostInstanceType = deserializeString()
                LDAPSERVERMETADATA_DESCRIPTOR.index -> builder.ldapServerMetadata = deserializeLdapServerMetadataOutputDocument(deserializer)
                LOGS_DESCRIPTOR.index -> builder.logs = deserializeLogsSummaryDocument(deserializer)
                MAINTENANCEWINDOWSTARTTIME_DESCRIPTOR.index -> builder.maintenanceWindowStartTime = deserializeWeeklyStartTimeDocument(deserializer)
                PENDINGAUTHENTICATIONSTRATEGY_DESCRIPTOR.index -> builder.pendingAuthenticationStrategy = deserializeString().let { AuthenticationStrategy.fromValue(it) }
                PENDINGDATAREPLICATIONMETADATA_DESCRIPTOR.index -> builder.pendingDataReplicationMetadata = deserializeDataReplicationMetadataOutputDocument(deserializer)
                PENDINGDATAREPLICATIONMODE_DESCRIPTOR.index -> builder.pendingDataReplicationMode = deserializeString().let { DataReplicationMode.fromValue(it) }
                PENDINGENGINEVERSION_DESCRIPTOR.index -> builder.pendingEngineVersion = deserializeString()
                PENDINGHOSTINSTANCETYPE_DESCRIPTOR.index -> builder.pendingHostInstanceType = deserializeString()
                PENDINGLDAPSERVERMETADATA_DESCRIPTOR.index -> builder.pendingLdapServerMetadata = deserializeLdapServerMetadataOutputDocument(deserializer)
                PENDINGSECURITYGROUPS_DESCRIPTOR.index -> builder.pendingSecurityGroups =
                    deserializer.deserializeList(PENDINGSECURITYGROUPS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PUBLICLYACCESSIBLE_DESCRIPTOR.index -> builder.publiclyAccessible = deserializeBoolean()
                SECURITYGROUPS_DESCRIPTOR.index -> builder.securityGroups =
                    deserializer.deserializeList(SECURITYGROUPS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STORAGETYPE_DESCRIPTOR.index -> builder.storageType = deserializeString().let { BrokerStorageType.fromValue(it) }
                SUBNETIDS_DESCRIPTOR.index -> builder.subnetIds =
                    deserializer.deserializeList(SUBNETIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                USERS_DESCRIPTOR.index -> builder.users =
                    deserializer.deserializeList(USERS_DESCRIPTOR) {
                        val col0 = mutableListOf<UserSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUserSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
