// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mq.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateBrokerResponse private constructor(builder: Builder) {
    /**
     * Optional. The authentication strategy used to secure the broker. The default is SIMPLE.
     */
    public val authenticationStrategy: aws.sdk.kotlin.services.mq.model.AuthenticationStrategy? = builder.authenticationStrategy
    /**
     * The new boolean value that specifies whether broker engines automatically upgrade to new minor versions as new versions are released and supported by Amazon MQ.
     */
    public val autoMinorVersionUpgrade: kotlin.Boolean? = builder.autoMinorVersionUpgrade
    /**
     * Required. The unique ID that Amazon MQ generates for the broker.
     */
    public val brokerId: kotlin.String? = builder.brokerId
    /**
     * The ID of the updated configuration.
     */
    public val configuration: aws.sdk.kotlin.services.mq.model.ConfigurationId? = builder.configuration
    /**
     * The replication details of the data replication-enabled broker. Only returned if dataReplicationMode is set to CRDR.
     */
    public val dataReplicationMetadata: aws.sdk.kotlin.services.mq.model.DataReplicationMetadataOutput? = builder.dataReplicationMetadata
    /**
     * Describes whether this broker is a part of a data replication pair.
     */
    public val dataReplicationMode: aws.sdk.kotlin.services.mq.model.DataReplicationMode? = builder.dataReplicationMode
    /**
     * The broker engine version to upgrade to. For a list of supported engine versions, see [Supported engines](https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html).
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The broker's host instance type to upgrade to. For a list of supported instance types, see [Broker instance types](https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types).
     */
    public val hostInstanceType: kotlin.String? = builder.hostInstanceType
    /**
     * Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.
     */
    public val ldapServerMetadata: aws.sdk.kotlin.services.mq.model.LdapServerMetadataOutput? = builder.ldapServerMetadata
    /**
     * The list of information about logs to be enabled for the specified broker.
     */
    public val logs: aws.sdk.kotlin.services.mq.model.Logs? = builder.logs
    /**
     * The parameters that determine the WeeklyStartTime.
     */
    public val maintenanceWindowStartTime: aws.sdk.kotlin.services.mq.model.WeeklyStartTime? = builder.maintenanceWindowStartTime
    /**
     * The pending replication details of the data replication-enabled broker. Only returned if pendingDataReplicationMode is set to CRDR.
     */
    public val pendingDataReplicationMetadata: aws.sdk.kotlin.services.mq.model.DataReplicationMetadataOutput? = builder.pendingDataReplicationMetadata
    /**
     * Describes whether this broker will be a part of a data replication pair after reboot.
     */
    public val pendingDataReplicationMode: aws.sdk.kotlin.services.mq.model.DataReplicationMode? = builder.pendingDataReplicationMode
    /**
     * The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.
     */
    public val securityGroups: List<String>? = builder.securityGroups

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mq.model.UpdateBrokerResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateBrokerResponse(")
        append("authenticationStrategy=$authenticationStrategy,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("brokerId=$brokerId,")
        append("configuration=$configuration,")
        append("dataReplicationMetadata=$dataReplicationMetadata,")
        append("dataReplicationMode=$dataReplicationMode,")
        append("engineVersion=$engineVersion,")
        append("hostInstanceType=$hostInstanceType,")
        append("ldapServerMetadata=$ldapServerMetadata,")
        append("logs=$logs,")
        append("maintenanceWindowStartTime=$maintenanceWindowStartTime,")
        append("pendingDataReplicationMetadata=$pendingDataReplicationMetadata,")
        append("pendingDataReplicationMode=$pendingDataReplicationMode,")
        append("securityGroups=$securityGroups")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationStrategy?.hashCode() ?: 0
        result = 31 * result + (autoMinorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (brokerId?.hashCode() ?: 0)
        result = 31 * result + (configuration?.hashCode() ?: 0)
        result = 31 * result + (dataReplicationMetadata?.hashCode() ?: 0)
        result = 31 * result + (dataReplicationMode?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (hostInstanceType?.hashCode() ?: 0)
        result = 31 * result + (ldapServerMetadata?.hashCode() ?: 0)
        result = 31 * result + (logs?.hashCode() ?: 0)
        result = 31 * result + (maintenanceWindowStartTime?.hashCode() ?: 0)
        result = 31 * result + (pendingDataReplicationMetadata?.hashCode() ?: 0)
        result = 31 * result + (pendingDataReplicationMode?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateBrokerResponse

        if (authenticationStrategy != other.authenticationStrategy) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (brokerId != other.brokerId) return false
        if (configuration != other.configuration) return false
        if (dataReplicationMetadata != other.dataReplicationMetadata) return false
        if (dataReplicationMode != other.dataReplicationMode) return false
        if (engineVersion != other.engineVersion) return false
        if (hostInstanceType != other.hostInstanceType) return false
        if (ldapServerMetadata != other.ldapServerMetadata) return false
        if (logs != other.logs) return false
        if (maintenanceWindowStartTime != other.maintenanceWindowStartTime) return false
        if (pendingDataReplicationMetadata != other.pendingDataReplicationMetadata) return false
        if (pendingDataReplicationMode != other.pendingDataReplicationMode) return false
        if (securityGroups != other.securityGroups) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mq.model.UpdateBrokerResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Optional. The authentication strategy used to secure the broker. The default is SIMPLE.
         */
        public var authenticationStrategy: aws.sdk.kotlin.services.mq.model.AuthenticationStrategy? = null
        /**
         * The new boolean value that specifies whether broker engines automatically upgrade to new minor versions as new versions are released and supported by Amazon MQ.
         */
        public var autoMinorVersionUpgrade: kotlin.Boolean? = null
        /**
         * Required. The unique ID that Amazon MQ generates for the broker.
         */
        public var brokerId: kotlin.String? = null
        /**
         * The ID of the updated configuration.
         */
        public var configuration: aws.sdk.kotlin.services.mq.model.ConfigurationId? = null
        /**
         * The replication details of the data replication-enabled broker. Only returned if dataReplicationMode is set to CRDR.
         */
        public var dataReplicationMetadata: aws.sdk.kotlin.services.mq.model.DataReplicationMetadataOutput? = null
        /**
         * Describes whether this broker is a part of a data replication pair.
         */
        public var dataReplicationMode: aws.sdk.kotlin.services.mq.model.DataReplicationMode? = null
        /**
         * The broker engine version to upgrade to. For a list of supported engine versions, see [Supported engines](https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html).
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The broker's host instance type to upgrade to. For a list of supported instance types, see [Broker instance types](https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types).
         */
        public var hostInstanceType: kotlin.String? = null
        /**
         * Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.
         */
        public var ldapServerMetadata: aws.sdk.kotlin.services.mq.model.LdapServerMetadataOutput? = null
        /**
         * The list of information about logs to be enabled for the specified broker.
         */
        public var logs: aws.sdk.kotlin.services.mq.model.Logs? = null
        /**
         * The parameters that determine the WeeklyStartTime.
         */
        public var maintenanceWindowStartTime: aws.sdk.kotlin.services.mq.model.WeeklyStartTime? = null
        /**
         * The pending replication details of the data replication-enabled broker. Only returned if pendingDataReplicationMode is set to CRDR.
         */
        public var pendingDataReplicationMetadata: aws.sdk.kotlin.services.mq.model.DataReplicationMetadataOutput? = null
        /**
         * Describes whether this broker will be a part of a data replication pair after reboot.
         */
        public var pendingDataReplicationMode: aws.sdk.kotlin.services.mq.model.DataReplicationMode? = null
        /**
         * The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.
         */
        public var securityGroups: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mq.model.UpdateBrokerResponse) : this() {
            this.authenticationStrategy = x.authenticationStrategy
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.brokerId = x.brokerId
            this.configuration = x.configuration
            this.dataReplicationMetadata = x.dataReplicationMetadata
            this.dataReplicationMode = x.dataReplicationMode
            this.engineVersion = x.engineVersion
            this.hostInstanceType = x.hostInstanceType
            this.ldapServerMetadata = x.ldapServerMetadata
            this.logs = x.logs
            this.maintenanceWindowStartTime = x.maintenanceWindowStartTime
            this.pendingDataReplicationMetadata = x.pendingDataReplicationMetadata
            this.pendingDataReplicationMode = x.pendingDataReplicationMode
            this.securityGroups = x.securityGroups
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mq.model.UpdateBrokerResponse = UpdateBrokerResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.ConfigurationId] inside the given [block]
         */
        public fun configuration(block: aws.sdk.kotlin.services.mq.model.ConfigurationId.Builder.() -> kotlin.Unit) {
            this.configuration = aws.sdk.kotlin.services.mq.model.ConfigurationId.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.DataReplicationMetadataOutput] inside the given [block]
         */
        public fun dataReplicationMetadata(block: aws.sdk.kotlin.services.mq.model.DataReplicationMetadataOutput.Builder.() -> kotlin.Unit) {
            this.dataReplicationMetadata = aws.sdk.kotlin.services.mq.model.DataReplicationMetadataOutput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.LdapServerMetadataOutput] inside the given [block]
         */
        public fun ldapServerMetadata(block: aws.sdk.kotlin.services.mq.model.LdapServerMetadataOutput.Builder.() -> kotlin.Unit) {
            this.ldapServerMetadata = aws.sdk.kotlin.services.mq.model.LdapServerMetadataOutput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.Logs] inside the given [block]
         */
        public fun logs(block: aws.sdk.kotlin.services.mq.model.Logs.Builder.() -> kotlin.Unit) {
            this.logs = aws.sdk.kotlin.services.mq.model.Logs.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.WeeklyStartTime] inside the given [block]
         */
        public fun maintenanceWindowStartTime(block: aws.sdk.kotlin.services.mq.model.WeeklyStartTime.Builder.() -> kotlin.Unit) {
            this.maintenanceWindowStartTime = aws.sdk.kotlin.services.mq.model.WeeklyStartTime.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.DataReplicationMetadataOutput] inside the given [block]
         */
        public fun pendingDataReplicationMetadata(block: aws.sdk.kotlin.services.mq.model.DataReplicationMetadataOutput.Builder.() -> kotlin.Unit) {
            this.pendingDataReplicationMetadata = aws.sdk.kotlin.services.mq.model.DataReplicationMetadataOutput.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
