// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mq.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Returns information about all configurations.
 */
public class Configuration private constructor(builder: Builder) {
    /**
     * Required. The ARN of the configuration.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * Optional. The authentication strategy associated with the configuration. The default is SIMPLE.
     */
    public val authenticationStrategy: aws.sdk.kotlin.services.mq.model.AuthenticationStrategy? = builder.authenticationStrategy
    /**
     * Required. The date and time of the configuration revision.
     */
    public val created: aws.smithy.kotlin.runtime.time.Instant? = builder.created
    /**
     * Required. The description of the configuration.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.
     */
    public val engineType: aws.sdk.kotlin.services.mq.model.EngineType? = builder.engineType
    /**
     * Required. The broker engine's version. For a list of supported engine versions, see, [Supported engines](https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html).
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * Required. The unique ID that Amazon MQ generates for the configuration.
     */
    public val id: kotlin.String? = builder.id
    /**
     * Required. The latest revision of the configuration.
     */
    public val latestRevision: aws.sdk.kotlin.services.mq.model.ConfigurationRevision? = builder.latestRevision
    /**
     * Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The list of all tags associated with this configuration.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mq.model.Configuration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Configuration(")
        append("arn=$arn,")
        append("authenticationStrategy=$authenticationStrategy,")
        append("created=$created,")
        append("description=$description,")
        append("engineType=$engineType,")
        append("engineVersion=$engineVersion,")
        append("id=$id,")
        append("latestRevision=$latestRevision,")
        append("name=$name,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (authenticationStrategy?.hashCode() ?: 0)
        result = 31 * result + (created?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (engineType?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (latestRevision?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Configuration

        if (arn != other.arn) return false
        if (authenticationStrategy != other.authenticationStrategy) return false
        if (created != other.created) return false
        if (description != other.description) return false
        if (engineType != other.engineType) return false
        if (engineVersion != other.engineVersion) return false
        if (id != other.id) return false
        if (latestRevision != other.latestRevision) return false
        if (name != other.name) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mq.model.Configuration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Required. The ARN of the configuration.
         */
        public var arn: kotlin.String? = null
        /**
         * Optional. The authentication strategy associated with the configuration. The default is SIMPLE.
         */
        public var authenticationStrategy: aws.sdk.kotlin.services.mq.model.AuthenticationStrategy? = null
        /**
         * Required. The date and time of the configuration revision.
         */
        public var created: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Required. The description of the configuration.
         */
        public var description: kotlin.String? = null
        /**
         * Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.
         */
        public var engineType: aws.sdk.kotlin.services.mq.model.EngineType? = null
        /**
         * Required. The broker engine's version. For a list of supported engine versions, see, [Supported engines](https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html).
         */
        public var engineVersion: kotlin.String? = null
        /**
         * Required. The unique ID that Amazon MQ generates for the configuration.
         */
        public var id: kotlin.String? = null
        /**
         * Required. The latest revision of the configuration.
         */
        public var latestRevision: aws.sdk.kotlin.services.mq.model.ConfigurationRevision? = null
        /**
         * Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.
         */
        public var name: kotlin.String? = null
        /**
         * The list of all tags associated with this configuration.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mq.model.Configuration) : this() {
            this.arn = x.arn
            this.authenticationStrategy = x.authenticationStrategy
            this.created = x.created
            this.description = x.description
            this.engineType = x.engineType
            this.engineVersion = x.engineVersion
            this.id = x.id
            this.latestRevision = x.latestRevision
            this.name = x.name
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mq.model.Configuration = Configuration(this)

        /**
         * construct an [aws.sdk.kotlin.services.mq.model.ConfigurationRevision] inside the given [block]
         */
        public fun latestRevision(block: aws.sdk.kotlin.services.mq.model.ConfigurationRevision.Builder.() -> kotlin.Unit) {
            this.latestRevision = aws.sdk.kotlin.services.mq.model.ConfigurationRevision.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
