// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mq.serde

import aws.sdk.kotlin.services.mq.model.ConfigurationRevision
import aws.sdk.kotlin.services.mq.model.MqException
import aws.sdk.kotlin.services.mq.model.SanitizationWarning
import aws.sdk.kotlin.services.mq.model.UpdateConfigurationResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class UpdateConfigurationOperationDeserializer: HttpDeserialize<UpdateConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateConfigurationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateConfigurationError(context, call)
        }
        val builder = UpdateConfigurationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateConfigurationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdateConfigurationError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MqException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> MqException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateConfigurationOperationBody(builder: UpdateConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val CREATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("created"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val LATESTREVISION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("latestRevision"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val WARNINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("warnings"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(CREATED_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(LATESTREVISION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(WARNINGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CREATED_DESCRIPTOR.index -> builder.created = deserializeString().let { Instant.fromIso8601(it) }
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                LATESTREVISION_DESCRIPTOR.index -> builder.latestRevision = deserializeConfigurationRevisionDocument(deserializer)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                WARNINGS_DESCRIPTOR.index -> builder.warnings =
                    deserializer.deserializeList(WARNINGS_DESCRIPTOR) {
                        val col0 = mutableListOf<SanitizationWarning>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSanitizationWarningDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
