// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mq.serde

import aws.sdk.kotlin.services.mq.model.AuthenticationStrategy
import aws.sdk.kotlin.services.mq.model.ConfigurationId
import aws.sdk.kotlin.services.mq.model.DataReplicationMode
import aws.sdk.kotlin.services.mq.model.LdapServerMetadataInput
import aws.sdk.kotlin.services.mq.model.Logs
import aws.sdk.kotlin.services.mq.model.UpdateBrokerRequest
import aws.sdk.kotlin.services.mq.model.WeeklyStartTime
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateBrokerOperationSerializer: HttpSerialize<UpdateBrokerRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateBrokerRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.brokerId) { "brokerId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v1"))
                add(PercentEncoding.Path.encode("brokers"))
                add(PercentEncoding.SmithyLabel.encode("${input.brokerId}"))
            }
        }

        val payload = serializeUpdateBrokerOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateBrokerOperationBody(context: ExecutionContext, input: UpdateBrokerRequest): ByteArray {
    val serializer = JsonSerializer()
    val AUTHENTICATIONSTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("authenticationStrategy"))
    val AUTOMINORVERSIONUPGRADE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("autoMinorVersionUpgrade"))
    val CONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("configuration"))
    val DATAREPLICATIONMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("dataReplicationMode"))
    val ENGINEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("engineVersion"))
    val HOSTINSTANCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("hostInstanceType"))
    val LDAPSERVERMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ldapServerMetadata"))
    val LOGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("logs"))
    val MAINTENANCEWINDOWSTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("maintenanceWindowStartTime"))
    val SECURITYGROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("securityGroups"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTHENTICATIONSTRATEGY_DESCRIPTOR)
        field(AUTOMINORVERSIONUPGRADE_DESCRIPTOR)
        field(CONFIGURATION_DESCRIPTOR)
        field(DATAREPLICATIONMODE_DESCRIPTOR)
        field(ENGINEVERSION_DESCRIPTOR)
        field(HOSTINSTANCETYPE_DESCRIPTOR)
        field(LDAPSERVERMETADATA_DESCRIPTOR)
        field(LOGS_DESCRIPTOR)
        field(MAINTENANCEWINDOWSTARTTIME_DESCRIPTOR)
        field(SECURITYGROUPS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.authenticationStrategy?.let { field(AUTHENTICATIONSTRATEGY_DESCRIPTOR, it.value) }
        input.autoMinorVersionUpgrade?.let { field(AUTOMINORVERSIONUPGRADE_DESCRIPTOR, it) }
        input.configuration?.let { field(CONFIGURATION_DESCRIPTOR, it, ::serializeConfigurationIdDocument) }
        input.dataReplicationMode?.let { field(DATAREPLICATIONMODE_DESCRIPTOR, it.value) }
        input.engineVersion?.let { field(ENGINEVERSION_DESCRIPTOR, it) }
        input.hostInstanceType?.let { field(HOSTINSTANCETYPE_DESCRIPTOR, it) }
        input.ldapServerMetadata?.let { field(LDAPSERVERMETADATA_DESCRIPTOR, it, ::serializeLdapServerMetadataInputDocument) }
        input.logs?.let { field(LOGS_DESCRIPTOR, it, ::serializeLogsDocument) }
        input.maintenanceWindowStartTime?.let { field(MAINTENANCEWINDOWSTARTTIME_DESCRIPTOR, it, ::serializeWeeklyStartTimeDocument) }
        if (input.securityGroups != null) {
            listField(SECURITYGROUPS_DESCRIPTOR) {
                for (el0 in input.securityGroups) {
                    serializeString(el0)
                }
            }
        }
    }
    return serializer.toByteArray()
}
