// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mq.model



/**
 * Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker.
 *
 * Does not apply to RabbitMQ brokers.
 */
public class LdapServerMetadataInput private constructor(builder: Builder) {
    /**
     * Specifies the location of the LDAP server such as Directory Service for Microsoft Active Directory. Optional failover server.
     */
    public val hosts: List<String>? = builder.hosts
    /**
     * The distinguished name of the node in the directory information tree (DIT) to search for roles or groups. For example, ou=group, ou=corp, dc=corp, dc=example, dc=com.
     */
    public val roleBase: kotlin.String? = builder.roleBase
    /**
     * Specifies the LDAP attribute that identifies the group name attribute in the object returned from the group membership query.
     */
    public val roleName: kotlin.String? = builder.roleName
    /**
     * The LDAP search filter used to find roles within the roleBase. The distinguished name of the user matched by userSearchMatching is substituted into the {0} placeholder in the search filter. The client's username is substituted into the {1} placeholder. For example, if you set this option to (member=uid={1})for the user janedoe, the search filter becomes (member=uid=janedoe) after string substitution. It matches all role entries that have a member attribute equal to uid=janedoe under the subtree selected by the roleBase.
     */
    public val roleSearchMatching: kotlin.String? = builder.roleSearchMatching
    /**
     * The directory search scope for the role. If set to true, scope is to search the entire subtree.
     */
    public val roleSearchSubtree: kotlin.Boolean? = builder.roleSearchSubtree
    /**
     * Service account password. A service account is an account in your LDAP server that has access to initiate a connection. For example, cn=admin,dc=corp, dc=example, dc=com.
     */
    public val serviceAccountPassword: kotlin.String? = builder.serviceAccountPassword
    /**
     * Service account username. A service account is an account in your LDAP server that has access to initiate a connection. For example, cn=admin,dc=corp, dc=example, dc=com.
     */
    public val serviceAccountUsername: kotlin.String? = builder.serviceAccountUsername
    /**
     * Select a particular subtree of the directory information tree (DIT) to search for user entries. The subtree is specified by a DN, which specifies the base node of the subtree. For example, by setting this option to ou=Users,ou=corp, dc=corp, dc=example, dc=com, the search for user entries is restricted to the subtree beneath ou=Users, ou=corp, dc=corp, dc=example, dc=com.
     */
    public val userBase: kotlin.String? = builder.userBase
    /**
     * Specifies the name of the LDAP attribute for the user group membership.
     */
    public val userRoleName: kotlin.String? = builder.userRoleName
    /**
     * The LDAP search filter used to find users within the userBase. The client's username is substituted into the {0} placeholder in the search filter. For example, if this option is set to (uid={0}) and the received username is janedoe, the search filter becomes (uid=janedoe) after string substitution. It will result in matching an entry like uid=janedoe, ou=Users,ou=corp, dc=corp, dc=example, dc=com.
     */
    public val userSearchMatching: kotlin.String? = builder.userSearchMatching
    /**
     * The directory search scope for the user. If set to true, scope is to search the entire subtree.
     */
    public val userSearchSubtree: kotlin.Boolean? = builder.userSearchSubtree

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mq.model.LdapServerMetadataInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LdapServerMetadataInput(")
        append("hosts=$hosts,")
        append("roleBase=$roleBase,")
        append("roleName=$roleName,")
        append("roleSearchMatching=$roleSearchMatching,")
        append("roleSearchSubtree=$roleSearchSubtree,")
        append("serviceAccountPassword=$serviceAccountPassword,")
        append("serviceAccountUsername=$serviceAccountUsername,")
        append("userBase=$userBase,")
        append("userRoleName=$userRoleName,")
        append("userSearchMatching=$userSearchMatching,")
        append("userSearchSubtree=$userSearchSubtree")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = hosts?.hashCode() ?: 0
        result = 31 * result + (roleBase?.hashCode() ?: 0)
        result = 31 * result + (roleName?.hashCode() ?: 0)
        result = 31 * result + (roleSearchMatching?.hashCode() ?: 0)
        result = 31 * result + (roleSearchSubtree?.hashCode() ?: 0)
        result = 31 * result + (serviceAccountPassword?.hashCode() ?: 0)
        result = 31 * result + (serviceAccountUsername?.hashCode() ?: 0)
        result = 31 * result + (userBase?.hashCode() ?: 0)
        result = 31 * result + (userRoleName?.hashCode() ?: 0)
        result = 31 * result + (userSearchMatching?.hashCode() ?: 0)
        result = 31 * result + (userSearchSubtree?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LdapServerMetadataInput

        if (hosts != other.hosts) return false
        if (roleBase != other.roleBase) return false
        if (roleName != other.roleName) return false
        if (roleSearchMatching != other.roleSearchMatching) return false
        if (roleSearchSubtree != other.roleSearchSubtree) return false
        if (serviceAccountPassword != other.serviceAccountPassword) return false
        if (serviceAccountUsername != other.serviceAccountUsername) return false
        if (userBase != other.userBase) return false
        if (userRoleName != other.userRoleName) return false
        if (userSearchMatching != other.userSearchMatching) return false
        if (userSearchSubtree != other.userSearchSubtree) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mq.model.LdapServerMetadataInput = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the location of the LDAP server such as Directory Service for Microsoft Active Directory. Optional failover server.
         */
        public var hosts: List<String>? = null
        /**
         * The distinguished name of the node in the directory information tree (DIT) to search for roles or groups. For example, ou=group, ou=corp, dc=corp, dc=example, dc=com.
         */
        public var roleBase: kotlin.String? = null
        /**
         * Specifies the LDAP attribute that identifies the group name attribute in the object returned from the group membership query.
         */
        public var roleName: kotlin.String? = null
        /**
         * The LDAP search filter used to find roles within the roleBase. The distinguished name of the user matched by userSearchMatching is substituted into the {0} placeholder in the search filter. The client's username is substituted into the {1} placeholder. For example, if you set this option to (member=uid={1})for the user janedoe, the search filter becomes (member=uid=janedoe) after string substitution. It matches all role entries that have a member attribute equal to uid=janedoe under the subtree selected by the roleBase.
         */
        public var roleSearchMatching: kotlin.String? = null
        /**
         * The directory search scope for the role. If set to true, scope is to search the entire subtree.
         */
        public var roleSearchSubtree: kotlin.Boolean? = null
        /**
         * Service account password. A service account is an account in your LDAP server that has access to initiate a connection. For example, cn=admin,dc=corp, dc=example, dc=com.
         */
        public var serviceAccountPassword: kotlin.String? = null
        /**
         * Service account username. A service account is an account in your LDAP server that has access to initiate a connection. For example, cn=admin,dc=corp, dc=example, dc=com.
         */
        public var serviceAccountUsername: kotlin.String? = null
        /**
         * Select a particular subtree of the directory information tree (DIT) to search for user entries. The subtree is specified by a DN, which specifies the base node of the subtree. For example, by setting this option to ou=Users,ou=corp, dc=corp, dc=example, dc=com, the search for user entries is restricted to the subtree beneath ou=Users, ou=corp, dc=corp, dc=example, dc=com.
         */
        public var userBase: kotlin.String? = null
        /**
         * Specifies the name of the LDAP attribute for the user group membership.
         */
        public var userRoleName: kotlin.String? = null
        /**
         * The LDAP search filter used to find users within the userBase. The client's username is substituted into the {0} placeholder in the search filter. For example, if this option is set to (uid={0}) and the received username is janedoe, the search filter becomes (uid=janedoe) after string substitution. It will result in matching an entry like uid=janedoe, ou=Users,ou=corp, dc=corp, dc=example, dc=com.
         */
        public var userSearchMatching: kotlin.String? = null
        /**
         * The directory search scope for the user. If set to true, scope is to search the entire subtree.
         */
        public var userSearchSubtree: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mq.model.LdapServerMetadataInput) : this() {
            this.hosts = x.hosts
            this.roleBase = x.roleBase
            this.roleName = x.roleName
            this.roleSearchMatching = x.roleSearchMatching
            this.roleSearchSubtree = x.roleSearchSubtree
            this.serviceAccountPassword = x.serviceAccountPassword
            this.serviceAccountUsername = x.serviceAccountUsername
            this.userBase = x.userBase
            this.userRoleName = x.userRoleName
            this.userSearchMatching = x.userSearchMatching
            this.userSearchSubtree = x.userSearchSubtree
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mq.model.LdapServerMetadataInput = LdapServerMetadataInput(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
