// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mq.model



/**
 * Creates a new ActiveMQ user.
 */
public class CreateUserRequest private constructor(builder: Builder) {
    /**
     * The unique ID that Amazon MQ generates for the broker.
     */
    public val brokerId: kotlin.String? = builder.brokerId
    /**
     * Enables access to the ActiveMQ Web Console for the ActiveMQ user.
     */
    public val consoleAccess: kotlin.Boolean? = builder.consoleAccess
    /**
     * The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
     */
    public val groups: List<String>? = builder.groups
    /**
     * Required. The password of the user. This value must be at least 12 characters long, must contain at least 4 unique characters, and must not contain commas, colons, or equal signs (,:=).
     */
    public val password: kotlin.String? = builder.password
    /**
     * Defines if this user is intended for CRDR replication purposes.
     */
    public val replicationUser: kotlin.Boolean? = builder.replicationUser
    /**
     * The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
     */
    public val username: kotlin.String? = builder.username

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mq.model.CreateUserRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateUserRequest(")
        append("brokerId=$brokerId,")
        append("consoleAccess=$consoleAccess,")
        append("groups=$groups,")
        append("password=$password,")
        append("replicationUser=$replicationUser,")
        append("username=$username")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = brokerId?.hashCode() ?: 0
        result = 31 * result + (consoleAccess?.hashCode() ?: 0)
        result = 31 * result + (groups?.hashCode() ?: 0)
        result = 31 * result + (password?.hashCode() ?: 0)
        result = 31 * result + (replicationUser?.hashCode() ?: 0)
        result = 31 * result + (username?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateUserRequest

        if (brokerId != other.brokerId) return false
        if (consoleAccess != other.consoleAccess) return false
        if (groups != other.groups) return false
        if (password != other.password) return false
        if (replicationUser != other.replicationUser) return false
        if (username != other.username) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mq.model.CreateUserRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique ID that Amazon MQ generates for the broker.
         */
        public var brokerId: kotlin.String? = null
        /**
         * Enables access to the ActiveMQ Web Console for the ActiveMQ user.
         */
        public var consoleAccess: kotlin.Boolean? = null
        /**
         * The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
         */
        public var groups: List<String>? = null
        /**
         * Required. The password of the user. This value must be at least 12 characters long, must contain at least 4 unique characters, and must not contain commas, colons, or equal signs (,:=).
         */
        public var password: kotlin.String? = null
        /**
         * Defines if this user is intended for CRDR replication purposes.
         */
        public var replicationUser: kotlin.Boolean? = null
        /**
         * The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
         */
        public var username: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mq.model.CreateUserRequest) : this() {
            this.brokerId = x.brokerId
            this.consoleAccess = x.consoleAccess
            this.groups = x.groups
            this.password = x.password
            this.replicationUser = x.replicationUser
            this.username = x.username
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mq.model.CreateUserRequest = CreateUserRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
