// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mobile.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.mobile.model.DeleteProjectResponse
import aws.sdk.kotlin.services.mobile.model.MobileException
import aws.sdk.kotlin.services.mobile.model.Resource
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteProjectOperationDeserializer: HttpDeserialize<DeleteProjectResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteProjectResponse {
        if (!response.status.isSuccess()) {
            throwDeleteProjectError(context, response)
        }
        val builder = DeleteProjectResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteProjectOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeDeleteProjectOperationBody(builder: DeleteProjectResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DELETEDRESOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("deletedResources"))
    val ORPHANEDRESOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("orphanedResources"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DELETEDRESOURCES_DESCRIPTOR)
        field(ORPHANEDRESOURCES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DELETEDRESOURCES_DESCRIPTOR.index -> builder.deletedResources =
                    deserializer.deserializeList(DELETEDRESOURCES_DESCRIPTOR) {
                        val col0 = mutableListOf<Resource>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeResourceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ORPHANEDRESOURCES_DESCRIPTOR.index -> builder.orphanedResources =
                    deserializer.deserializeList(ORPHANEDRESOURCES_DESCRIPTOR) {
                        val col0 = mutableListOf<Resource>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeResourceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDeleteProjectError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer()
        "NotFoundException" -> NotFoundExceptionDeserializer()
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer()
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer()
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer()
        else -> throw MobileException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
