// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mobile.model



/**
 * Information about an instance of an AWS resource associated with a project.
 */
class Resource private constructor(builder: BuilderImpl) {
    /**
     * AWS resource name which uniquely identifies the resource in AWS systems.
     */
    val arn: String? = builder.arn
    /**
     * Key-value attribute pairs.
     */
    val attributes: Map<String, String>? = builder.attributes
    /**
     * Identifies which feature in AWS Mobile Hub is associated with this AWS resource.
     */
    val feature: String? = builder.feature
    /**
     * Name of the AWS resource (e.g., for an Amazon S3 bucket this is the name of the bucket).
     */
    val name: String? = builder.name
    /**
     * Simplified name for type of AWS resource (e.g., bucket is an Amazon S3 bucket).
     */
    val type: String? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Resource = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Resource(")
        append("arn=$arn,")
        append("attributes=$attributes,")
        append("feature=$feature,")
        append("name=$name,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (attributes?.hashCode() ?: 0)
        result = 31 * result + (feature?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Resource

        if (arn != other.arn) return false
        if (attributes != other.attributes) return false
        if (feature != other.feature) return false
        if (name != other.name) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Resource = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Resource
        /**
         * AWS resource name which uniquely identifies the resource in AWS systems.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * Key-value attribute pairs.
         */
        fun attributes(attributes: Map<String, String>): FluentBuilder
        /**
         * Identifies which feature in AWS Mobile Hub is associated with this AWS resource.
         */
        fun feature(feature: String): FluentBuilder
        /**
         * Name of the AWS resource (e.g., for an Amazon S3 bucket this is the name of the bucket).
         */
        fun name(name: String): FluentBuilder
        /**
         * Simplified name for type of AWS resource (e.g., bucket is an Amazon S3 bucket).
         */
        fun type(type: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * AWS resource name which uniquely identifies the resource in AWS systems.
         */
        var arn: String?
        /**
         * Key-value attribute pairs.
         */
        var attributes: Map<String, String>?
        /**
         * Identifies which feature in AWS Mobile Hub is associated with this AWS resource.
         */
        var feature: String?
        /**
         * Name of the AWS resource (e.g., for an Amazon S3 bucket this is the name of the bucket).
         */
        var name: String?
        /**
         * Simplified name for type of AWS resource (e.g., bucket is an Amazon S3 bucket).
         */
        var type: String?

        fun build(): Resource
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var attributes: Map<String, String>? = null
        override var feature: String? = null
        override var name: String? = null
        override var type: String? = null

        constructor(x: Resource) : this() {
            this.arn = x.arn
            this.attributes = x.attributes
            this.feature = x.feature
            this.name = x.name
            this.type = x.type
        }

        override fun build(): Resource = Resource(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun attributes(attributes: Map<String, String>): FluentBuilder = apply { this.attributes = attributes }
        override fun feature(feature: String): FluentBuilder = apply { this.feature = feature }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun type(type: String): FluentBuilder = apply { this.type = type }
    }
}
