// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mobile.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Detailed information about an AWS Mobile Hub project.
 */
class ProjectDetails private constructor(builder: BuilderImpl) {
    /**
     * Website URL for this project in the AWS Mobile Hub console.
     */
    val consoleUrl: String? = builder.consoleUrl
    /**
     * Date the project was created.
     */
    val createdDate: Instant? = builder.createdDate
    /**
     * Date of the last modification of the project.
     */
    val lastUpdatedDate: Instant? = builder.lastUpdatedDate
    /**
     * Name of the project.
     */
    val name: String? = builder.name
    /**
     * Unique project identifier.
     */
    val projectId: String? = builder.projectId
    /**
     * Default region to use for AWS resource creation in the AWS Mobile Hub project.
     */
    val region: String? = builder.region
    /**
     * List of AWS resources associated with a project.
     */
    val resources: List<Resource>? = builder.resources
    /**
     * Synchronization state for a project.
     */
    val state: ProjectState? = builder.state

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ProjectDetails = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ProjectDetails(")
        append("consoleUrl=$consoleUrl,")
        append("createdDate=$createdDate,")
        append("lastUpdatedDate=$lastUpdatedDate,")
        append("name=$name,")
        append("projectId=$projectId,")
        append("region=$region,")
        append("resources=$resources,")
        append("state=$state)")
    }

    override fun hashCode(): kotlin.Int {
        var result = consoleUrl?.hashCode() ?: 0
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDate?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (projectId?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (resources?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ProjectDetails

        if (consoleUrl != other.consoleUrl) return false
        if (createdDate != other.createdDate) return false
        if (lastUpdatedDate != other.lastUpdatedDate) return false
        if (name != other.name) return false
        if (projectId != other.projectId) return false
        if (region != other.region) return false
        if (resources != other.resources) return false
        if (state != other.state) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ProjectDetails = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ProjectDetails
        /**
         * Website URL for this project in the AWS Mobile Hub console.
         */
        fun consoleUrl(consoleUrl: String): FluentBuilder
        /**
         * Date the project was created.
         */
        fun createdDate(createdDate: Instant): FluentBuilder
        /**
         * Date of the last modification of the project.
         */
        fun lastUpdatedDate(lastUpdatedDate: Instant): FluentBuilder
        /**
         * Name of the project.
         */
        fun name(name: String): FluentBuilder
        /**
         * Unique project identifier.
         */
        fun projectId(projectId: String): FluentBuilder
        /**
         * Default region to use for AWS resource creation in the AWS Mobile Hub project.
         */
        fun region(region: String): FluentBuilder
        /**
         * List of AWS resources associated with a project.
         */
        fun resources(resources: List<Resource>): FluentBuilder
        /**
         * Synchronization state for a project.
         */
        fun state(state: ProjectState): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Website URL for this project in the AWS Mobile Hub console.
         */
        var consoleUrl: String?
        /**
         * Date the project was created.
         */
        var createdDate: Instant?
        /**
         * Date of the last modification of the project.
         */
        var lastUpdatedDate: Instant?
        /**
         * Name of the project.
         */
        var name: String?
        /**
         * Unique project identifier.
         */
        var projectId: String?
        /**
         * Default region to use for AWS resource creation in the AWS Mobile Hub project.
         */
        var region: String?
        /**
         * List of AWS resources associated with a project.
         */
        var resources: List<Resource>?
        /**
         * Synchronization state for a project.
         */
        var state: ProjectState?

        fun build(): ProjectDetails
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var consoleUrl: String? = null
        override var createdDate: Instant? = null
        override var lastUpdatedDate: Instant? = null
        override var name: String? = null
        override var projectId: String? = null
        override var region: String? = null
        override var resources: List<Resource>? = null
        override var state: ProjectState? = null

        constructor(x: ProjectDetails) : this() {
            this.consoleUrl = x.consoleUrl
            this.createdDate = x.createdDate
            this.lastUpdatedDate = x.lastUpdatedDate
            this.name = x.name
            this.projectId = x.projectId
            this.region = x.region
            this.resources = x.resources
            this.state = x.state
        }

        override fun build(): ProjectDetails = ProjectDetails(this)
        override fun consoleUrl(consoleUrl: String): FluentBuilder = apply { this.consoleUrl = consoleUrl }
        override fun createdDate(createdDate: Instant): FluentBuilder = apply { this.createdDate = createdDate }
        override fun lastUpdatedDate(lastUpdatedDate: Instant): FluentBuilder = apply { this.lastUpdatedDate = lastUpdatedDate }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun projectId(projectId: String): FluentBuilder = apply { this.projectId = projectId }
        override fun region(region: String): FluentBuilder = apply { this.region = region }
        override fun resources(resources: List<Resource>): FluentBuilder = apply { this.resources = resources }
        override fun state(state: ProjectState): FluentBuilder = apply { this.state = state }
    }
}
