// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mobile.model



/**
 * Request structure used to request projects list in AWS Mobile Hub.
 */
class ListProjectsRequest private constructor(builder: BuilderImpl) {
    /**
     * Maximum number of records to list in a single response.
     */
    val maxResults: Int = builder.maxResults
    /**
     * Pagination token. Set to null to start listing projects from start.
     * If non-null pagination token is returned in a result, then pass its
     * value in here in another request to list more projects.
     */
    val nextToken: String? = builder.nextToken

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListProjectsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListProjectsRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListProjectsRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListProjectsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListProjectsRequest
        /**
         * Maximum number of records to list in a single response.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * Pagination token. Set to null to start listing projects from start.
         * If non-null pagination token is returned in a result, then pass its
         * value in here in another request to list more projects.
         */
        fun nextToken(nextToken: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Maximum number of records to list in a single response.
         */
        var maxResults: Int
        /**
         * Pagination token. Set to null to start listing projects from start.
         * If non-null pagination token is returned in a result, then pass its
         * value in here in another request to list more projects.
         */
        var nextToken: String?

        fun build(): ListProjectsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var maxResults: Int = 0
        override var nextToken: String? = null

        constructor(x: ListProjectsRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        override fun build(): ListProjectsRequest = ListProjectsRequest(this)
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
    }
}
