// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mobile.model



/**
 * Result structure used for requests to export project configuration details.
 */
class ExportProjectResponse private constructor(builder: BuilderImpl) {
    /**
     * URL which can be used to download the exported project configuation file(s).
     */
    val downloadUrl: String? = builder.downloadUrl
    /**
     * URL which can be shared to allow other AWS users to create their own project
     * in AWS Mobile Hub with the same configuration as the specified project. This
     * URL pertains to a snapshot in time of the project configuration that is created
     * when this API is called. If you want to share additional changes to your project
     * configuration, then you will need to create and share a new snapshot by calling
     * this method again.
     */
    val shareUrl: String? = builder.shareUrl
    /**
     * Unique identifier for the exported snapshot of the project configuration. This
     * snapshot identifier is included in the share URL.
     */
    val snapshotId: String? = builder.snapshotId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ExportProjectResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ExportProjectResponse(")
        append("downloadUrl=$downloadUrl,")
        append("shareUrl=$shareUrl,")
        append("snapshotId=$snapshotId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = downloadUrl?.hashCode() ?: 0
        result = 31 * result + (shareUrl?.hashCode() ?: 0)
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ExportProjectResponse

        if (downloadUrl != other.downloadUrl) return false
        if (shareUrl != other.shareUrl) return false
        if (snapshotId != other.snapshotId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ExportProjectResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ExportProjectResponse
        /**
         * URL which can be used to download the exported project configuation file(s).
         */
        fun downloadUrl(downloadUrl: String): FluentBuilder
        /**
         * URL which can be shared to allow other AWS users to create their own project
         * in AWS Mobile Hub with the same configuration as the specified project. This
         * URL pertains to a snapshot in time of the project configuration that is created
         * when this API is called. If you want to share additional changes to your project
         * configuration, then you will need to create and share a new snapshot by calling
         * this method again.
         */
        fun shareUrl(shareUrl: String): FluentBuilder
        /**
         * Unique identifier for the exported snapshot of the project configuration. This
         * snapshot identifier is included in the share URL.
         */
        fun snapshotId(snapshotId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * URL which can be used to download the exported project configuation file(s).
         */
        var downloadUrl: String?
        /**
         * URL which can be shared to allow other AWS users to create their own project
         * in AWS Mobile Hub with the same configuration as the specified project. This
         * URL pertains to a snapshot in time of the project configuration that is created
         * when this API is called. If you want to share additional changes to your project
         * configuration, then you will need to create and share a new snapshot by calling
         * this method again.
         */
        var shareUrl: String?
        /**
         * Unique identifier for the exported snapshot of the project configuration. This
         * snapshot identifier is included in the share URL.
         */
        var snapshotId: String?

        fun build(): ExportProjectResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var downloadUrl: String? = null
        override var shareUrl: String? = null
        override var snapshotId: String? = null

        constructor(x: ExportProjectResponse) : this() {
            this.downloadUrl = x.downloadUrl
            this.shareUrl = x.shareUrl
            this.snapshotId = x.snapshotId
        }

        override fun build(): ExportProjectResponse = ExportProjectResponse(this)
        override fun downloadUrl(downloadUrl: String): FluentBuilder = apply { this.downloadUrl = downloadUrl }
        override fun shareUrl(shareUrl: String): FluentBuilder = apply { this.shareUrl = shareUrl }
        override fun snapshotId(snapshotId: String): FluentBuilder = apply { this.snapshotId = snapshotId }
    }
}
