// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mobile.model



/**
 * Request structure used to request a project be created.
 */
class CreateProjectRequest private constructor(builder: BuilderImpl) {
    /**
     * ZIP or YAML file which contains configuration settings to be used when creating
     * the project. This may be the contents of the file downloaded from the URL provided
     * in an export project operation.
     */
    val contents: ByteArray? = builder.contents
    /**
     * Name of the project.
     */
    val name: String? = builder.name
    /**
     * Default region where project resources should be created.
     */
    val region: String? = builder.region
    /**
     * Unique identifier for an exported snapshot of project configuration. This
     * snapshot identifier is included in the share URL when a project is exported.
     */
    val snapshotId: String? = builder.snapshotId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateProjectRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateProjectRequest(")
        append("contents=$contents,")
        append("name=$name,")
        append("region=$region,")
        append("snapshotId=$snapshotId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = contents?.contentHashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateProjectRequest

        if (contents != null) {
            if (other.contents == null) return false
            if (!contents.contentEquals(other.contents)) return false
        } else if (other.contents != null) return false
        if (name != other.name) return false
        if (region != other.region) return false
        if (snapshotId != other.snapshotId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateProjectRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateProjectRequest
        /**
         * ZIP or YAML file which contains configuration settings to be used when creating
         * the project. This may be the contents of the file downloaded from the URL provided
         * in an export project operation.
         */
        fun contents(contents: ByteArray): FluentBuilder
        /**
         * Name of the project.
         */
        fun name(name: String): FluentBuilder
        /**
         * Default region where project resources should be created.
         */
        fun region(region: String): FluentBuilder
        /**
         * Unique identifier for an exported snapshot of project configuration. This
         * snapshot identifier is included in the share URL when a project is exported.
         */
        fun snapshotId(snapshotId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * ZIP or YAML file which contains configuration settings to be used when creating
         * the project. This may be the contents of the file downloaded from the URL provided
         * in an export project operation.
         */
        var contents: ByteArray?
        /**
         * Name of the project.
         */
        var name: String?
        /**
         * Default region where project resources should be created.
         */
        var region: String?
        /**
         * Unique identifier for an exported snapshot of project configuration. This
         * snapshot identifier is included in the share URL when a project is exported.
         */
        var snapshotId: String?

        fun build(): CreateProjectRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var contents: ByteArray? = null
        override var name: String? = null
        override var region: String? = null
        override var snapshotId: String? = null

        constructor(x: CreateProjectRequest) : this() {
            this.contents = x.contents
            this.name = x.name
            this.region = x.region
            this.snapshotId = x.snapshotId
        }

        override fun build(): CreateProjectRequest = CreateProjectRequest(this)
        override fun contents(contents: ByteArray): FluentBuilder = apply { this.contents = contents }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun region(region: String): FluentBuilder = apply { this.region = region }
        override fun snapshotId(snapshotId: String): FluentBuilder = apply { this.snapshotId = snapshotId }
    }
}
