// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mobile

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.EndpointResolver
import aws.sdk.kotlin.services.mobile.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.mobile.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * AWS Mobile Service provides mobile app and website developers with capabilities
 * required to configure AWS resources and bootstrap their developer desktop projects
 * with the necessary SDKs, constants, tools and samples to make use of those resources.
 */
interface MobileClient : SdkClient {

    override val serviceName: String
        get() = "Mobile"
    /**
     * MobileClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.DslBuilder.() -> Unit = {}): MobileClient {
            val config = Config.BuilderImpl().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
            }.apply(block).build()
            return DefaultMobileClient(config)
        }

        operator fun invoke(config: Config): MobileClient = DefaultMobileClient(config)

        /**
         * Construct a [MobileClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): MobileClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return MobileClient(sharedConfig)
        }
    }

    class Config private constructor(builder: BuilderImpl): AwsClientConfig, HttpClientConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: EndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            @JvmStatic
            fun fluentBuilder(): FluentBuilder = BuilderImpl()

            operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Config = BuilderImpl().apply(block).build()
        }

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: EndpointResolver?

            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: EndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
        }
    }

    /**
     * Creates an AWS Mobile Hub project.
     */
    suspend fun createProject(input: CreateProjectRequest): CreateProjectResponse

    /**
     * Creates an AWS Mobile Hub project.
     */
    suspend fun createProject(block: CreateProjectRequest.DslBuilder.() -> Unit) = createProject(CreateProjectRequest.builder().apply(block).build())

    /**
     * Delets a project in AWS Mobile Hub.
     */
    suspend fun deleteProject(input: DeleteProjectRequest): DeleteProjectResponse

    /**
     * Delets a project in AWS Mobile Hub.
     */
    suspend fun deleteProject(block: DeleteProjectRequest.DslBuilder.() -> Unit) = deleteProject(DeleteProjectRequest.builder().apply(block).build())

    /**
     * Get the bundle details for the requested bundle id.
     */
    suspend fun describeBundle(input: DescribeBundleRequest): DescribeBundleResponse

    /**
     * Get the bundle details for the requested bundle id.
     */
    suspend fun describeBundle(block: DescribeBundleRequest.DslBuilder.() -> Unit) = describeBundle(DescribeBundleRequest.builder().apply(block).build())

    /**
     * Gets details about a project in AWS Mobile Hub.
     */
    suspend fun describeProject(input: DescribeProjectRequest): DescribeProjectResponse

    /**
     * Gets details about a project in AWS Mobile Hub.
     */
    suspend fun describeProject(block: DescribeProjectRequest.DslBuilder.() -> Unit) = describeProject(DescribeProjectRequest.builder().apply(block).build())

    /**
     * Generates customized software development kit (SDK) and or tool packages
     * used to integrate mobile web or mobile app clients with backend AWS resources.
     */
    suspend fun exportBundle(input: ExportBundleRequest): ExportBundleResponse

    /**
     * Generates customized software development kit (SDK) and or tool packages
     * used to integrate mobile web or mobile app clients with backend AWS resources.
     */
    suspend fun exportBundle(block: ExportBundleRequest.DslBuilder.() -> Unit) = exportBundle(ExportBundleRequest.builder().apply(block).build())

    /**
     * Exports project configuration to a snapshot which can be downloaded and shared.
     * Note that mobile app push credentials are encrypted in exported projects, so they
     * can only be shared successfully within the same AWS account.
     */
    suspend fun exportProject(input: ExportProjectRequest): ExportProjectResponse

    /**
     * Exports project configuration to a snapshot which can be downloaded and shared.
     * Note that mobile app push credentials are encrypted in exported projects, so they
     * can only be shared successfully within the same AWS account.
     */
    suspend fun exportProject(block: ExportProjectRequest.DslBuilder.() -> Unit) = exportProject(ExportProjectRequest.builder().apply(block).build())

    /**
     * List all available bundles.
     */
    suspend fun listBundles(input: ListBundlesRequest): ListBundlesResponse

    /**
     * List all available bundles.
     */
    suspend fun listBundles(block: ListBundlesRequest.DslBuilder.() -> Unit) = listBundles(ListBundlesRequest.builder().apply(block).build())

    /**
     * Lists projects in AWS Mobile Hub.
     */
    suspend fun listProjects(input: ListProjectsRequest): ListProjectsResponse

    /**
     * Lists projects in AWS Mobile Hub.
     */
    suspend fun listProjects(block: ListProjectsRequest.DslBuilder.() -> Unit) = listProjects(ListProjectsRequest.builder().apply(block).build())

    /**
     * Update an existing project.
     */
    suspend fun updateProject(input: UpdateProjectRequest): UpdateProjectResponse

    /**
     * Update an existing project.
     */
    suspend fun updateProject(block: UpdateProjectRequest.DslBuilder.() -> Unit) = updateProject(UpdateProjectRequest.builder().apply(block).build())
}
