// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mobile

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.services.mobile.model.*
import aws.sdk.kotlin.services.mobile.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "Mobile"
const val ServiceApiVersion: String = "2017-07-01"
const val SdkVersion: String = "0.8.0-alpha"

internal class DefaultMobileClient(override val config: MobileClient.Config) : MobileClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }

    /**
     * Creates an AWS Mobile Hub project.
     */
    override suspend fun createProject(input: CreateProjectRequest): CreateProjectResponse {
        val op = SdkHttpOperation.build<CreateProjectRequest, CreateProjectResponse> {
            serializer = CreateProjectOperationSerializer()
            deserializer = CreateProjectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateProject"
            }
        }
        registerCreateProjectMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Delets a project in AWS Mobile Hub.
     */
    override suspend fun deleteProject(input: DeleteProjectRequest): DeleteProjectResponse {
        val op = SdkHttpOperation.build<DeleteProjectRequest, DeleteProjectResponse> {
            serializer = DeleteProjectOperationSerializer()
            deserializer = DeleteProjectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteProject"
            }
        }
        registerDeleteProjectMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Get the bundle details for the requested bundle id.
     */
    override suspend fun describeBundle(input: DescribeBundleRequest): DescribeBundleResponse {
        val op = SdkHttpOperation.build<DescribeBundleRequest, DescribeBundleResponse> {
            serializer = DescribeBundleOperationSerializer()
            deserializer = DescribeBundleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeBundle"
            }
        }
        registerDescribeBundleMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets details about a project in AWS Mobile Hub.
     */
    override suspend fun describeProject(input: DescribeProjectRequest): DescribeProjectResponse {
        val op = SdkHttpOperation.build<DescribeProjectRequest, DescribeProjectResponse> {
            serializer = DescribeProjectOperationSerializer()
            deserializer = DescribeProjectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeProject"
            }
        }
        registerDescribeProjectMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Generates customized software development kit (SDK) and or tool packages
     * used to integrate mobile web or mobile app clients with backend AWS resources.
     */
    override suspend fun exportBundle(input: ExportBundleRequest): ExportBundleResponse {
        val op = SdkHttpOperation.build<ExportBundleRequest, ExportBundleResponse> {
            serializer = ExportBundleOperationSerializer()
            deserializer = ExportBundleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ExportBundle"
            }
        }
        registerExportBundleMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Exports project configuration to a snapshot which can be downloaded and shared.
     * Note that mobile app push credentials are encrypted in exported projects, so they
     * can only be shared successfully within the same AWS account.
     */
    override suspend fun exportProject(input: ExportProjectRequest): ExportProjectResponse {
        val op = SdkHttpOperation.build<ExportProjectRequest, ExportProjectResponse> {
            serializer = ExportProjectOperationSerializer()
            deserializer = ExportProjectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ExportProject"
            }
        }
        registerExportProjectMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * List all available bundles.
     */
    override suspend fun listBundles(input: ListBundlesRequest): ListBundlesResponse {
        val op = SdkHttpOperation.build<ListBundlesRequest, ListBundlesResponse> {
            serializer = ListBundlesOperationSerializer()
            deserializer = ListBundlesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListBundles"
            }
        }
        registerListBundlesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists projects in AWS Mobile Hub.
     */
    override suspend fun listProjects(input: ListProjectsRequest): ListProjectsResponse {
        val op = SdkHttpOperation.build<ListProjectsRequest, ListProjectsResponse> {
            serializer = ListProjectsOperationSerializer()
            deserializer = ListProjectsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListProjects"
            }
        }
        registerListProjectsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Update an existing project.
     */
    override suspend fun updateProject(input: UpdateProjectRequest): UpdateProjectResponse {
        val op = SdkHttpOperation.build<UpdateProjectRequest, UpdateProjectResponse> {
            serializer = UpdateProjectOperationSerializer()
            deserializer = UpdateProjectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateProject"
            }
        }
        registerUpdateProjectMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
    }
}
