// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhubstrategy

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.migrationhubstrategy.auth.DefaultMigrationHubStrategyAuthSchemeProvider
import aws.sdk.kotlin.services.migrationhubstrategy.auth.MigrationHubStrategyAuthSchemeProvider
import aws.sdk.kotlin.services.migrationhubstrategy.endpoints.DefaultMigrationHubStrategyEndpointProvider
import aws.sdk.kotlin.services.migrationhubstrategy.endpoints.MigrationHubStrategyEndpointParameters
import aws.sdk.kotlin.services.migrationhubstrategy.endpoints.MigrationHubStrategyEndpointProvider
import aws.sdk.kotlin.services.migrationhubstrategy.model.GetApplicationComponentDetailsRequest
import aws.sdk.kotlin.services.migrationhubstrategy.model.GetApplicationComponentDetailsResponse
import aws.sdk.kotlin.services.migrationhubstrategy.model.GetApplicationComponentStrategiesRequest
import aws.sdk.kotlin.services.migrationhubstrategy.model.GetApplicationComponentStrategiesResponse
import aws.sdk.kotlin.services.migrationhubstrategy.model.GetAssessmentRequest
import aws.sdk.kotlin.services.migrationhubstrategy.model.GetAssessmentResponse
import aws.sdk.kotlin.services.migrationhubstrategy.model.GetImportFileTaskRequest
import aws.sdk.kotlin.services.migrationhubstrategy.model.GetImportFileTaskResponse
import aws.sdk.kotlin.services.migrationhubstrategy.model.GetLatestAssessmentIdRequest
import aws.sdk.kotlin.services.migrationhubstrategy.model.GetLatestAssessmentIdResponse
import aws.sdk.kotlin.services.migrationhubstrategy.model.GetPortfolioPreferencesRequest
import aws.sdk.kotlin.services.migrationhubstrategy.model.GetPortfolioPreferencesResponse
import aws.sdk.kotlin.services.migrationhubstrategy.model.GetPortfolioSummaryRequest
import aws.sdk.kotlin.services.migrationhubstrategy.model.GetPortfolioSummaryResponse
import aws.sdk.kotlin.services.migrationhubstrategy.model.GetRecommendationReportDetailsRequest
import aws.sdk.kotlin.services.migrationhubstrategy.model.GetRecommendationReportDetailsResponse
import aws.sdk.kotlin.services.migrationhubstrategy.model.GetServerDetailsRequest
import aws.sdk.kotlin.services.migrationhubstrategy.model.GetServerDetailsResponse
import aws.sdk.kotlin.services.migrationhubstrategy.model.GetServerStrategiesRequest
import aws.sdk.kotlin.services.migrationhubstrategy.model.GetServerStrategiesResponse
import aws.sdk.kotlin.services.migrationhubstrategy.model.ListAnalyzableServersRequest
import aws.sdk.kotlin.services.migrationhubstrategy.model.ListAnalyzableServersResponse
import aws.sdk.kotlin.services.migrationhubstrategy.model.ListApplicationComponentsRequest
import aws.sdk.kotlin.services.migrationhubstrategy.model.ListApplicationComponentsResponse
import aws.sdk.kotlin.services.migrationhubstrategy.model.ListCollectorsRequest
import aws.sdk.kotlin.services.migrationhubstrategy.model.ListCollectorsResponse
import aws.sdk.kotlin.services.migrationhubstrategy.model.ListImportFileTaskRequest
import aws.sdk.kotlin.services.migrationhubstrategy.model.ListImportFileTaskResponse
import aws.sdk.kotlin.services.migrationhubstrategy.model.ListServersRequest
import aws.sdk.kotlin.services.migrationhubstrategy.model.ListServersResponse
import aws.sdk.kotlin.services.migrationhubstrategy.model.PutPortfolioPreferencesRequest
import aws.sdk.kotlin.services.migrationhubstrategy.model.PutPortfolioPreferencesResponse
import aws.sdk.kotlin.services.migrationhubstrategy.model.StartAssessmentRequest
import aws.sdk.kotlin.services.migrationhubstrategy.model.StartAssessmentResponse
import aws.sdk.kotlin.services.migrationhubstrategy.model.StartImportFileTaskRequest
import aws.sdk.kotlin.services.migrationhubstrategy.model.StartImportFileTaskResponse
import aws.sdk.kotlin.services.migrationhubstrategy.model.StartRecommendationReportGenerationRequest
import aws.sdk.kotlin.services.migrationhubstrategy.model.StartRecommendationReportGenerationResponse
import aws.sdk.kotlin.services.migrationhubstrategy.model.StopAssessmentRequest
import aws.sdk.kotlin.services.migrationhubstrategy.model.StopAssessmentResponse
import aws.sdk.kotlin.services.migrationhubstrategy.model.UpdateApplicationComponentConfigRequest
import aws.sdk.kotlin.services.migrationhubstrategy.model.UpdateApplicationComponentConfigResponse
import aws.sdk.kotlin.services.migrationhubstrategy.model.UpdateServerConfigRequest
import aws.sdk.kotlin.services.migrationhubstrategy.model.UpdateServerConfigResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "MigrationHubStrategy"
public const val SdkVersion: String = "1.5.20"
public const val ServiceApiVersion: String = "2020-02-19"

/**
 * # Migration Hub Strategy Recommendations
 * This API reference provides descriptions, syntax, and other details about each of the actions and data types for Migration Hub Strategy Recommendations (Strategy Recommendations). The topic for each action shows the API request parameters and the response. Alternatively, you can use one of the AWS SDKs to access an API that is tailored to the programming language or platform that you're using. For more information, see [AWS SDKs](http://aws.amazon.com/tools/#SDKs).
 */
public interface MigrationHubStrategyClient : SdkClient {
    /**
     * MigrationHubStrategyClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, MigrationHubStrategyClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "MigrationHubStrategy",
                "MIGRATIONHUBSTRATEGY",
                "migrationhubstrategy",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, MigrationHubStrategyClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): MigrationHubStrategyClient = DefaultMigrationHubStrategyClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: MigrationHubStrategyEndpointProvider = builder.endpointProvider ?: DefaultMigrationHubStrategyEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: MigrationHubStrategyAuthSchemeProvider = builder.authSchemeProvider ?: DefaultMigrationHubStrategyAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "MigrationHubStrategy"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: MigrationHubStrategyEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: MigrationHubStrategyAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Retrieves details about an application component.
     */
    public suspend fun getApplicationComponentDetails(input: GetApplicationComponentDetailsRequest): GetApplicationComponentDetailsResponse

    /**
     * Retrieves a list of all the recommended strategies and tools for an application component running on a server.
     */
    public suspend fun getApplicationComponentStrategies(input: GetApplicationComponentStrategiesRequest): GetApplicationComponentStrategiesResponse

    /**
     * Retrieves the status of an on-going assessment.
     */
    public suspend fun getAssessment(input: GetAssessmentRequest): GetAssessmentResponse

    /**
     * Retrieves the details about a specific import task.
     */
    public suspend fun getImportFileTask(input: GetImportFileTaskRequest): GetImportFileTaskResponse

    /**
     * Retrieve the latest ID of a specific assessment task.
     */
    public suspend fun getLatestAssessmentId(input: GetLatestAssessmentIdRequest = GetLatestAssessmentIdRequest { }): GetLatestAssessmentIdResponse

    /**
     * Retrieves your migration and modernization preferences.
     */
    public suspend fun getPortfolioPreferences(input: GetPortfolioPreferencesRequest = GetPortfolioPreferencesRequest { }): GetPortfolioPreferencesResponse

    /**
     * Retrieves overall summary including the number of servers to rehost and the overall number of anti-patterns.
     */
    public suspend fun getPortfolioSummary(input: GetPortfolioSummaryRequest = GetPortfolioSummaryRequest { }): GetPortfolioSummaryResponse

    /**
     * Retrieves detailed information about the specified recommendation report.
     */
    public suspend fun getRecommendationReportDetails(input: GetRecommendationReportDetailsRequest): GetRecommendationReportDetailsResponse

    /**
     * Retrieves detailed information about a specified server.
     */
    public suspend fun getServerDetails(input: GetServerDetailsRequest): GetServerDetailsResponse

    /**
     * Retrieves recommended strategies and tools for the specified server.
     */
    public suspend fun getServerStrategies(input: GetServerStrategiesRequest): GetServerStrategiesResponse

    /**
     * Retrieves a list of all the servers fetched from customer vCenter using Strategy Recommendation Collector.
     *
     * @sample aws.sdk.kotlin.services.migrationhubstrategy.samples.ListAnalyzableServers.sample
     */
    public suspend fun listAnalyzableServers(input: ListAnalyzableServersRequest = ListAnalyzableServersRequest { }): ListAnalyzableServersResponse

    /**
     * Retrieves a list of all the application components (processes).
     */
    public suspend fun listApplicationComponents(input: ListApplicationComponentsRequest = ListApplicationComponentsRequest { }): ListApplicationComponentsResponse

    /**
     * Retrieves a list of all the installed collectors.
     */
    public suspend fun listCollectors(input: ListCollectorsRequest = ListCollectorsRequest { }): ListCollectorsResponse

    /**
     * Retrieves a list of all the imports performed.
     */
    public suspend fun listImportFileTask(input: ListImportFileTaskRequest = ListImportFileTaskRequest { }): ListImportFileTaskResponse

    /**
     * Returns a list of all the servers.
     */
    public suspend fun listServers(input: ListServersRequest = ListServersRequest { }): ListServersResponse

    /**
     * Saves the specified migration and modernization preferences.
     */
    public suspend fun putPortfolioPreferences(input: PutPortfolioPreferencesRequest = PutPortfolioPreferencesRequest { }): PutPortfolioPreferencesResponse

    /**
     * Starts the assessment of an on-premises environment.
     */
    public suspend fun startAssessment(input: StartAssessmentRequest = StartAssessmentRequest { }): StartAssessmentResponse

    /**
     * Starts a file import.
     */
    public suspend fun startImportFileTask(input: StartImportFileTaskRequest): StartImportFileTaskResponse

    /**
     * Starts generating a recommendation report.
     */
    public suspend fun startRecommendationReportGeneration(input: StartRecommendationReportGenerationRequest = StartRecommendationReportGenerationRequest { }): StartRecommendationReportGenerationResponse

    /**
     * Stops the assessment of an on-premises environment.
     */
    public suspend fun stopAssessment(input: StopAssessmentRequest): StopAssessmentResponse

    /**
     * Updates the configuration of an application component.
     */
    public suspend fun updateApplicationComponentConfig(input: UpdateApplicationComponentConfigRequest): UpdateApplicationComponentConfigResponse

    /**
     * Updates the configuration of the specified server.
     */
    public suspend fun updateServerConfig(input: UpdateServerConfigRequest): UpdateServerConfigResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun MigrationHubStrategyClient.withConfig(block: MigrationHubStrategyClient.Config.Builder.() -> Unit): MigrationHubStrategyClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultMigrationHubStrategyClient(newConfig)
}

/**
 * Retrieves details about an application component.
 */
public suspend inline fun MigrationHubStrategyClient.getApplicationComponentDetails(crossinline block: GetApplicationComponentDetailsRequest.Builder.() -> Unit): GetApplicationComponentDetailsResponse = getApplicationComponentDetails(GetApplicationComponentDetailsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of all the recommended strategies and tools for an application component running on a server.
 */
public suspend inline fun MigrationHubStrategyClient.getApplicationComponentStrategies(crossinline block: GetApplicationComponentStrategiesRequest.Builder.() -> Unit): GetApplicationComponentStrategiesResponse = getApplicationComponentStrategies(GetApplicationComponentStrategiesRequest.Builder().apply(block).build())

/**
 * Retrieves the status of an on-going assessment.
 */
public suspend inline fun MigrationHubStrategyClient.getAssessment(crossinline block: GetAssessmentRequest.Builder.() -> Unit): GetAssessmentResponse = getAssessment(GetAssessmentRequest.Builder().apply(block).build())

/**
 * Retrieves the details about a specific import task.
 */
public suspend inline fun MigrationHubStrategyClient.getImportFileTask(crossinline block: GetImportFileTaskRequest.Builder.() -> Unit): GetImportFileTaskResponse = getImportFileTask(GetImportFileTaskRequest.Builder().apply(block).build())

/**
 * Retrieve the latest ID of a specific assessment task.
 */
public suspend inline fun MigrationHubStrategyClient.getLatestAssessmentId(crossinline block: GetLatestAssessmentIdRequest.Builder.() -> Unit): GetLatestAssessmentIdResponse = getLatestAssessmentId(GetLatestAssessmentIdRequest.Builder().apply(block).build())

/**
 * Retrieves your migration and modernization preferences.
 */
public suspend inline fun MigrationHubStrategyClient.getPortfolioPreferences(crossinline block: GetPortfolioPreferencesRequest.Builder.() -> Unit): GetPortfolioPreferencesResponse = getPortfolioPreferences(GetPortfolioPreferencesRequest.Builder().apply(block).build())

/**
 * Retrieves overall summary including the number of servers to rehost and the overall number of anti-patterns.
 */
public suspend inline fun MigrationHubStrategyClient.getPortfolioSummary(crossinline block: GetPortfolioSummaryRequest.Builder.() -> Unit): GetPortfolioSummaryResponse = getPortfolioSummary(GetPortfolioSummaryRequest.Builder().apply(block).build())

/**
 * Retrieves detailed information about the specified recommendation report.
 */
public suspend inline fun MigrationHubStrategyClient.getRecommendationReportDetails(crossinline block: GetRecommendationReportDetailsRequest.Builder.() -> Unit): GetRecommendationReportDetailsResponse = getRecommendationReportDetails(GetRecommendationReportDetailsRequest.Builder().apply(block).build())

/**
 * Retrieves detailed information about a specified server.
 */
public suspend inline fun MigrationHubStrategyClient.getServerDetails(crossinline block: GetServerDetailsRequest.Builder.() -> Unit): GetServerDetailsResponse = getServerDetails(GetServerDetailsRequest.Builder().apply(block).build())

/**
 * Retrieves recommended strategies and tools for the specified server.
 */
public suspend inline fun MigrationHubStrategyClient.getServerStrategies(crossinline block: GetServerStrategiesRequest.Builder.() -> Unit): GetServerStrategiesResponse = getServerStrategies(GetServerStrategiesRequest.Builder().apply(block).build())

/**
 * Retrieves a list of all the servers fetched from customer vCenter using Strategy Recommendation Collector.
 *
 * @sample aws.sdk.kotlin.services.migrationhubstrategy.samples.ListAnalyzableServers.sample
 */
public suspend inline fun MigrationHubStrategyClient.listAnalyzableServers(crossinline block: ListAnalyzableServersRequest.Builder.() -> Unit): ListAnalyzableServersResponse = listAnalyzableServers(ListAnalyzableServersRequest.Builder().apply(block).build())

/**
 * Retrieves a list of all the application components (processes).
 */
public suspend inline fun MigrationHubStrategyClient.listApplicationComponents(crossinline block: ListApplicationComponentsRequest.Builder.() -> Unit): ListApplicationComponentsResponse = listApplicationComponents(ListApplicationComponentsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of all the installed collectors.
 */
public suspend inline fun MigrationHubStrategyClient.listCollectors(crossinline block: ListCollectorsRequest.Builder.() -> Unit): ListCollectorsResponse = listCollectors(ListCollectorsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of all the imports performed.
 */
public suspend inline fun MigrationHubStrategyClient.listImportFileTask(crossinline block: ListImportFileTaskRequest.Builder.() -> Unit): ListImportFileTaskResponse = listImportFileTask(ListImportFileTaskRequest.Builder().apply(block).build())

/**
 * Returns a list of all the servers.
 */
public suspend inline fun MigrationHubStrategyClient.listServers(crossinline block: ListServersRequest.Builder.() -> Unit): ListServersResponse = listServers(ListServersRequest.Builder().apply(block).build())

/**
 * Saves the specified migration and modernization preferences.
 */
public suspend inline fun MigrationHubStrategyClient.putPortfolioPreferences(crossinline block: PutPortfolioPreferencesRequest.Builder.() -> Unit): PutPortfolioPreferencesResponse = putPortfolioPreferences(PutPortfolioPreferencesRequest.Builder().apply(block).build())

/**
 * Starts the assessment of an on-premises environment.
 */
public suspend inline fun MigrationHubStrategyClient.startAssessment(crossinline block: StartAssessmentRequest.Builder.() -> Unit): StartAssessmentResponse = startAssessment(StartAssessmentRequest.Builder().apply(block).build())

/**
 * Starts a file import.
 */
public suspend inline fun MigrationHubStrategyClient.startImportFileTask(crossinline block: StartImportFileTaskRequest.Builder.() -> Unit): StartImportFileTaskResponse = startImportFileTask(StartImportFileTaskRequest.Builder().apply(block).build())

/**
 * Starts generating a recommendation report.
 */
public suspend inline fun MigrationHubStrategyClient.startRecommendationReportGeneration(crossinline block: StartRecommendationReportGenerationRequest.Builder.() -> Unit): StartRecommendationReportGenerationResponse = startRecommendationReportGeneration(StartRecommendationReportGenerationRequest.Builder().apply(block).build())

/**
 * Stops the assessment of an on-premises environment.
 */
public suspend inline fun MigrationHubStrategyClient.stopAssessment(crossinline block: StopAssessmentRequest.Builder.() -> Unit): StopAssessmentResponse = stopAssessment(StopAssessmentRequest.Builder().apply(block).build())

/**
 * Updates the configuration of an application component.
 */
public suspend inline fun MigrationHubStrategyClient.updateApplicationComponentConfig(crossinline block: UpdateApplicationComponentConfigRequest.Builder.() -> Unit): UpdateApplicationComponentConfigResponse = updateApplicationComponentConfig(UpdateApplicationComponentConfigRequest.Builder().apply(block).build())

/**
 * Updates the configuration of the specified server.
 */
public suspend inline fun MigrationHubStrategyClient.updateServerConfig(crossinline block: UpdateServerConfigRequest.Builder.() -> Unit): UpdateServerConfigResponse = updateServerConfig(UpdateServerConfigRequest.Builder().apply(block).build())
