// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhubstrategy.serde

import aws.sdk.kotlin.services.migrationhubstrategy.model.GetImportFileTaskResponse
import aws.sdk.kotlin.services.migrationhubstrategy.model.ImportFileTaskStatus
import aws.sdk.kotlin.services.migrationhubstrategy.model.MigrationHubStrategyException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetImportFileTaskOperationDeserializer: HttpDeserializer.NonStreaming<GetImportFileTaskResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetImportFileTaskResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetImportFileTaskError(context, call, payload)
        }
        val builder = GetImportFileTaskResponse.Builder()

        if (payload != null) {
            deserializeGetImportFileTaskOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetImportFileTaskError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MigrationHubStrategyException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> MigrationHubStrategyException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetImportFileTaskOperationBody(builder: GetImportFileTaskResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMPLETIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("completionTime"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val IMPORTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("importName"))
    val INPUTS3BUCKET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("inputS3Bucket"))
    val INPUTS3KEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("inputS3Key"))
    val NUMBEROFRECORDSFAILED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("numberOfRecordsFailed"))
    val NUMBEROFRECORDSSUCCESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("numberOfRecordsSuccess"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("startTime"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("status"))
    val STATUSREPORTS3BUCKET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("statusReportS3Bucket"))
    val STATUSREPORTS3KEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("statusReportS3Key"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMPLETIONTIME_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(IMPORTNAME_DESCRIPTOR)
        field(INPUTS3BUCKET_DESCRIPTOR)
        field(INPUTS3KEY_DESCRIPTOR)
        field(NUMBEROFRECORDSFAILED_DESCRIPTOR)
        field(NUMBEROFRECORDSSUCCESS_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSREPORTS3BUCKET_DESCRIPTOR)
        field(STATUSREPORTS3KEY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMPLETIONTIME_DESCRIPTOR.index -> builder.completionTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                IMPORTNAME_DESCRIPTOR.index -> builder.importName = deserializeString()
                INPUTS3BUCKET_DESCRIPTOR.index -> builder.inputS3Bucket = deserializeString()
                INPUTS3KEY_DESCRIPTOR.index -> builder.inputS3Key = deserializeString()
                NUMBEROFRECORDSFAILED_DESCRIPTOR.index -> builder.numberOfRecordsFailed = deserializeInt()
                NUMBEROFRECORDSSUCCESS_DESCRIPTOR.index -> builder.numberOfRecordsSuccess = deserializeInt()
                STARTTIME_DESCRIPTOR.index -> builder.startTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ImportFileTaskStatus.fromValue(it) }
                STATUSREPORTS3BUCKET_DESCRIPTOR.index -> builder.statusReportS3Bucket = deserializeString()
                STATUSREPORTS3KEY_DESCRIPTOR.index -> builder.statusReportS3Key = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
