// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhubstrategy.model

import aws.smithy.kotlin.runtime.SdkDsl

public class StartImportFileTaskRequest private constructor(builder: Builder) {
    /**
     * Specifies the source that the servers are coming from. By default, Strategy Recommendations assumes that the servers specified in the import file are available in AWS Application Discovery Service.
     */
    public val dataSourceType: aws.sdk.kotlin.services.migrationhubstrategy.model.DataSourceType? = builder.dataSourceType
    /**
     * Groups the resources in the import file together with a unique name. This ID can be as filter in `ListApplicationComponents` and `ListServers`.
     */
    public val groupId: List<Group>? = builder.groupId
    /**
     * A descriptive name for the request.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The S3 bucket where the import file is located. The bucket name is required to begin with `migrationhub-strategy-`.
     */
    public val s3Bucket: kotlin.String = requireNotNull(builder.s3Bucket) { "A non-null value must be provided for s3Bucket" }
    /**
     * The S3 bucket where Strategy Recommendations uploads import results. The bucket name is required to begin with migrationhub-strategy-.
     */
    public val s3BucketForReportData: kotlin.String? = builder.s3BucketForReportData
    /**
     * The Amazon S3 key name of the import file.
     */
    public val s3Key: kotlin.String = requireNotNull(builder.s3Key) { "A non-null value must be provided for s3Key" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.migrationhubstrategy.model.StartImportFileTaskRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartImportFileTaskRequest(")
        append("dataSourceType=$dataSourceType,")
        append("groupId=$groupId,")
        append("name=$name,")
        append("s3Bucket=$s3Bucket,")
        append("s3BucketForReportData=$s3BucketForReportData,")
        append("s3Key=$s3Key")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSourceType?.hashCode() ?: 0
        result = 31 * result + (groupId?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (s3Bucket.hashCode())
        result = 31 * result + (s3BucketForReportData?.hashCode() ?: 0)
        result = 31 * result + (s3Key.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartImportFileTaskRequest

        if (dataSourceType != other.dataSourceType) return false
        if (groupId != other.groupId) return false
        if (name != other.name) return false
        if (s3Bucket != other.s3Bucket) return false
        if (s3BucketForReportData != other.s3BucketForReportData) return false
        if (s3Key != other.s3Key) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.migrationhubstrategy.model.StartImportFileTaskRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the source that the servers are coming from. By default, Strategy Recommendations assumes that the servers specified in the import file are available in AWS Application Discovery Service.
         */
        public var dataSourceType: aws.sdk.kotlin.services.migrationhubstrategy.model.DataSourceType? = null
        /**
         * Groups the resources in the import file together with a unique name. This ID can be as filter in `ListApplicationComponents` and `ListServers`.
         */
        public var groupId: List<Group>? = null
        /**
         * A descriptive name for the request.
         */
        public var name: kotlin.String? = null
        /**
         * The S3 bucket where the import file is located. The bucket name is required to begin with `migrationhub-strategy-`.
         */
        public var s3Bucket: kotlin.String? = null
        /**
         * The S3 bucket where Strategy Recommendations uploads import results. The bucket name is required to begin with migrationhub-strategy-.
         */
        public var s3BucketForReportData: kotlin.String? = null
        /**
         * The Amazon S3 key name of the import file.
         */
        public var s3Key: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.migrationhubstrategy.model.StartImportFileTaskRequest) : this() {
            this.dataSourceType = x.dataSourceType
            this.groupId = x.groupId
            this.name = x.name
            this.s3Bucket = x.s3Bucket
            this.s3BucketForReportData = x.s3BucketForReportData
            this.s3Key = x.s3Key
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.migrationhubstrategy.model.StartImportFileTaskRequest = StartImportFileTaskRequest(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (s3Bucket == null) s3Bucket = ""
            if (s3Key == null) s3Key = ""
            return this
        }
    }
}
