// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhubstrategy.paginators

import aws.sdk.kotlin.services.migrationhubstrategy.MigrationHubStrategyClient
import aws.sdk.kotlin.services.migrationhubstrategy.model.AnalyzableServerSummary
import aws.sdk.kotlin.services.migrationhubstrategy.model.ApplicationComponentDetail
import aws.sdk.kotlin.services.migrationhubstrategy.model.AssociatedApplication
import aws.sdk.kotlin.services.migrationhubstrategy.model.Collector
import aws.sdk.kotlin.services.migrationhubstrategy.model.GetServerDetailsRequest
import aws.sdk.kotlin.services.migrationhubstrategy.model.GetServerDetailsResponse
import aws.sdk.kotlin.services.migrationhubstrategy.model.ImportFileTaskInformation
import aws.sdk.kotlin.services.migrationhubstrategy.model.ListAnalyzableServersRequest
import aws.sdk.kotlin.services.migrationhubstrategy.model.ListAnalyzableServersResponse
import aws.sdk.kotlin.services.migrationhubstrategy.model.ListApplicationComponentsRequest
import aws.sdk.kotlin.services.migrationhubstrategy.model.ListApplicationComponentsResponse
import aws.sdk.kotlin.services.migrationhubstrategy.model.ListCollectorsRequest
import aws.sdk.kotlin.services.migrationhubstrategy.model.ListCollectorsResponse
import aws.sdk.kotlin.services.migrationhubstrategy.model.ListImportFileTaskRequest
import aws.sdk.kotlin.services.migrationhubstrategy.model.ListImportFileTaskResponse
import aws.sdk.kotlin.services.migrationhubstrategy.model.ListServersRequest
import aws.sdk.kotlin.services.migrationhubstrategy.model.ListServersResponse
import aws.sdk.kotlin.services.migrationhubstrategy.model.ServerDetail
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [GetServerDetailsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetServerDetailsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetServerDetailsResponse]
 */
public fun MigrationHubStrategyClient.getServerDetailsPaginated(initialRequest: GetServerDetailsRequest): Flow<GetServerDetailsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getServerDetailsPaginated.getServerDetails(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetServerDetailsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetServerDetailsResponse]
 */
public fun MigrationHubStrategyClient.getServerDetailsPaginated(block: GetServerDetailsRequest.Builder.() -> Unit): Flow<GetServerDetailsResponse> =
    getServerDetailsPaginated(GetServerDetailsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getServerDetailsPaginated]
 * to access the nested member [AssociatedApplication]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AssociatedApplication]
 */
@JvmName("getServerDetailsResponseAssociatedApplication")
public fun Flow<GetServerDetailsResponse>.associatedApplications(): Flow<AssociatedApplication> =
    transform() { response ->
        response.associatedApplications?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAnalyzableServersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAnalyzableServersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAnalyzableServersResponse]
 */
public fun MigrationHubStrategyClient.listAnalyzableServersPaginated(initialRequest: ListAnalyzableServersRequest = ListAnalyzableServersRequest { }): Flow<ListAnalyzableServersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAnalyzableServersPaginated.listAnalyzableServers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAnalyzableServersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAnalyzableServersResponse]
 */
public fun MigrationHubStrategyClient.listAnalyzableServersPaginated(block: ListAnalyzableServersRequest.Builder.() -> Unit): Flow<ListAnalyzableServersResponse> =
    listAnalyzableServersPaginated(ListAnalyzableServersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAnalyzableServersPaginated]
 * to access the nested member [AnalyzableServerSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AnalyzableServerSummary]
 */
@JvmName("listAnalyzableServersResponseAnalyzableServerSummary")
public fun Flow<ListAnalyzableServersResponse>.analyzableServers(): Flow<AnalyzableServerSummary> =
    transform() { response ->
        response.analyzableServers?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListApplicationComponentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListApplicationComponentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationComponentsResponse]
 */
public fun MigrationHubStrategyClient.listApplicationComponentsPaginated(initialRequest: ListApplicationComponentsRequest = ListApplicationComponentsRequest { }): Flow<ListApplicationComponentsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listApplicationComponentsPaginated.listApplicationComponents(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListApplicationComponentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationComponentsResponse]
 */
public fun MigrationHubStrategyClient.listApplicationComponentsPaginated(block: ListApplicationComponentsRequest.Builder.() -> Unit): Flow<ListApplicationComponentsResponse> =
    listApplicationComponentsPaginated(ListApplicationComponentsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listApplicationComponentsPaginated]
 * to access the nested member [ApplicationComponentDetail]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ApplicationComponentDetail]
 */
@JvmName("listApplicationComponentsResponseApplicationComponentDetail")
public fun Flow<ListApplicationComponentsResponse>.applicationComponentInfos(): Flow<ApplicationComponentDetail> =
    transform() { response ->
        response.applicationComponentInfos?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCollectorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCollectorsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCollectorsResponse]
 */
public fun MigrationHubStrategyClient.listCollectorsPaginated(initialRequest: ListCollectorsRequest = ListCollectorsRequest { }): Flow<ListCollectorsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCollectorsPaginated.listCollectors(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCollectorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCollectorsResponse]
 */
public fun MigrationHubStrategyClient.listCollectorsPaginated(block: ListCollectorsRequest.Builder.() -> Unit): Flow<ListCollectorsResponse> =
    listCollectorsPaginated(ListCollectorsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCollectorsPaginated]
 * to access the nested member [Collector]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Collector]
 */
@JvmName("listCollectorsResponseCollector")
public fun Flow<ListCollectorsResponse>.collectors(): Flow<Collector> =
    transform() { response ->
        response.collectors?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListImportFileTaskResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListImportFileTaskRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImportFileTaskResponse]
 */
public fun MigrationHubStrategyClient.listImportFileTaskPaginated(initialRequest: ListImportFileTaskRequest = ListImportFileTaskRequest { }): Flow<ListImportFileTaskResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listImportFileTaskPaginated.listImportFileTask(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListImportFileTaskResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImportFileTaskResponse]
 */
public fun MigrationHubStrategyClient.listImportFileTaskPaginated(block: ListImportFileTaskRequest.Builder.() -> Unit): Flow<ListImportFileTaskResponse> =
    listImportFileTaskPaginated(ListImportFileTaskRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listImportFileTaskPaginated]
 * to access the nested member [ImportFileTaskInformation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ImportFileTaskInformation]
 */
@JvmName("listImportFileTaskResponseImportFileTaskInformation")
public fun Flow<ListImportFileTaskResponse>.taskInfos(): Flow<ImportFileTaskInformation> =
    transform() { response ->
        response.taskInfos?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListServersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListServersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServersResponse]
 */
public fun MigrationHubStrategyClient.listServersPaginated(initialRequest: ListServersRequest = ListServersRequest { }): Flow<ListServersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listServersPaginated.listServers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListServersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServersResponse]
 */
public fun MigrationHubStrategyClient.listServersPaginated(block: ListServersRequest.Builder.() -> Unit): Flow<ListServersResponse> =
    listServersPaginated(ListServersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listServersPaginated]
 * to access the nested member [ServerDetail]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ServerDetail]
 */
@JvmName("listServersResponseServerDetail")
public fun Flow<ListServersResponse>.serverInfos(): Flow<ServerDetail> =
    transform() { response ->
        response.serverInfos?.forEach {
            emit(it)
        }
    }
